%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or of its NBER or CEPR working paper %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Last revised: May 26, 2007                                         %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Maximizing the Welfare for different Taylor Rules involving l      %
%Input: USGpost and EMUpost                                         %
%Output: on the screen, optimal Taylor rule                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N pars a b c d

%%%%% STEP 0: CHOICES %%%%%
Sample = 1;                         %Pick, 1 - USG; 2 - EMU
N = 200;                            %Length of impulse responses
startUSG = [0.69 4.66]; startEMU = [0.12 3.75];   %search start-point and grid mid-point
increments = [0.01 0.01];           %increments in grid
ubUSG = 0.085; ubEMU=0.01;           %loss lower bound for plotting
grids = 15;                         %grid points, must be odd
lb=[-10,1.01]; ub=[20;20];          %bounds for search

%%%%% STEP 1: LOADING PARAMETERS%%%%%
%%%%% STEP 1: LOADING PARAMETERS%%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
if Sample==1; load OMPR_USGpost_stats est_mean; disp('~~USGSPAN sample~~~~~');
elseif Sample==2; load OMPR_EMUpost_stats est_mean; disp('~~EMU sample~~~~~~');
end; disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');
pars = est_mean'; clear est_mean;
pars(8) = 0; pars(9) = 0;   %rho and sigma for m
[a b c d] = SIPRll(pars);  %solution of model

%%%%% STEP 2: FINDING MAXIMUM WELFARE%%%%%
if Sample==1; tronl0 = startUSG; elseif Sample==2; tronl0=startEMU; end;
options = optimset('MaxFunEvals',1000000);  %options
%[opt_tronl Wtronl] = fmincon(@SIPRtrwonl,tronl0,[],[],[],[],lb,ub,[],options);
%[opt_tronl Wtronl] = fminunc(@SIPRtrwonl,tronl0,options);     %check 1
[opt_tronl Wtronl] = fminsearch(@SIPRtrwonl,tronl0,options);  %check 2
opt_pars=pars; opt_pars(6) = opt_tronl(1); opt_pars(7) = opt_tronl(2); %parameter vector at optimum
opt_tronl_p = SIPRtrp(opt_pars,'tronl');                 %optimal p path
disp(' '); disp('~~Components of optimal welfare loss');
disp([SIPRw('m',pars,opt_tronl_p,a,b,c,d) ...
    SIPRw('a',pars,opt_tronl_p,a,b,c,d) ...
    SIPRw('g',pars,opt_tronl_p,a,b,c,d) ...
    SIPRw('nuu',pars,opt_tronl_p,a,b,c,d) ...
    SIPRw('gam',pars,opt_tronl_p,a,b,c,d)]);

%%%%% STEP 3: GRID TO LOOK BETTER AT FEATURES OF OPTIMUM
A=[];       %grid storing for search
if Sample==1; start=startUSG; ubA=ubUSG;
elseif Sample==2; start=startEMU; ubA=ubEMU; end
start = start - increments*(grids-1)/2 - increments;
if start(2)<1; error('Trying phipi<1. Raise start or lower increments'); end
for i=1:grids; grid(i,1:2) = start + increments*i; end
h = waitbar(0,'...Iterating over grid...');
for j=1:grids
    for k=1:grids; A(j,k)=SIPRtrwonl([grid(j,1);grid(k,2)]);  end
    waitbar(j/grids,h);
end
close(h);
Atemp=A; 
for i=1:grids; for j=1:grids; if A(i,j)>ubA; Atemp(i,j)=NaN; end; end; end; %pick to draw nicer
Atemp=-Atemp; surf(Atemp); title('Welfare trying to maximise')
%Check
if min(min(A))-Wtronl<0; disp('~~fmincon did not find global minimum'); end; disp(' ');
[temp1 temp2] = min(A); [Wtr_alt temp3] = min(temp1);
alt_tr=[grid(temp2(temp3),1); grid(temp3,2)];
disp('~~Grid-search optimum and loss are'); disp([alt_tr' Wtr_alt]);
clear temp1 temp2 temp3 tronl0 h i j k startUSG startEMU ubA lb ub ...
    N pars options start
disp(grid)
%%%%% STEP 4: DISPLAYING %%%%%%
clear Wtr_alt alt_tr a b c d tronlUSG tronlEMU A Atemp opt_p opt_pars ...
    ubUSG ubEMU increments grids grid ans
disp('##########################################################')
disp('Parameters:  ')
disp('    phi_y     phi_pi'); disp(opt_tronl)
disp('   path of prices '); disp(opt_tronl_p(1:10,:))
disp('Welfare value:'); disp(Wtronl)
disp('##########################################################')