function [a b c d] = SIPRll(pars)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or its NBER or CEPR working paper    %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: welfare parameters                                      %
%Last revised: October 30, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: full set parameters, even though policy parameters not used %
%Output: The a, b, c, d coefficients in l_tilda and l_invhat        %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N

%%%%STEP 1: RECOVER PARAMETERS %%%%%
beta=pars(1); psi=pars(2); nu=pars(4); gamma=pars(5);
rho_m=pars(8); rho_a=pars(10); rho_g=pars(12); rho_nu=pars(14); rho_gam=pars(16);
%theta=pars(3); phiy=pars(6); phipi=pars(7); 
%delta=pars(18); omega=pars(19); lambda=pars(20);
%sigma_nu=pars(15); sigma_a=pars(11);  sigma_m=pars(9); sigma_g=pars(13);
%sigma_gam=pars(17);

%%%%STEP 2: MODEL DELTA, OMEGA, LAMBDA and PSI + UPSILON%%%%%%
[DELTA OMEGA LAMBDA PSI UPSILON] = SIPRmodel(pars);
UPSILON_a=UPSILON(:,1); UPSILON_g=UPSILON(:,2); UPSILON_nu=UPSILON(:,3);
    UPSILON_gam=UPSILON(:,4);

%%%%STEP 3: COEFFICIENTS INVARIANT TO SHOCK: a(i) and c(i) %%%%%%%
for i=1:N+1;
    z =  1 + (1+nu*(1/beta-1))*(1/LAMBDA(i,1)-1);
    k(i) = 1/(gamma*beta) + 1 - 1/beta - 1/DELTA(i);
    a(i) = PSI(i,1)*((1-gamma)/beta + gamma) + gamma*z;
    c(i) = ((gamma*psi)/(gamma+psi)) * (PSI(i)*k(i) + z - 1);
end

%%%%STEP 4: COEFFICIENTS THAT DEPEND ON SHOCK %%%%%%%
%monetary shocks -- m
b=zeros(N+1,1); d=zeros(N+1,1);
%technology shock -- a
for i=1:N+1;
    b(i,2) = ((1-rho_a^(i))/(1-rho_a))*((gamma-1)/beta + UPSILON_a(i,1)*(gamma+(1-gamma)/beta));
    d(i,2) = ((1-rho_a^(i))/(1-rho_a))*(UPSILON_a(i,1)*k(i)+(gamma-1)/(beta*gamma));
end
%aggregate demand shock -- g
for i=1:N+1;
    b(i,3) = (rho_g^(i-1))*UPSILON_g(i,1)*(gamma+(1-gamma)/beta);
    d(i,3) = (rho_g^(i-1))*(k(i)*UPSILON_g(i,1)-1/DELTA(i));
end
%goods markup shock -- nu
for i=1:N+1;
    b(i,4) = (rho_nu^(i-1))*(UPSILON_nu(i,1)*(gamma+(1-gamma)/beta) + gamma/(nu-1));
    d(i,4) = (rho_nu^(i-1))*(k(i)*UPSILON_nu(i,1)+1/(nu-1));
end
%labor markup shock -- gam
for i=1:N+1;
    b(i,5) = (rho_gam^(i-1))*UPSILON_gam(i,1)*(gamma+(1-gamma)/beta);
    d(i,5) = (rho_gam^(i-1))*(k(i)*UPSILON_gam(i,1)+1/(gamma-1));
end