function [ma_m ma_a ma_g ma_nu ma_gam] = SIPRma(pars,p)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%Mankiw, N. Gregory and Ricardo Reis (2007) "Sticky Information in  %
%General Equilibrium," Journal of the European Economic Association,%
%forthcoming. See the appendix of the NBER or CEPR working paper    %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Last revised: August 30, 2006                                      %
%Written by: Ricardo Reis                                           %
%Input: parameters                                                  %
%Output: solution of the model as coefficients in MA representation %
%        (inflation output nomrate realwage hours gap)              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N

%%%%STEP 1: RECOVER PARAMETERS %%%%%
beta=pars(1); psi=pars(2); theta=pars(3); nu=pars(4); gamma=pars(5);
rho_a=pars(10); rho_g=pars(12); rho_nu=pars(14); rho_gam=pars(16);
%phiy=pars(6); phipi=pars(7); rho_m=pars(8); %policy-independent crucial
%delta=pars(18); omega=pars(19); lambda=pars(20);
%sigma_nu=pars(15); sigma_a=pars(11);  sigma_m=pars(9); sigma_g=pars(13);
%sigma_gam=pars(17); %The variances are not necessary
%Natural rate parameters
xi_a=(1+1/psi)/(1+1/psi+beta/theta-beta);
xi_g=(beta/theta)/(1+1/psi+beta/theta-beta);
xi_gam=(beta/(gamma-1))/(1+1/psi+beta/theta-beta);
xi_nu=(beta/(nu-1))/(1+1/psi+beta/theta-beta);
%%%%STEP 2: MODEL DELTA, OMEGA, LAMBDA and PSI + UPSILON%%%%%%
[DELTA OMEGA LAMBDA PSI UPSILON] = SIPRmodel(pars);
UPSILON_a=UPSILON(:,1); UPSILON_g=UPSILON(:,2); UPSILON_nu=UPSILON(:,3);
UPSILON_gam=UPSILON(:,4);

%%%%STEP 4: SOLVE SYSTEM H*p=C TO GET PATH FOR PRICES %%%%%%%
%monetary shocks
path=p(1:N+1,1);
inflation(1:N+1,1)=path(1:N+1,1)-[0;path(1:N,1)];
output=PSI(1:N+1,1).*path; output(N+2,1)=0; inflation(N+2,1)=0;
for i=1:N+1;
    nomrate(i,1)=(1/theta)*(output(i+1,1)/DELTA(i+1,1)-output(i,1)/DELTA(i,1)) + inflation(i+1,1);
    realwage(i,1)=(1+nu*(1/beta-1))*(1/LAMBDA(i,1)-1)*path(i,1)+(1-1/beta)*output(i,1);
    hours(i,1)=output(i,1)/beta;
end
ma_m=[inflation(1:N+1,1) output(1:N+1,1) nomrate realwage hours output(1:N+1,1)];
clear path inflation output realwage nomrate hours
%technology shock
path=p(1:N+1,2);
inflation(1:N+1,1)=path(1:N+1,1)-[0;path(1:N,1)]; inflation(N+2,1)=0; path(N+2,1)=path(N+1,1);
output(1,1)=PSI(1,1)*path(1,1)+UPSILON_a(1,1);
for i=1:N+1;
    output(i+1,1)=PSI(i+1,1)*path(i+1,1)+UPSILON_a(i+1,1)*(1-rho_a^(i+1))/(1-rho_a);
    nomrate(i,1)=(1/theta)*(output(i+1,1)/DELTA(i+1,1)-output(i,1)/DELTA(i,1)) + inflation(i+1,1);
    realwage(i,1)=(1+nu*(1/beta-1))*(1/LAMBDA(i,1)-1)*path(i,1)+(1-1/beta)*output(i,1)+(1-rho_a^i)/(beta*(1-rho_a));
    hours(i,1)=output(i,1)/beta-(1-rho_a^i)/(beta*(1-rho_a));
    gap(i,1)=output(i,1)-xi_a*(1-rho_a^i)/(1-rho_a);
end
ma_a=[inflation(1:N+1,1) output(1:N+1,1) nomrate realwage hours gap];
clear path inflation output realwage nomrate hours gap
%aggregate demand shock
path=p(1:N+1,3);
inflation(1:N+1,1)=path(1:N+1,1)-[0;path(1:N,1)]; inflation(N+2,1)=0; path(N+2,1)=path(N+1,1);
output(1,1)=PSI(1,1)*path(1,1)+UPSILON_g(1,1);
for i=1:N+1;
    output(i+1,1)=PSI(i+1,1)*path(i+1,1)+UPSILON_g(i+1,1)*rho_g^i;
    nomrate(i,1)=(1/theta)*((output(i+1,1)-rho_g^i)/DELTA(i+1,1)-(output(i,1)-rho_g^(i-1))/DELTA(i,1)) + inflation(i+1,1);
    realwage(i,1)=(1+nu*(1/beta-1))*(1/LAMBDA(i,1)-1)*path(i,1)+(1-1/beta)*output(i,1);
    hours(i,1)=output(i,1)/beta;
    gap(i,1)=output(i,1)-xi_g*rho_g^(i-1);
end
ma_g=[inflation(1:N+1,1) output(1:N+1,1) nomrate realwage hours gap];
clear path inflation output realwage nomrate hours gap
%goods markup shock
path=p(1:N+1,4);
inflation(1:N+1,1)=path(1:N+1,1)-[0;path(1:N,1)]; inflation(N+2,1)=0; path(N+2,1)=path(N+1,1);
output(1,1)=PSI(1,1)*path(1,1)+UPSILON_nu(1,1);
for i=1:N+1;
    output(i+1,1)=PSI(i+1,1)*path(i+1,1)+UPSILON_nu(i+1,1)*rho_nu^i;
    nomrate(i,1)=(1/theta)*(output(i+1,1)/DELTA(i+1,1)-output(i,1)/DELTA(i,1)) + inflation(i+1,1);
    realwage(i,1)=(1+nu*(1/beta-1))*(1/LAMBDA(i,1)-1)*path(i,1)+(1-1/beta)*output(i,1)+(rho_nu^(i-1))/(nu-1);
    hours(i,1)=output(i,1)/beta;
    gap(i,1)=output(i,1)-xi_nu*rho_nu^(i-1);
end
ma_nu=[inflation(1:N+1,1) output(1:N+1,1) nomrate realwage hours gap];
clear path inflation output realwage nomrate hours gap
%labor markup shock
path=p(1:N+1,5);
inflation(1:N+1,1)=path(1:N+1,1)-[0;path(1:N,1)]; inflation(N+2,1)=0; path(N+2,1)=path(N+1,1);
output(1,1)=PSI(1,1)*path(1,1)+UPSILON_gam(1,1);
for i=1:N+1;
    output(i+1,1)=PSI(i+1,1)*path(i+1,1)+UPSILON_gam(i+1,1)*rho_gam^i;
    nomrate(i,1)=(1/theta)*(output(i+1,1)/DELTA(i+1,1)-output(i,1)/DELTA(i,1)) + inflation(i+1,1);
    realwage(i,1)=(1+nu*(1/beta-1))*(1/LAMBDA(i,1)-1)*path(i,1)+(1-1/beta)*output(i,1);
    hours(i,1)=output(i,1)/beta;
    gap(i,1)=output(i,1)-xi_gam*rho_gam^(i-1);
end
ma_gam=[inflation(1:N+1,1) output(1:N+1,1) nomrate realwage hours gap];
clear path inflation output realwage nomrate hours gap
