function [DELTA OMEGA LAMBDA PSI UPSILON] = SIPRmodel(pars)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%Mankiw, N. Gregory and Ricardo Reis (2007) "Sticky Information in  %
%General Equilibrium," Journal of the European Economic Association,%
%forthcoming. See the appendix of the NBER or CEPR working paper    %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Last revised: August 30, 2006                                      %
%Written by: Ricardo Reis                                           %
%Input: parameters                                                  %
%Output: solution of the model                                      %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N

%%%%STEP 1: RECOVER PARAMETERS %%%%%
beta=pars(1); psi=pars(2); theta=pars(3); nu=pars(4); gamma=pars(5);
%phiy=pars(6); phipi=pars(7); rho_m=pars(8); rho_a=pars(10); rho_g=pars(12);
%rho_nu=pars(14); rho_gam=pars(16);
delta=pars(18); omega=pars(19); lambda=pars(20);
%sigma_nu=pars(15); sigma_a=pars(11);  sigma_m=pars(9); sigma_g=pars(13);
%sigma_gam=pars(17); %The variances are not necessary

%%%%STEP 2: DELTA, OMEGA, LAMBDA and PSI + UPSILON%%%%%%
DELTA(1,1)=delta; OMEGA(1,1)=omega; LAMBDA(1,1)=lambda;
temp1=theta*DELTA(1,1)*((psi+gamma*(1-OMEGA(1,1)))*((beta+nu*(1-beta))/LAMBDA(1,1)-nu*(1-beta))-beta*psi*OMEGA(1,1));
temp2=(1-beta)*(gamma+psi)*theta*DELTA(1,1)+OMEGA(1,1)*(theta*DELTA(1,1)*(1-gamma*(1-beta))+psi*beta);
PSI(1,1)=temp1/temp2;
UPSILON_a(1,1)=(theta*DELTA(1,1)*(gamma+psi+OMEGA(1,1)*(1-gamma)))/temp2;
UPSILON_g(1,1)=(beta*psi*OMEGA(1,1))/temp2;
UPSILON_nu(1,1)=beta*theta*DELTA(1,1)*(psi+gamma*(1-OMEGA(1,1)))/(temp2*(nu-1));
UPSILON_gam(1,1)=beta*theta*psi*DELTA(1,1)*OMEGA(1,1)/(temp2*(gamma-1));
for i=2:N+2;
    DELTA(i,1)=DELTA(i-1,1)+delta*(1-delta)^(i-1);
    OMEGA(i,1)=OMEGA(i-1,1)+omega*(1-omega)^(i-1);
    LAMBDA(i,1)=LAMBDA(i-1,1)+lambda*(1-lambda)^(i-1);
    temp1=theta*DELTA(i,1)*((psi+gamma*(1-OMEGA(i,1)))*((beta+nu*(1-beta))/LAMBDA(i,1)-nu*(1-beta))-beta*psi*OMEGA(i,1));
    temp2=(1-beta)*(gamma+psi)*theta*DELTA(i,1)+OMEGA(i,1)*(theta*DELTA(i,1)*(1-gamma*(1-beta))+psi*beta);
    PSI(i,1)=temp1/temp2;
    UPSILON_a(i,1)=(theta*DELTA(i,1)*(gamma+psi+OMEGA(i,1)*(1-gamma)))/temp2;
    UPSILON_g(i,1)=(beta*psi*OMEGA(i,1))/temp2;
    UPSILON_nu(i,1)=beta*theta*DELTA(i,1)*(psi+gamma*(1-OMEGA(i,1)))/(temp2*(nu-1));
    UPSILON_gam(i,1)=beta*theta*psi*DELTA(i,1)*OMEGA(i,1)/(temp2*(gamma-1));
end
UPSILON=[UPSILON_a UPSILON_g UPSILON_nu UPSILON_gam];