function p = SIPRpypin(pars,py)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or of its NBER or CEPR working paper %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Last revised: October 30, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: py parameter in price-standard rule, parameters             %
%Output: Resulting p path form this rule                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N

%%%%STEP 1.1: RECOVER PARAMETERS %%%%%
beta=pars(1); psi=pars(2); theta=pars(3); nu=pars(4); gamma=pars(5);
%phiy=pars(6); phipi=pars(7); rho_m=pars(8);
rho_a=pars(10); rho_g=pars(12);
rho_nu=pars(14); rho_gam=pars(16);
%delta=pars(18); omega=pars(19); lambda=pars(20);
%Natural rate parameters
xi_a=(1+1/psi)/(1+1/psi+beta/theta-beta);
xi_g=(beta/theta)/(1+1/psi+beta/theta-beta);

 %xi_gam=(beta/(gamma-1))/(1+1/psi+beta/theta-beta);    %change here
 %xi_nu=(beta/(nu-1))/(1+1/psi+beta/theta-beta);        %change here
 xi_gam=0; xi_nu=0; %change here, all else unchanged
 
%%%%STEP 1: MODEL DELTA, OMEGA, LAMBDA and PSI + UPSILON%%%%%%
[DELTA OMEGA LAMBDA PSI UPSILON] = SIPRmodel(pars);
UPSILON_a=UPSILON(:,1); UPSILON_g=UPSILON(:,2); UPSILON_nu=UPSILON(:,3);
UPSILON_gam=UPSILON(:,4);

%%%%STEP 3: BUILD DIFFERENCE EQUATION%%%%%%
rho=py(2); py=py(1);
    B(1,1)=1-py*PSI(1,1);
    C_a(1,1)=py*(UPSILON_a(1,1)-xi_a);
    C_g(1,1)=py*(UPSILON_g(1,1)-xi_g);
    C_gam(1,1)=py*(UPSILON_gam(1,1)-xi_gam);
    C_nu(1,1)=py*(UPSILON_nu(1,1)-xi_nu);
    for i=2:N+1;
        B(i,1)=1-py*PSI(i,1);
        C_a(i,1)=(1/(1-rho_a))*(1-rho_a^i)*py*(UPSILON_a(i,1)-xi_a);
        C_g(i,1)=(rho_g^(i-1))*py*(UPSILON_g(i,1)-xi_g);
        C_gam(i,1)=(rho_gam^(i-1))*py*(UPSILON_gam(i,1)-xi_gam);
        C_nu(i,1)=(rho_nu^(i-1))*py*(UPSILON_nu(i,1)-xi_nu);
    end
    H(1,:)=[B(1,1) zeros(1,N)];
    H(2,:)=[-rho B(2,1) zeros(1,N-1)];
    for i=3:N
        H(i,:)=[zeros(1,i-2) -rho B(i,1) zeros(1,N+1-i)];
    end
    H(N+1,:)=[zeros(1,N-1) 1 -1];
%Finally find price paths
%monetary shocks
p(1:N+1,1) = zeros(N+1,1);
%technology shock
p(:,2)=H\[C_a(1:N,1); 0];
%aggregate demand shock
p(:,3)=H\[C_g(1:N,1); 0];
%goods markup shock
p(:,4)=H\[C_nu(1:N,1); 0];
%labor markup shock
p(:,5)=H\[C_gam(1:N,1); 0];