function p = SIPRpypwage(pars,py)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or of its NBER or CEPR working paper %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Last revised: October 30, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: py parameter in price-standard rule, parameters             %
%Output: Resulting p path form this rule                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N

%%%%STEP 1.1: RECOVER PARAMETERS %%%%%
beta=pars(1); psi=pars(2); theta=pars(3); nu=pars(4); gamma=pars(5);
%phiy=pars(6); phipi=pars(7); rho_m=pars(8);
rho_a=pars(10); rho_g=pars(12);
rho_nu=pars(14); rho_gam=pars(16);
%delta=pars(18); omega=pars(19); lambda=pars(20);
%Natural rate parameters
xi_a=(1+1/psi)/(1+1/psi+beta/theta-beta);
xi_g=(beta/theta)/(1+1/psi+beta/theta-beta);

  %xi_gam=(beta/(gamma-1))/(1+1/psi+beta/theta-beta);
  %xi_nu=(beta/(nu-1))/(1+1/psi+beta/theta-beta);
  xi_gam=0; xi_nu=0;
  
%%%%STEP 1: MODEL DELTA, OMEGA, LAMBDA and PSI + UPSILON%%%%%%
[DELTA OMEGA LAMBDA PSI UPSILON] = SIPRmodel(pars);
UPSILON_a=UPSILON(:,1); UPSILON_g=UPSILON(:,2); UPSILON_nu=UPSILON(:,3);
UPSILON_gam=UPSILON(:,4);
%%%%STEP 1: PATH FOR PRICES FROM EXACT EQUATIONS %%%%%
G1 = 1 + (1+nu*(1/beta-1))*(1/LAMBDA(1,1)-1); G2=(1/beta-1);
p(1:N+1,1) = zeros(N+1,1);
p(1,2) = ((py-G2)*UPSILON_a(1,1)-py*xi_a)/(G1-(py-G2)*PSI(1,1));
p(1,3) = ((py-G2)*UPSILON_g(1,1)-py*xi_g)/(G1-(py-G2)*PSI(1,1));
p(1,4) = ((py-G2)*UPSILON_nu(1,1)-py*xi_nu)/(G1-(py-G2)*PSI(1,1));
p(1,5) = ((py-G2)*UPSILON_gam(1,1)-py*xi_gam)/(G1-(py-G2)*PSI(1,1));
for i=2:N+1
    G1 = 1 + (1+nu*(1/beta-1))*(1/LAMBDA(i,1)-1);
    p(i,2) = (((py-G2)*UPSILON_a(i,1)-py*xi_a)*(1-rho_a^(i))/(1-rho_a))/(G1-(py-G2)*PSI(i,1));
    p(i,3) = (((py-G2)*UPSILON_g(i,1)-py*xi_g)*rho_g^(i-1))/(G1-(py-G2)*PSI(i,1));
    p(i,4) = (((py-G2)*UPSILON_nu(i,1)-py*xi_nu)*rho_nu^(i-1))/(G1-(py-G2)*PSI(i,1));
    p(i,5) = (((py-G2)*UPSILON_gam(i,1)-py*xi_gam)*rho_gam^(i-1))/(G1-(py-G2)*PSI(i,1));
end
