function W = SIPRpywspg(py)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or of its NBER or CEPR working paper %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Last revised: October 30, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: py parameter                                                %
%Output: Welfare from a particular price-standard rule              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N pars a b c d
p = SIPRpypspg(pars,py);             %Get p path
W = SIPRw('all',pars,p,a,b,c,d);  %evaluate welfare