function [H C] = SIPRtronl(pars,DELTA,OMEGA,LAMBDA,PSI,UPSILON)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%Mankiw, N. Gregory and Ricardo Reis (2007) "Sticky Information in  %
%General Equilibrium," Journal of the European Economic Association,%
%forthcoming. See the appendix of the NBER or CEPR working paper    %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Last revised: August 30, 2006                                      %
%Written by: Ricardo Reis                                           %
%Input: parameters                                                  %
%Output: solution of the model as coefficients in MA representation %
%         (inflation output-growth nominal-rate wage-growth hours   %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N

%%%%STEP 1: RECOVER PARAMETERS %%%%%
beta=pars(1); psi=pars(2); theta=pars(3); nu=pars(4); gamma=pars(5);
phiy=pars(6); phipi=pars(7); rho_m=pars(8); rho_a=pars(10); rho_g=pars(12);
rho_nu=pars(14); rho_gam=pars(16);
%delta=pars(18); omega=pars(19); lambda=pars(20);
%sigma_nu=pars(15); sigma_a=pars(11);  sigma_m=pars(9); sigma_g=pars(13);
%sigma_gam=pars(17);
UPSILON_a=UPSILON(:,1); UPSILON_g=UPSILON(:,2); UPSILON_nu=UPSILON(:,3);
UPSILON_gam=UPSILON(:,4);

%%%%STEP 3: BUILD DIFFERENCE EQUATION%%%%%%
A(1,1)=1+PSI(1,1)/(theta*DELTA(1,1));
B(1,1)=A(1,1)+phipi+(phiy/beta)*PSI(1,1);
C_m(1,1)=-1;
C_a(1,1)=(phiy/beta)*(UPSILON_a(1,1)-1)+UPSILON_a(1,1)/(theta*DELTA(1,1))-(1+rho_a)*UPSILON_a(2,1)/(theta*DELTA(2,1));
C_g(1,1)=(1-UPSILON_g(2,1))*rho_g/(theta*DELTA(2,1))-(1-UPSILON_g(1,1))/(theta*DELTA(1,1))+(phiy/beta)*UPSILON_g(1,1);
C_gam(1,1)=(phiy/beta+1/(theta*DELTA(1,1)))*UPSILON_gam(1,1)-rho_gam*UPSILON_gam(2,1)/(theta*DELTA(2,1));
C_nu(1,1)=(phiy/beta+1/(theta*DELTA(1,1)))*UPSILON_nu(1,1)-rho_nu*UPSILON_nu(2,1)/(theta*DELTA(2,1));
for i=2:N+1;
    A(i,1)=1+PSI(i,1)/(theta*DELTA(i,1));
    B(i,1)=A(i,1)+phipi+(phiy/beta)*PSI(i,1);
    C_m(i,1)=-rho_m^(i-1);
    C_a(i,1)=(1/(1-rho_a))*((1-rho_a^i)*((phiy/beta)*(UPSILON_a(i,1)-1)+UPSILON_a(i,1)/(theta*DELTA(i,1)))-(1-rho_a^(i+1))*UPSILON_a(i+1,1)/(theta*DELTA(i+1,1)));
    C_g(i,1)=(rho_g^(i-1))*((1-UPSILON_g(i+1,1))*rho_g/(theta*DELTA(i+1,1))-(1-UPSILON_g(i,1))/(theta*DELTA(i,1))+(phiy/beta)*UPSILON_g(i,1));
    C_gam(i,1)=(rho_gam^(i-1))*((phiy/beta+1/(theta*DELTA(i,1)))*UPSILON_gam(i,1)-rho_gam*UPSILON_gam(i+1,1)/(theta*DELTA(i+1,1)));
    C_nu(i,1)=(rho_nu^(i-1))*((phiy/beta+1/(theta*DELTA(i,1)))*UPSILON_nu(i,1)-rho_nu*UPSILON_nu(i+1,1)/(theta*DELTA(i+1,1)));
end
C=[C_m C_a C_g C_nu C_gam];
H(1,:)=[-B(1,1) A(2,1) zeros(1,N-1)];
H(2,:)=[phipi -B(2,1) A(3,1) zeros(1,N-2)];
for i=3:N
    H(i,:)=[zeros(1,i-2) phipi -B(i,1) A(i+1,1) zeros(1,N-i)];
end
H(N+1,:)=[zeros(1,N-1) 1 -1];