function p = SIPRtrp(pars,setup)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or of its NBER or CEPR working paper %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Last revised: October 30, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: parameters                                                  %
%Output: Price path for a set of parameters and a Taylor rule       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N

%%%%STEP 1: MODEL DELTA, OMEGA, LAMBDA and PSI + UPSILON%%%%%%
[DELTA OMEGA LAMBDA PSI UPSILON] = SIPRmodel(pars);

%%%%STEP 2: BUILD DIFFERENCE EQUATION%%%%%%
if strcmp(setup,'tronl')==1;
    [H C] = SIPRtronl(pars,DELTA,OMEGA,LAMBDA,PSI,UPSILON);
elseif strcmp(setup,'tr')==1;
    [H C] = SIPRtr(pars,DELTA,OMEGA,LAMBDA,PSI,UPSILON);
elseif strcmp(setup,'speed')==1;
    [H C] = SIPRtrspeed(pars,DELTA,OMEGA,LAMBDA,PSI,UPSILON);
elseif strcmp(setup,'trspg')==1;
    [H C] = SIPRtrspg(pars,DELTA,OMEGA,LAMBDA,PSI,UPSILON);
elseif strcmp(setup,'inertia')==1;
    [H C] = SIPRtrin(pars,DELTA,OMEGA,LAMBDA,PSI,UPSILON);
elseif strcmp(setup,'wage')==1;
    [H C] = SIPRtrwage(pars,DELTA,OMEGA,LAMBDA,PSI,UPSILON);
end
C_m=C(:,1); C_a=C(:,2); C_g=C(:,3); C_nu=C(:,4); C_gam=C(:,5);

%%%STEP 3: FIND PRICE PATHS%%%%%%
%monetary shocks
p=H\[C_m(1:N,1); 0];
%technology shock
p(:,2)=H\[C_a(1:N,1); 0];
%aggregate demand shock
p(:,3)=H\[C_g(1:N,1); 0];
%goods markup shock
p(:,4)=H\[C_nu(1:N,1); 0];
%labor markup shock
p(:,5)=H\[C_gam(1:N,1); 0];