function W = SIPRtrwonl(tr)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or of its NBER or CEPR working paper %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Last revised: October 30, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: Taylor rule 1x2 parameters                                  %
%Output: Welfare for a pair of Taylor rule parameters               %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N pars a b c d
pars_try=pars;                              %import usual parameters
pars_try(6) = tr(1); pars_try(7) = tr(2);   %replace them by Taylor rule guess
p = SIPRtrp(pars_try,'tronl');               %get p path -- only change across programs
W = SIPRw('all',pars_try,p,a,b,c,d);         %evaluate welfare