function TotVar = SIPRvariance(pars,p)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or of its NBER or CEPR working paper %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: Almost exact copy of Mankiw-Reis programs               %
%Last revised: October 30, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: set of parameters                                           %
%Output: Variance decomposition and also total variance in rows for %
%         (inflation nominal-rate hours output-gap)                 %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%STEP 1: RECOVER PARAMETERS %%%%%
sigma_m=pars(9); sigma_a=pars(11); sigma_g=pars(13);
sigma_nu=pars(15); sigma_gam=pars(17);

%%%%STEP 2: SOLVE FOR MA REPRESENTATION %%%%%
[ma_m ma_a ma_g ma_nu ma_gam]=SIPRma(pars,p);

%%%%STEP 3: VARIANCES %%%%%
TotVar=zeros(1,4);
%inflation%
TotVar(1)=(sigma_m^2)*(ma_m(:,1)'*ma_m(:,1))+...
    (sigma_a^2)*(ma_a(:,1)'*ma_a(:,1))+...
    (sigma_g^2)*(ma_g(:,1)'*ma_g(:,1))+...
    (sigma_nu^2)*(ma_nu(:,1)'*ma_nu(:,1))+...
    (sigma_gam^2)*(ma_gam(:,1)'*ma_gam(:,1));
% i %
TotVar(2)=(sigma_m^2)*(ma_m(:,3)'*ma_m(:,3))+...
    (sigma_a^2)*(ma_a(:,3)'*ma_a(:,3))+...
    (sigma_g^2)*(ma_g(:,3)'*ma_g(:,3))+...
    (sigma_nu^2)*(ma_nu(:,3)'*ma_nu(:,3))+...
    (sigma_gam^2)*(ma_gam(:,3)'*ma_gam(:,3));
% hours %
TotVar(3)=(sigma_m^2)*(ma_m(:,5)'*ma_m(:,5))+...
    (sigma_a^2)*(ma_a(:,5)'*ma_a(:,5))+...
    (sigma_g^2)*(ma_g(:,5)'*ma_g(:,5))+...
    (sigma_nu^2)*(ma_nu(:,5)'*ma_nu(:,5))+...
    (sigma_gam^2)*(ma_gam(:,5)'*ma_gam(:,5));
% gap %
TotVar(4)=(sigma_m^2)*(ma_m(:,6)'*ma_m(:,6))+...
    (sigma_a^2)*(ma_a(:,6)'*ma_a(:,6))+...
    (sigma_g^2)*(ma_g(:,6)'*ma_g(:,6))+...
    (sigma_nu^2)*(ma_nu(:,6)'*ma_nu(:,6))+...
    (sigma_gam^2)*(ma_gam(:,6)'*ma_gam(:,6));
