function Wout = SIPRw(x,pars,p,a,b,c,d)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is part of the set of files that accompany the article:       %
%                                                                   %
%Ricardo Reis (2008) "Estimating a SIGE model for policy evaluation"%
%in Monetary Policy under Uncertainty, Central Bank of Chile.       %
%                                                                   %
%See the appendix of the paper or of its NBER or CEPR working paper %
%versions for a detailed explanation of the algorithms.             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Last revised: October 30, 2007                                     %
%Written by: Tiago Berriel and Ricardo Reis                         %
%Input: whether want full part x, parameters, p path and a,b,c,d    %
%Output: Scalar value for W, the negative of welfare                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N
%%%%STEP 1: RECOVER PARAMETERS %%%%%
sigma_nu=pars(15); sigma_a=pars(11); sigma_m=pars(9); sigma_g=pars(13);
sigma_gam=pars(17); omega=pars(19); OMEGA(1,1)=omega;
for i=2:N+2; OMEGA(i,1)=OMEGA(i-1,1)+omega*(1-omega)^(i-1); end

%%%%STEP 2: Use formula %%%%%
clear W
%monetary shocks -- m
W(1)=0;
for i=1:N+1
    W(1) = W(1) + (1-OMEGA(i))*(a(i)*p(i,1)+b(i,1))^2 + OMEGA(i)*(c(i)*p(i,1)+d(i,1))^2;
end
W(1) = W(1)*sigma_m^2;
%technology shock -- a
W(2)=0;
for i=1:N+1
    W(2) = W(2) + (1-OMEGA(i))*(a(i)*p(i,2)+b(i,2))^2 + OMEGA(i)*(c(i)*p(i,2)+d(i,2))^2;
end
W(2) = W(2)*sigma_a^2;
%aggregate demand shock -- g
W(3)=0;
for i=1:N+1
    W(3) = W(3) + (1-OMEGA(i))*(a(i)*p(i,3)+b(i,3))^2 + OMEGA(i)*(c(i)*p(i,3)+d(i,3))^2;
end
W(3) = W(3)*sigma_g^2;
%goods markup shock -- nu
W(4)=0;
for i=1:N+1
    W(4) = W(4) + (1-OMEGA(i))*(a(i)*p(i,4)+b(i,4))^2 + OMEGA(i)*(c(i)*p(i,4)+d(i,4))^2;
end
W(4) = W(4)*sigma_nu^2;
%labor markup shock -- gam
W(5)=0;
for i=1:N+1
    W(5) = W(5) + (1-OMEGA(i))*(a(i)*p(i,5)+b(i,5))^2 + OMEGA(i)*(c(i)*p(i,5)+d(i,5))^2;
end
W(5) = W(5)*sigma_gam^2;
Wtot = sum(W);
%Pick output
if x=='all'; Wout = Wtot;
elseif x=='m';  Wout = W(1);
elseif x=='a';  Wout = W(2);
elseif x=='g';  Wout = W(3);
elseif x=='nuu'; Wout = W(4);
elseif x=='gam'; Wout = W(5);
end
