%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: Calculate optimal policy rules all at once                  %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Output: OMPR_USGopt.mat or OMPR_EMUopt.mat                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

path(path,'e:\SIPR');       %Where SIPR programs are
Sample = 1;                 %Pick, 1 - USG; 2 - EMU
%Careul: must change each program, one by one, to match the sample 
% choice above...

SIPR_optpy
if Sample==1; delete OMPR_USGopt; elseif Sample==2; delete OMPR_EMUopt; end;
if Sample==1; save OMPR_USGopt; elseif Sample==2; save OMPR_EMUopt; end;

SIPR_optpyin
temp1=Wpyin; temp2=opt_pyin; temp3=opt_pyin_p;
if Sample==1; load OMPR_USGopt; elseif Sample==2; load OMPR_EMUopt; end;
Wpyin=temp1; opt_pyin=temp2; opt_pyin_p=temp3; clear temp1 temp2 temp3
if Sample==1; save OMPR_USGopt; elseif Sample==2; save OMPR_EMUopt; end;

SIPR_optpyonl
temp1=Wpyonl; temp2=opt_pyonl; temp3=opt_pyonl_p;
if Sample==1; load OMPR_USGopt; elseif Sample==2; load OMPR_EMUopt; end;
Wpyonl=temp1; opt_pyonl=temp2; opt_pyonl_p=temp3; clear temp1 temp2 temp3
if Sample==1; save OMPR_USGopt; elseif Sample==2; save OMPR_EMUopt; end;

SIPR_optpyspg
temp1=Wpyspg; temp2=opt_pyspg; temp3=opt_pyspg_p;
if Sample==1; load OMPR_USGopt; elseif Sample==2; load OMPR_EMUopt; end;
Wpyspg=temp1; opt_pyspg=temp2; opt_pyspg_p=temp3; clear temp1 temp2 temp3
if Sample==1; save OMPR_USGopt; elseif Sample==2; save OMPR_EMUopt; end;

SIPR_optpywage
temp1=Wpywage; temp2=opt_pywage; temp3=opt_pywage_p;
if Sample==1; load OMPR_USGopt; elseif Sample==2; load OMPR_EMUopt; end;
Wpywage=temp1; opt_pywage=temp2; opt_pywage_p=temp3; clear temp1 temp2 temp3
if Sample==1; save OMPR_USGopt; elseif Sample==2; save OMPR_EMUopt; end;

SIPR_opttr
temp1=Wtr; temp2=opt_tr; temp3=opt_tr_p;
if Sample==1; load OMPR_USGopt; elseif Sample==2; load OMPR_EMUopt; end;
Wtr=temp1; opt_tr=temp2; opt_tr_p=temp3; clear temp1 temp2 temp3
if Sample==1; save OMPR_USGopt; elseif Sample==2; save OMPR_EMUopt; end;

SIPR_opttrin
temp1=Wtrin; temp2=opt_trin; temp3=opt_trin_p;
if Sample==1; load OMPR_USGopt; elseif Sample==2; load OMPR_EMUopt; end;
Wtrin=temp1; opt_trin=temp2; opt_trin_p=temp3; clear temp1 temp2 temp3
if Sample==1; save OMPR_USGopt; elseif Sample==2; save OMPR_EMUopt; end;

SIPR_opttronl
temp1=Wtronl; temp2=opt_tronl; temp3=opt_tronl_p;
if Sample==1; load OMPR_USGopt; elseif Sample==2; load OMPR_EMUopt; end;
Wtronl=temp1; opt_tronl=temp2; opt_tronl_p=temp3; clear temp1 temp2 temp3
if Sample==1; save OMPR_USGopt; elseif Sample==2; save OMPR_EMUopt; end;

SIPR_opttrspg
temp1=Wtrspg; temp2=opt_trspg; temp3=opt_trspg_p;
if Sample==1; load OMPR_USGopt; elseif Sample==2; load OMPR_EMUopt; end;
Wtrspg=temp1; opt_trspg=temp2; opt_trspg_p=temp3; clear temp1 temp2 temp3
if Sample==1; save OMPR_USGopt; elseif Sample==2; save OMPR_EMUopt; end;

SIPR_opttrwage
temp1=Wtrwage; temp2=opt_trwage; temp3=opt_trwage_p;
if Sample==1; load OMPR_USGopt; elseif Sample==2; load OMPR_EMUopt; end;
Wtrwage=temp1; opt_trwage=temp2; opt_trwage_p=temp3; clear temp1 temp2 temp3
if Sample==1; save OMPR_USGopt; elseif Sample==2; save OMPR_EMUopt; end;