%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: histograms to evaluate robust-performance of policies       %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: OMPR_USGpost has Bayesian draws, OMPR_USGopt has optimal policy %
%  rules, OMPRrobdraws has draws to evaluate robustness, OMPR_USGrobpy  %
%  and OMPR_USGrobr have robustly-optimal policy rules                  %
%Output: OMPR_USGrob.mat                                                %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N ests Num dd

%%%%% STEP 0: CHOICES %%%%%
path(path,'e:\SIPR');       %Where SIPR programs are
N = 200;                    %Length of impulse responses
Num = 10000;                %draws I will take

%%%%% STEP 1: LOADING PARAMETERS%%%%%
load OMPR_USGpost ests;
load OMPR_USGopt opt_tr opt_py;
load OMPRrobdraws dd; dd = dd(1:Num);  %draws used
load OMPR_USGrobpy rob_py; load OMPR_USGrobtr rob_tr

%%%%% STEP 2: GET KAPPA %%%%%
kappa=[]; h = waitbar(0,'Getting kappa, welfare coefficient, step 1/6...'); 
for k=1:Num
    pars = ests(dd(k),:); beta = pars(1); psi = pars(2);
    kappa(1,k) = 0.5*beta*(1+1/psi);
    waitbar(k/Num,h); clear pars beta psi
end
close(h); clear h;
[t1,t2] = ksdensity(kappa);
figure(1); plot(t2(1:100),t1(1:100),'g--','LineWidth',2); title('kappa');
clear t1 t2

%%%%% STEP 3: HISTOGRAM AND AVERAGE WELFARE AT STATUS QUO
disp('##########################################################')
disp('##################   STATUS QUO   ########################')
global pars a b c d
Wrob_sq1_hist=[]; h = waitbar(0,'Status quo welfare, step 2/6...'); 
for k=1:Num
    pars_try = ests(dd(k),:);
    [a b c d] = SIPRll(pars_try);
    p = SIPRtrp(pars_try,'tr');
    Wrob_sq1_hist(k) = SIPRw('all',pars_try,p,a,b,c,d);
    waitbar(k/Num,h); clear pars_try a b c d p;
end
close(h); clear h
Wrob_sq1 = mean(Wrob_sq1_hist);
disp('##########################################################')
disp('Welfare value:'); disp(Wrob_sq1)
[t1,t2] = ksdensity(Wrob_sq1_hist);
figure(2); plot(t2(1:100),t1(1:100),'g--','LineWidth',2); title('status quo');
clear t1 t2

%%%%% STEP 4: OPTIMAL BMR RULE
global pars a b c d
disp('##########################################################')
disp('###############   OPTIMAL BMR RULE   #####################')
Wrob_opy_hist=[]; h = waitbar(0,'Optimal BMR rule, step 3/6...'); 
for k=1:Num
    pars_try = ests(dd(k),:); pars_try(8) = 0; pars_try(9) = 0;
    [a b c d] = SIPRll(pars_try);
    p = SIPRpyp(pars_try,opt_py);
    Wrob_opy_hist(k) = SIPRw('all',pars_try,p,a,b,c,d);
    waitbar(k/Num,h); clear pars_try a b c d p;
end
close(h); clear h;
Wrob_opy = mean(Wrob_opy_hist);
disp('Parameters:  ')
disp('    x  in p = x*(y-yn)'); disp(opt_py)
disp('Welfare value:'); disp(Wrob_opy)
[t1,t2] = ksdensity(Wrob_opy_hist);
figure(3); plot(t2(1:100),t1(1:100),'g--','LineWidth',2);
title('optimal BMR rule'); clear t1 t2;

%%%%% STEP 5: OPTIMAL TAYLOR RULE
disp('##########################################################')
disp('#############   OPTIMAL TAYLOR RULE   ####################')
Wrob_otr_hist=[]; h = waitbar(0,'Optimal Taylor rule, step 4/6...'); 
for k=1:Num
    pars_try = ests(dd(k),:);
    pars_try(6) = opt_tr(1); pars_try(7) = opt_tr(2);
    pars_try(8) = 0; pars_try(9) = 0;
    [a b c d] = SIPRll(pars_try);
    p = SIPRtrp(pars_try,'tr');
    Wrob_otr_hist(k) = SIPRw('all',pars_try,p,a,b,c,d);
    waitbar(k/Num,h); clear pars_try a b c d p;
end
close(h); clear h;
Wrob_otr = mean(Wrob_otr_hist);
disp('##########################################################')
disp('Parameters:  ')
disp('    phi_y     phi_pi'); disp(opt_tr);
disp('Welfare value:'); disp(Wrob_otr)
[t1,t2] = ksdensity(Wrob_otr_hist);
figure(4); plot(t2(1:100),t1(1:100),'g--','LineWidth',2);
title('Optimal taylor rule'); clear t1 t2;

%%%%% STEP 6: ROBUST BMR RULE
disp('##########################################################')
disp('###############   ROBUST BMR RULE   ######################')
Wrob_py_hist=[]; h = waitbar(0,'Robust BMR rule, step 5/6...'); 
global a b c d
for k=1:Num
    pars_try = ests(dd(k),:); pars_try(8) = 0; pars_try(9) = 0;
    [a b c d] = SIPRll(pars_try);
    p = SIPRpyp(pars_try,rob_py);
    Wrob_py_hist(k) = SIPRw('all',pars_try,p,a,b,c,d);
    waitbar(k/Num,h); clear pars_try a b c d p;
end
close(h); clear h;
Wrob_py=mean(Wrob_py_hist);
disp('##########################################################')
disp('Parameters:  ')
disp('    x  in p = x*(y-yn)'); disp(rob_py)
disp('Welfare value:'); disp(Wrob_py)
[t1,t2] = ksdensity(Wrob_py_hist);
figure(5); plot(t2(1:100),t1(1:100),'g--','LineWidth',2);
title('Robust BMR rule'); clear t1 t2;

%%%%% STEP 7: ROBUST TAYLOR RULE
disp('##########################################################')
disp('##############   ROBUST TAYLOR RULE   ####################')
Wrob_tr_hist=[];
global a b c d
h = waitbar(0,'Robust Taylor rule, step 6/6...'); 
for k=1:Num
    pars_try = ests(dd(k),:);
    pars_try(6) = rob_tr(1); pars_try(7) = rob_tr(2);
    pars_try(8) = 0; pars_try(9) = 0;
    [a b c d] = SIPRll(pars_try);
    p = SIPRtrp(pars_try,'tr');
    Wrob_tr_hist(k) = SIPRw('all',pars_try,p,a,b,c,d);
    waitbar(k/Num,h); clear pars_try a b c d p;
end
close(h); clear h;
Wrob_tr = mean(Wrob_tr_hist);
disp('##########################################################')
disp('Parameters:  ')
disp('    phi_y     phi_pi'); disp(rob_tr');
disp('Welfare value:'); disp(Wrob_tr)
[t1,t2] = ksdensity(Wrob_tr_hist);
figure(6); plot(t2(1:100),t1(1:100),'g--','LineWidth',2);
title('Robust taylor rule'); clear t1 t2;

clear ests Num k a b c d dd pars
save OMPR_USGrob;