%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produces Table 9                                            %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: OMPR_USGpost with posterior statistics                          %
%Output: displayed on screen                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N

%%%%STEP 0: PICK CASE %%%%%%%
N = 200;            %Length of solution MA
Nplot = 20;         %Length of plots

%%%%STEP 1: PARAMETER INPUTS %%%%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
load OMPR_USGpost_stats; disp('~~USGSPAN sample~~~~~'); disp(' ');

%%%%% TABLE 2 : ESTIMATES AND CONFIDENCE INTERVALS %%%%%%%
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp('          TABLE 2: THE POSTERIOR                    ');
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp(' ')
disp('Posterior Bayesian mean, 2.5 percentile and 97.5 percentile::  ')
disp('      nu      gamma      phiy     phipi     rho_m     sigma_m   rho_g     sigma_g')
disp([mea(1:8);lb(1:8);ub(1:8)]);
disp('    rho_nu   sigma_nu   rho_gam  sigma_gam  delta     omega     lambda    psi');
disp([mea(9:16);lb(9:16);ub(9:16)]);