%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produces Table 3                                            %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: OMPR_USGpost_stats has Bayesian estimates                       %
%Output: displayed on screen                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N

%%%%STEP 0: PICK CASE %%%%%%%
N = 200;            %Length of solution MA
Nplot = 20;         %Length of plots

%%%%STEP 1: PARAMETER INPUTS %%%%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
load OMPR_USGpost_stats est_mean; disp('~~USGSPAN sample~~~~~');
disp(' '); pars = est_mean'; clear est_mean;

%%%%% TABLE 3 : VARIANCE DECOMPOSITION %%%%%%%
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp('      TABLE 3: THE VARIANCE DECOMPOSITION     ');
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp(' ')
disp('Variance decomposition at the parameter estimates:')
disp('  inflation     i        hours    output-gap')
disp(100*OMPRvd(pars,N)');
