%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produces Table 5                                            %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: OMPR_USGpost_stats has Bayesian estimates, OMPR_USGopt has      %
%  optimal policy rules                                                 %
%Output: displayed on screen                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N

%%%%% STEP 0: CHOICES %%%%%
N = 200;                    %Length of impulse responses
path(path,'e:\SIPR');       %Where SIPR programs are

%%%%% STEP 1: LOAD PARAMETERS %%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
load OMPR_USGpost_stats est_mean;
load OMPR_USGopt opt_tr opt_py opt_py_p Wpy; disp('~~USGSPAN sample~~~~~');
disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');
pars = est_mean'; clear est_mean;
beta = pars(1); psi = pars(2); kappa = 0.5*beta*(1+1/psi); %scaling factor
clear beta psi

%%%%% STATUS QUO %%%%%%%
pars_sq = pars; [a b c d] = SIPRll(pars_sq);
p_sq = SIPRtrp(pars_sq,'tr'); TotVar_sq = SIPRvariance(pars_sq,p_sq);
Wbar = SIPRw('all',pars_sq,p_sq,a,b,c,d);
clear a b c d

%%%%OPTIMAL TAYLOR RULE %%%%%%%
disp('OPTIMAL TAYLOR RULE')
pars_tr=pars; pars_tr(6)=opt_tr(1); pars_tr(7)=opt_tr(2);
pars_tr(8)=0; pars_tr(9)=0;
disp(' Parameters:');
disp('     phiy     phipi     rho_m     sigma_m');
disp([pars_tr(6) pars_tr(7) pars_tr(8) pars_tr(9)]);
disp(' Variance change:');
[a b c d] = SIPRll(pars_tr); p_tr = SIPRtrp(pars_tr,'tr');
TotVar_tr = SIPRvariance(pars_tr,p_tr);
disp('  inflation     i       hours      gap')
disp(100*(TotVar_tr./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
Wtr = SIPRw('all',pars_tr,p_tr,a,b,c,d); disp(100*(exp(kappa*(Wbar-Wtr))-1));

%%%% PRICE TARGETING %%%%%%%
disp('BMR ELASTIC PRICE-STANDARD')
disp(' Parameters:');
disp('     phi');
disp(opt_py);
disp(' Variance change:');
disp('  inflation     i       hours      gap')
TotVar_py = SIPRvariance(pars,opt_py_p);
disp(100*(TotVar_py./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
disp(100*(exp(kappa*(Wbar-Wpy))-1));

%%%% NO POLICY ERRORS %%%%%%%
disp('NO POLICY ERRORS')
pars_dis = pars; pars_dis(8)=0; pars_dis(9)=0;
disp(' Parameters:');
disp('     phiy     phipi     rho_m     sigma_m');
disp([pars_dis(6) pars_dis(7) pars_dis(8) pars_dis(9)]);
disp(' Variance change:');
[a b c d] = SIPRll(pars_dis); p_dis = SIPRtrp(pars_dis,'tr');
TotVar_dis = SIPRvariance(pars_dis,p_dis);
disp('  inflation     i       hours      gap')
disp(100*(TotVar_dis./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
Wdis = SIPRw('all',pars_dis,p_dis,a,b,c,d); disp(100*(exp(kappa*(Wbar-Wdis))-1));
clear a b c d

%%%% NO STABILISATION %%%%%%%
disp('NO STABILISATION POLICY')
pars_sp = pars; pars_sp(6)=0;
disp(' Parameters:');
disp('     phiy     phipi     rho_m     sigma_m');
disp([pars_sp(6) pars_sp(7) pars_sp(8) pars_sp(9)]);
disp(' Variance change:');
[a b c d] = SIPRll(pars_sp); p_sp = SIPRtrp(pars_sp,'tr');
TotVar_sp = SIPRvariance(pars_sp,p_sp); 
disp('  inflation     i       hours      gap')
disp(100*(TotVar_sp./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
Wsp = SIPRw('all',pars_sp,p_sp,a,b,c,d); disp(100*(exp(kappa*(Wbar-Wsp))-1));
clear a b c d
