%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produces Table 7                                            %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: OMPR_USrob has robustly-optimal rules and histograms            %
%Output: displayed on screen                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all

%%%%% STEP 1: LOAD PARAMETERS %%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
load OMPR_USGrob; load OMPR_USGpost ests;
disp('~~USGSPAN sample~~~~~');
disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');

%%%%% STEP 3: Welfare calculations %%%%%
disp('ROBUST ELASTIC PRICE-STANDARD')
disp(' Parameters:');
disp('     phi'); disp(rob_py);
disp(' Welfare gain:');
W1 = 100*(exp(kappa.*(Wrob_sq1_hist - Wrob_py_hist))-1);
disp(mean(W1)); disp(prctile(W1,2.5)); disp(prctile(W1,97.5));
disp(' Welfare gain from optimal:');
W2 = 100*(exp(kappa.*(Wrob_opy_hist - Wrob_py_hist))-1); disp(mean(W2));
disp('ROBUST TAYLOR RULE')
disp(' Parameters:');
disp('     phiy   phipi'); disp(rob_tr');
disp(' Welfare gain:');
W3 = 100*(exp(kappa.*(Wrob_sq1_hist - Wrob_tr_hist))-1);
disp(mean(W3)); disp(prctile(W3,2.5)); disp(prctile(W3,97.5));
disp(' Welfare gain from optimal:');
W4 = 100*(exp(kappa.*(Wrob_otr_hist - Wrob_tr_hist))-1); disp(mean(W4));
