%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produces figures in paper                                   %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: Prior_USG has prior parameters, OMPR_USGpost_stats has posterior%
%  estimates                                                            %
%Output: displayed on screen                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N
path(path,'e:\SIPR')

%%%%STEP 0: PICK CASE %%%%%%%
N = 200;            %Length of solution MA
Nplot = 16;         %Length of plots

%%%%STEP 1: PARAMETER INPUTS %%%%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
load PriorUSG est_prior; pars_prior = est_prior';
load OMPR_USGpost_stats est_mean; pars_si = est_mean';
clear est_mean est_prior
disp('~~USGSPAN sample~~~~~');
disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');
%classical case
pars_clas = pars_prior; pars_clas(18)=1; pars_clas(19)=1; pars_clas(20)=1;
%only consumers inattentive
pars_cons = pars_prior; pars_cons(19)=1; pars_cons(20)=1;
%only workers inattentive
pars_work = pars_prior; pars_work(18)=1; pars_work(20)=1;
%only firms inattentive
pars_firm = pars_prior; pars_firm(18)=1; pars_firm(19)=1;

%%%%% FIGURE 1 : IMPULSE RESPONSE FUNCTION AT PRIOR %%%%%%%
[si_m si_a] = SIGEma(pars_prior);
si_m = 100*pars_prior(9)*si_m; si_a = 100*pars_prior(11)*si_a;
[a b c d] = SIPRll(pars_prior);
clear a b c d

disp('Figure 1: IRF to money and technology at priors')
figure(1)
subplot(2,2,1),...
    plot(1:Nplot,si_m(1:Nplot,1),'mo-',1:Nplot,si_a(1:Nplot,1),'b-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Inflation'); grid on; axis([1 16 -0.1 0.7]);
subplot(2,2,2),...
    plot(1:Nplot,si_m(1:Nplot,3),'mo-',1:Nplot,si_a(1:Nplot,3),'b-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Nominal interest rate');  grid on; axis([1 16 -0.2 0.6]);
subplot(2,2,3),...
    plot(1:Nplot,si_m(1:Nplot,5),'mo-',1:Nplot,si_a(1:Nplot,5),'b-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Hours'); grid on; axis([1 16 -0.5 1.2]);
subplot(2,2,4),...
    plot(1:Nplot,si_m(1:Nplot,6),'mo-',1:Nplot,si_a(1:Nplot,6),'b-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Output gap'); grid on; axis([1 16 -0.3 0.8])
legend('Monetary shock','Productivity shock')

%%%%% FIGURE 2: SINGLE SOURCES OF STICKINESS %%%%%%%
[clas_m clas_a] = SIGEma(pars_clas);
clas_m = 100*pars_clas(9)*clas_m; clas_a = 100*pars_clas(11)*clas_a;
[cons_m cons_a] = SIGEma(pars_cons);
cons_m = 100*pars_cons(9)*cons_m; cons_a = 100*pars_cons(11)*cons_a;
[work_m work_a] = SIGEma(pars_work);
work_m = 100*pars_work(9)*work_m; work_a = 100*pars_work(11)*work_a;
[firm_m firm_a] = SIGEma(pars_firm);
firm_m = 100*pars_firm(9)*firm_m; firm_a = 100*pars_firm(11)*firm_a;
disp('Figure 2: IRF to money and technology shocks with only one set of inattentive agents')
figure(2)
subplot(2,2,1),...
    plot(1:Nplot,cons_m(1:Nplot,1),'mo-',1:Nplot,work_m(1:Nplot,1),'b-',1:Nplot,...
    firm_m(1:Nplot,1),'rx-',1:Nplot,clas_m(1:Nplot,1),'k-','LineWidth',2.5,'MarkerSize',10),
title('Inflation, monetary shock'); grid on; axis([1 16 -0.5 1.6]);
subplot(2,2,2),...
    plot(1:Nplot,cons_m(1:Nplot,5),'mo-',1:Nplot,work_m(1:Nplot,5),'b-',1:Nplot,...
    firm_m(1:Nplot,5),'rx-',1:Nplot,clas_m(1:Nplot,5),'k-','LineWidth',2.5,'MarkerSize',10),
title('Hours, monetary shock'); grid on; axis([1 16 -0.5 1.5]);
subplot(2,2,3),...
    plot(1:Nplot,cons_a(1:Nplot,1),'mo-',1:Nplot,work_a(1:Nplot,1),'b-',1:Nplot,...
    firm_a(1:Nplot,1),'rx-',1:Nplot,clas_a(1:Nplot,1),'k-','LineWidth',2.5,'MarkerSize',10),
title('Inflation, productivity shock'); grid on; axis([1 16 -0.5 1.6]);
subplot(2,2,4),...
    plot(1:Nplot,cons_a(1:Nplot,5),'mo-',1:Nplot,work_a(1:Nplot,5),'b-',1:Nplot,...
    firm_a(1:Nplot,5),'rx-',1:Nplot,clas_a(1:Nplot,5),'k-','LineWidth',2.5,'MarkerSize',10),
title('Hours, productivity shock'); grid on; axis([1 16 -0.5 1.5]);
legend('Only consumers','Only workers','Only firms','Classical case')

%%%%% FIGURE 3 : IMPULSE RESPONSE FUNCTION AT POSTERIORS %%%%%%%
[si_m si_a si_g si_nu si_gam] = SIGEma(pars_si);
si_m = 100*pars_si(9)*si_m; si_a = 100*pars_si(11)*si_a;
clear si_g si_nu
disp('Figure 3: IRF to money and technology at posteriors')
figure(3)
subplot(2,2,1),...
    plot(1:Nplot,si_m(1:Nplot,1),'mo-',1:Nplot,si_a(1:Nplot,1),'b-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Inflation'); grid on; axis([1 16 -0.1 0.1]);
subplot(2,2,2),...
    plot(1:Nplot,si_m(1:Nplot,3),'mo-',1:Nplot,si_a(1:Nplot,3),'b-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Nominal interest rate'); grid on; axis([1 16 -0.5 0.1]);
subplot(2,2,3),...
    plot(1:Nplot,si_m(1:Nplot,5),'mo-',1:Nplot,si_a(1:Nplot,5),'b-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Hours'); grid on; axis([1 16 -0.9 0.2]);
subplot(2,2,4),...
    plot(1:Nplot,si_m(1:Nplot,6),'mo-',1:Nplot,si_a(1:Nplot,6),'b-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Output gap'); grid on; axis([1 16 -0.6 0.1]);
legend('Monetary shock','Productivity shock')

%%%%% FIGURE 4 : IMPULSE RESPONSE FUNCTION AT POSTERIORS %%%%%%%
pars1 = pars_si; pars1(6:9) = pars_prior(6:9);
[si_m1 si_a1] = SIGEma(pars1);
si_m1 = 100*pars1(9)*si_m1; si_a1 = 100*pars1(11)*si_a1;
pars2 = pars_si; pars1(6:7) = pars_prior(6:7);
[si_m2 si_a2] = SIGEma(pars2);
si_m2 = 100*pars2(9)*si_m1; si_a2 = 100*pars2(11)*si_a2;
disp('Figure 4: IRF to a monetary shock')
figure(4)
subplot(2,2,1),...
    plot(1:Nplot,si_m1(1:Nplot,1),'mo-',1:Nplot,si_m2(1:Nplot,1),'b-',1:Nplot,si_m(1:Nplot,1),'rx-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Inflation'); grid on; axis([1 16 -0.1 0.8]);
subplot(2,2,2),...
    plot(1:Nplot,si_m1(1:Nplot,3),'mo-',1:Nplot,si_m2(1:Nplot,3),'b-',1:Nplot,si_m(1:Nplot,3),'rx-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Nominal interest rate'); grid on; axis([1 16 -0.5 0.7]);
subplot(2,2,3),...
    plot(1:Nplot,si_m1(1:Nplot,5),'mo-',1:Nplot,si_m2(1:Nplot,5),'b-',1:Nplot,si_m(1:Nplot,5),'rx-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Hours'); grid on; axis([1 16 -0.1 0.5]);
subplot(2,2,4),...
    plot(1:Nplot,si_m1(1:Nplot,6),'mo-',1:Nplot,si_m2(1:Nplot,6),'b-',1:Nplot,si_m(1:Nplot,6),'rx-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Output gap'); grid on; axis([1 16 -0.1 0.3]);
legend('Prior-policy parameters','Prior-shocks posterior-rule','Posterior parameters')

%%%%% FIGURE 5 : IMPULSE RESPONSE FUNCTION AT POSTERIORS %%%%%%%
si_gam = 100*pars_si(17)*si_gam;
disp('Figure 5: IRF to wage-markup shock at posteriors')
figure(5)
subplot(2,2,1),...
    plot(1:Nplot,si_gam(1:Nplot,1),'mo-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Inflation'); grid on; axis([1 16 -0.25 0.05]);
subplot(2,2,2),...
    plot(1:Nplot,si_gam(1:Nplot,3),'mo-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Nominal interest rate'); grid on; axis([1 16 -0.3 0.05]);
subplot(2,2,3),...
    plot(1:Nplot,si_gam(1:Nplot,5),'mo-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Hours'); grid on; axis([1 16 -0.05 0.35]);
subplot(2,2,4),...
    plot(1:Nplot,si_gam(1:Nplot,6),'mo-',...
    'LineWidth',2.5,'MarkerSize',10),
title('Output gap'); grid on; axis([1 16 -0.9 0.05]);