%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: optimal BMR rule at prior parameters                        %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: Prior_USGpost has prior parameters                              %
%Output: OMPR_USGtable1.mat                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N pars a b c d
path(path,'e:\SIPR')

%%%%% STEP 0: CHOICES %%%%%
N = 200;                        %Length of impulse responses
startUSG = -2.78;                %starting point in search
increments = 0.01;              %increments in grid
grids = 99;                     %grid points, must be odd
ubUSG = 0.05;                  %loss lower bound for plotting
lb=-10; ub=10;      %bounds for search

%%%%% STEP 1: LOADING PARAMETERS%%%%%
load PriorUSG est_prior; pars = est_prior'; clear est_prior;
disp('~~Parameters: Using priors'); disp(' ');

%%%%% STATUS QUO %%%%%%%
pars_sq = pars;
[a b c d] = SIPRll(pars_sq); p_sq = SIPRtrp(pars_sq,'tr');
Wbar = SIPRw('all',pars_sq,p_sq,a,b,c,d);
clear a b c d pars_sq p_sq

%%%%% OPTIMAL POLICY %%%%%%%
pars(8) = 0; pars(9) = 0;   %rho and sigma for m
[a b c d] = SIPRll(pars);  %solution of model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%% STEP 2: FINDING MAXIMUM WELFARE%%%%%
py0 = startUSG;
options = optimset('MaxFunEvals',1000000);
%[opt_py Wpy] = fmincon(@SIPRpyw,py0,[],[],[],[],lb,ub,[],options);
%[opt_py Wpy] = fminunc(@SIPRpyw,py0,options);     %check1
[opt_py Wpy] = fminsearch(@SIPRpyw,py0,options);  %check2
opt_py_p = SIPRpyp(pars,opt_py);      %optimal p path

%%%%% STEP 3: GRID TO LOOK BETTER AT FEATURES OF OPTIMUM
A=[];       %grid storing for search
start=startUSG; ubA=ubUSG;
start = start - increments*(grids-1)/2;
for i=1:grids; grid(i,1) = start + increments*i - increments; end
for j=1:grids; A(j) = SIPRpyw(grid(j)); end
Atemp=A; for i=1:grids; if A(i)>ubA; Atemp(i)=NaN; end; end;
Atemp=-Atemp; plot(grid,Atemp), title('Welfare trying to maximise')
%Check
if min(A)-Wpy<0; disp('~~fmincon didnt find global minimum'); end; disp(' ');
[Wpy_alt temp2] = min(A); alt_py=grid(temp2,1);
disp('~~Grid-search optimum and loss are'); disp([alt_py Wpy_alt]);
clear temp1 temp2 i j ubA lb ub start py0 options N;

%%%%% STEP 4: DISPLAYING AND SAVING %%%%%%
kappa = 0.5*pars(1)*(1+1/pars(2)); %scaling factor
Wpygain = (100*(exp(kappa*(Wbar-Wpy))-1));
clear alt_py Wpy_alt a b c d pyUSG pyEMU startUSG startEMU grid N...
    Atemp A pars increments ubUSG ubEMU grids pars Wbar kappa;
disp('##########################################################')
disp('Parameters:  ')
disp('    x  in p = x*(y-yn)'); disp(opt_py)
disp('   path of prices '); disp(opt_py_p(1:10,:))
disp('Welfare value:'); disp(Wpy)
disp('Welfare gain:'); disp(Wpygain)
disp('##########################################################')
temp1 = opt_py; temp2 = Wpygain;
clear opt_py opt_py_p Wpy Wpygain
load OMPR_USGtable1; 
  opt_py1 = temp1; Wpy1gain = temp2; clear temp1 temp2;
save OMPR_USGtable1;