function [vardecomp TotVar VarComp] = OMPRvd(pars,horizon)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: calculate variance decompositions                           %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: paremters and horizon for decomposition                         %
%Output: Variance decomposition and also total variance in rows for     %
%         (inflation nominal-rate hours output-gap)                     %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%STEP 1: RECOVER PARAMETERS %%%%%
sigma_m=pars(9); sigma_a=pars(11); sigma_g=pars(13); sigma_nu=pars(15);
sigma_gam=pars(17);

%%%%STEP 2: SOLVE FOR MA REPRESENTATION %%%%%
[ma_m ma_a ma_g ma_nu ma_gam]=SIGEma(pars);

%%%%STEP 3: VARIANCE DECOMPOSITION %%%%%
%inflation%
temp=(sigma_m^2)*(ma_m(1:horizon,1)'*ma_m(1:horizon,1))+...
    (sigma_a^2)*(ma_a(1:horizon,1)'*ma_a(1:horizon,1))+...
    (sigma_g^2)*(ma_g(1:horizon,1)'*ma_g(1:horizon,1))+...
    (sigma_nu^2)*(ma_nu(1:horizon,1)'*ma_nu(1:horizon,1))+...
    (sigma_gam^2)*(ma_gam(1:horizon,1)'*ma_gam(1:horizon,1));
vardecomp(1,1)=((sigma_m^2)*(ma_m(1:horizon,1)'*ma_m(1:horizon,1)))/temp;
vardecomp(1,2)=((sigma_a^2)*(ma_a(1:horizon,1)'*ma_a(1:horizon,1)))/temp;
vardecomp(1,3)=((sigma_g^2)*(ma_g(1:horizon,1)'*ma_g(1:horizon,1)))/temp;
vardecomp(1,4)=((sigma_nu^2)*(ma_nu(1:horizon,1)'*ma_nu(1:horizon,1)))/temp;
vardecomp(1,5)=((sigma_gam^2)*(ma_gam(1:horizon,1)'*ma_gam(1:horizon,1)))/temp;
TotVar(1)=temp;
VarComp(1,:)=vardecomp(1,:).*temp;
clear temp;
% i %
temp=(sigma_m^2)*(ma_m(1:horizon,3)'*ma_m(1:horizon,3))+...
    (sigma_a^2)*(ma_a(1:horizon,3)'*ma_a(1:horizon,3))+...
    (sigma_g^2)*(ma_g(1:horizon,3)'*ma_g(1:horizon,3))+...
    (sigma_nu^2)*(ma_nu(1:horizon,3)'*ma_nu(1:horizon,3))+...
    (sigma_gam^2)*(ma_gam(1:horizon,3)'*ma_gam(1:horizon,3));
vardecomp(2,1)=((sigma_m^2)*(ma_m(1:horizon,3)'*ma_m(1:horizon,3)))/temp;
vardecomp(2,2)=((sigma_a^2)*(ma_a(1:horizon,3)'*ma_a(1:horizon,3)))/temp;
vardecomp(2,3)=((sigma_g^2)*(ma_g(1:horizon,3)'*ma_g(1:horizon,3)))/temp;
vardecomp(2,4)=((sigma_nu^2)*(ma_nu(1:horizon,3)'*ma_nu(1:horizon,3)))/temp;
vardecomp(2,5)=((sigma_gam^2)*(ma_gam(1:horizon,3)'*ma_gam(1:horizon,3)))/temp;
TotVar(2)=temp;
VarComp(2,:)=vardecomp(2,:).*temp;
clear temp;
% hours %
temp=(sigma_m^2)*(ma_m(1:horizon,5)'*ma_m(1:horizon,5))+...
    (sigma_a^2)*(ma_a(1:horizon,5)'*ma_a(1:horizon,5))+...
    (sigma_g^2)*(ma_g(1:horizon,5)'*ma_g(1:horizon,5))+...
    (sigma_nu^2)*(ma_nu(1:horizon,5)'*ma_nu(1:horizon,5))+...
    (sigma_gam^2)*(ma_gam(1:horizon,5)'*ma_gam(1:horizon,5));
vardecomp(3,1)=((sigma_m^2)*(ma_m(1:horizon,5)'*ma_m(1:horizon,5)))/temp;
vardecomp(3,2)=((sigma_a^2)*(ma_a(1:horizon,5)'*ma_a(1:horizon,5)))/temp;
vardecomp(3,3)=((sigma_g^2)*(ma_g(1:horizon,5)'*ma_g(1:horizon,5)))/temp;
vardecomp(3,4)=((sigma_nu^2)*(ma_nu(1:horizon,5)'*ma_nu(1:horizon,5)))/temp;
vardecomp(3,5)=((sigma_gam^2)*(ma_gam(1:horizon,5)'*ma_gam(1:horizon,5)))/temp;
TotVar(3)=temp;
VarComp(3,:)=vardecomp(3,:).*temp;
clear temp;
% gap %
temp=(sigma_m^2)*(ma_m(1:horizon,6)'*ma_m(1:horizon,6))+...
    (sigma_a^2)*(ma_a(1:horizon,6)'*ma_a(1:horizon,6))+...
    (sigma_g^2)*(ma_g(1:horizon,6)'*ma_g(1:horizon,6))+...
    (sigma_nu^2)*(ma_nu(1:horizon,6)'*ma_nu(1:horizon,6))+...
    (sigma_gam^2)*(ma_gam(1:horizon,6)'*ma_gam(1:horizon,6));
vardecomp(4,1)=((sigma_m^2)*(ma_m(1:horizon,6)'*ma_m(1:horizon,6)))/temp;
vardecomp(4,2)=((sigma_a^2)*(ma_a(1:horizon,6)'*ma_a(1:horizon,6)))/temp;
vardecomp(4,3)=((sigma_g^2)*(ma_g(1:horizon,6)'*ma_g(1:horizon,6)))/temp;
vardecomp(4,4)=((sigma_nu^2)*(ma_nu(1:horizon,6)'*ma_nu(1:horizon,6)))/temp;
vardecomp(4,5)=((sigma_gam^2)*(ma_gam(1:horizon,6)'*ma_gam(1:horizon,6)))/temp;
TotVar(4)=temp;
VarComp(4,:)=vardecomp(4,:).*temp;
clear temp;