%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produces Table 1                                            %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: OMPR_USGtable1 saves time but is not necessary                  %
%Output: displayed on screen                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N
path(path,'e:\SIPR')

%%%%% STEP 0: CHOICES %%%%%
N = 200;                    %Length of impulse responses
recalculate = 0;            %If want to re-calcuate optima

%%%%% STEP 1: LOAD PARAMETERS %%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
if recalculate == 1;
    save OMPR_USGtable1;
    OMPR_optpy1; OMPR_optpy2; OMPR_optpy3;
    OMPR_opttr1;OMPR_opttr2; OMPR_opttr3;
end
load PriorUSG est_prior; load OMPR_USGtable1;
pars = est_prior'; clear est_prior;
disp('~~Parameters: Using prior parameters'); disp(' ');
beta = pars(1); psi = pars(2); kappa = 0.5*beta*(1+1/psi); %scaling factor
clear beta psi
%%%%% STATUS QUO %%%%%%%
pars_sq = pars; [a b c d] = SIPRll(pars_sq); p_sq = SIPRtrp(pars_sq,'tr');
Wbar = SIPRw('all',pars_sq,p_sq,a,b,c,d);
clear a b c d

disp('##############################################')
disp('              TABLE 1: PANEL A                ')
disp('##############################################')
disp(' ')
disp('NO POLICY ERRORS')
pars_dis = pars; pars_dis(8)=0; pars_dis(9)=0;
disp(' Parameters:');
disp('     phiy     phipi     rho_m     sigma_m');
disp([pars_dis(6) pars_dis(7) pars_dis(8) pars_dis(9)]);
[a b c d] = SIPRll(pars_dis); p_dis = SIPRtrp(pars_dis,'tr');
disp(' Welfare gain:')
Wdis = SIPRw('all',pars_dis,p_dis,a,b,c,d); disp(100*(exp(kappa*(Wbar-Wdis))-1));
clear a b c d
disp('OPTIMAL TAYLOR RULE')
disp(' Parameters:'); disp('     phiy     phipi'); disp(opt_tr1);
disp(' Welfare gain:'); disp(Wtr1gain);
disp('OPTIMAL BMR RULE')
disp(' Parameters:'); disp('     phi'); disp(opt_py1);
disp(' Welfare gain:'); disp(Wpy1gain);
disp('##############################################')
disp('              TABLE 1: PANEL B                ')
disp('##############################################')
disp(' ')
disp('Firms only')
disp('OPTIMAL TAYLOR RULE')
disp(' Parameters:'); disp('   phiy     phipi'); disp(opt_tr3);
disp(' Welfare gain:'); disp(Wtr3gain);
disp('OPTIMAL BMR RULE')
disp(' Parameters:'); disp('     phi'); disp(opt_py3);
disp(' Welfare gain:'); disp(Wpy3gain);
disp('Workers only')
disp('OPTIMAL TAYLOR RULE')
disp(' Parameters:'); disp('     phiy     phipi'); disp(opt_tr2);
disp(' Welfare gain:'); disp(Wtr2gain);
disp('OPTIMAL BMR RULE')
disp(' Parameters:'); disp('      phi'); disp(opt_py2);
disp(' Welfare gain:'); disp(Wpy2gain);
