%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produces Table 9                                            %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: USGdata has data and OMPR_USGpost_stats has Bayesian estimates  %
%Output: displayed on screen                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc;
global N T K

%%%%STEP 0: PICK CASE %%%%%%%
N = 200;            %Length of solution MA
Nsim = 10000;        %Number of draws for simulations from prior

%%%%STEP 1: PARAMETER INPUTS %%%%%%%
load USGdata; load OMPR_USGpost_stats est_mean;
[T K]=size(data); pars = est_mean'; clear est_mean;
 
%%%%STEP 2: MOMENTS IN THE DATA %%%%%%%
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp('     MOMENTS IN THE DATA                       ');
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp(' ')
[USset1 USset2]=OMPRmoments(data);
disp(' 1st order serial correlation ')
disp('      Dp        Dy        i        Dwp         l'); disp(USset1);
disp(' Phillips correlation'); disp(USset2);

%%%%STEP 5: MOMENTS IN THE MODEL POSTERIOR MEAN %%%%%%%
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
disp('              MOMENTS AT POSTERIOR                  ');
disp('%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%');
[Set1store Set2store]=OMPRmomentssim(pars,Nsim);
disp(' ')
disp(' 1st order serial correlation (median, 2.5, 97.5)')
disp('      Dp        Dy        i        Dwp         l')
disp([prctile(Set1store,50); prctile(Set1store,2.5); prctile(Set1store,97.5)]);
disp(' Phillips correlation (median, 2.5, 97.5) ')
disp([prctile(Set2store,50); prctile(Set2store,2.5); prctile(Set2store,97.5)]);
clear Set1store Set2store
