%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produces Table 6                                            %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: OMPR_USGpost_stats has Bayesian estimates, OMPR_USGopt has      %
%  optimal policy rules                                                 %
%Output: displayed on screen                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N

%%%%% STEP 0: CHOICES %%%%%
N = 200;                    %Length of impulse responses
path(path,'e:\SIPR');       %Where SIPR programs are

%%%%% STEP 1: LOAD PARAMETERS %%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
load OMPR_USGpost_stats est_mean;
load OMPR_USGopt; disp('~~USGSPAN sample~~~~~');
disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');
pars = est_mean'; clear est_mean;
beta = pars(1); psi = pars(2); kappa = 0.5*beta*(1+1/psi); %scaling factor
clear beta psi

%%%%% STATUS QUO %%%%%%%
pars_sq = pars; [a b c d] = SIPRll(pars_sq);
p_sq = SIPRtrp(pars_sq,'tr'); TotVar_sq = SIPRvariance(pars_sq,p_sq);
Wbar = SIPRw('all',pars_sq,p_sq,a,b,c,d);
clear a b c d

disp('##############################################')
disp('         INTEREST-RATE RULES                  ')
disp('##############################################')
disp(' ')

pars(8)=0; pars(9)=0;   %set monetary shocks to 0

%%%%% QUESTION 1 : EMPLOYMENT %%%%%%%
disp('EMPLOYMENT')
disp(' Parameters:');
disp('     phil     phipi       rho_m     sigma_m');
disp([opt_tronl(1) opt_tronl(2) 0 0]);
disp(' Variance change:');
disp('  inflation     i       hours      gap')
TotVar_onl = SIPRvariance(pars,opt_tronl_p);
disp(100*(TotVar_onl./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
disp(100*(exp(kappa*(Wbar-Wtronl))-1));

%%%%% QUESTION 2 : SPEED-LIMIT %%%%%%%
disp('SPEED-LIMIT')
disp(' Parameters:');
disp('     phiDx     phipi       rho_m     sigma_m');
disp([opt_trspg(1) opt_trspg(2) 0 0]);
disp(' Variance change:');
disp('  inflation     i       hours      gap')
TotVar_spg = SIPRvariance(pars,opt_trspg_p);
disp(100*(TotVar_spg./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
disp(100*(exp(kappa*(Wbar-Wtrspg))-1));

%%%%% QUESTION 3: INERTIAL %%%%%%%
disp('INERTIAL')
disp(' Parameters:');
disp('     phi     phipi     phi_i(-1)    rho_m     sigma_m');
disp([opt_trin(1) opt_trin(2) opt_trin(3) 0 0]);
disp(' Variance change:');
disp('  inflation     i       hours      gap')
TotVar_in = SIPRvariance(pars,opt_trin_p);
disp(100*(TotVar_in./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
disp(100*(exp(kappa*(Wbar-Wtrin))-1));

%%%%% QUESTION 4: WAGE INFLATION %%%%%%%
disp('WAGE-INFLATION')
disp(' Parameters:');
disp('     phiy     phiDw     rho_m     sigma_m');
disp([opt_trwage(1) opt_trwage(2) 0 0]);
disp(' Variance change:');
disp('  inflation     i       hours      gap')
TotVar_wage = SIPRvariance(pars,opt_trwage_p);
disp(100*(TotVar_wage./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
disp(100*(exp(kappa*(Wbar-Wtrwage))-1));

disp('##############################################')
disp('       PRICE-LEVEL TARGETING RULES            ')
disp('##############################################')
disp(' ')

disp('EMPLOYMENT RULE')
disp('     phi');
disp(opt_pyonl);
disp(' Variance change:');
disp('  inflation     i       hours      gap')
TotVar_pyonl = SIPRvariance(pars,opt_pyonl_p);
disp(100*(TotVar_pyonl./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
disp(100*(exp(kappa*(Wbar-Wpyonl))-1));

disp('SPEED-LIMIT RULE')
disp('     phi');
disp(opt_pyspg);
disp(' Variance change:');
disp('  inflation     i       hours      gap')
TotVar_pyspg = SIPRvariance(pars,opt_pyspg_p);
disp(100*(TotVar_pyspg./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
disp(100*(exp(kappa*(Wbar-Wpyspg))-1));

disp('INERTIAL RULE')
disp('     phi      p(-1)');
disp(opt_pyin);
disp(' Variance change:');
disp('  inflation     i       hours      gap')
TotVar_pyin = SIPRvariance(pars,opt_pyin_p);
disp(100*(TotVar_pyin./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
disp(100*(exp(kappa*(Wbar-Wpyin))-1));

disp('WAGE-INFLATION RULE')
disp('     phi');
disp(opt_pywage);
disp(' Variance change:');
disp('  inflation     i       hours      gap')
TotVar_pywage = SIPRvariance(pars,opt_pywage_p);
disp(100*(TotVar_pywage./TotVar_sq-ones(1,4)));
disp(' Welfare gain:')
disp(100*(exp(kappa*(Wbar-Wpywage))-1));