%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: indifference intervals for tables 5, 6 and 9                %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: OMPR_USGpost_stats has Bayesian estimates                       %
%Output: displayed on screen                                            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N pars a b c d 

%%%%% STEP 0: CHOICES %%%%%
path(path,'e:\SIPR');       %Where SIPR programs are
Sample = 1;         %Pick, 1 - USG; 2 - EMU
N = 200;            %Length of impulse responses
x = .01;            %In percentage points, tolerable welafre loss

%%%%% STEP 1: PARAMETERS %%%%%
disp('~~~~~~~~~~~~~~~~~~~~')
if Sample==1; load OMPR_USGpost_stats est_mean; load OMPR_USGopt;
    disp('~~USGSPAN sample~~~~~');
elseif Sample==2; load OMPR_EMUpost est_mean; load OMPR_EMUopt;
    disp('~~EMU sample~~~~~~');
end; disp('~~~~~~~~~~~~~~~~~~~~'); disp(' ');
pars = est_mean'; clear est_mean;
kappa = 0.5*pars(1)*(1+1/pars(2)); %scaling factor
pars(8) = 0; pars(9) = 0; %rho and sigma for m
[a b c d] = SIPRll(pars);  %solution of model

%%%% OPTIMAL PY RULE %%%%%%%
cutoff = Wpy - (1/kappa)*log(1-x/100);
temp = round(opt_py*100)/100;
while SIPRpyw(temp)<cutoff; temp=temp-0.01; end; lb_py(1,1)=temp;
temp = round(opt_py*100)/100;
while SIPRpyw(temp)<cutoff; temp=temp+0.01; end; ub_py(1,1)=temp;
disp('OPTIMAL PY RULE ESTIMATES AND CONFIDENCE INTERVALS')
cis_py = [opt_py;lb_py;ub_py]; disp(cis_py);
clear cutoff temp

%%%% OPTIMAL PYONL RULE %%%%%%%
cutoff = Wpyonl - (1/kappa)*log(1-x/100);
temp = round(opt_pyonl*100)/100;
while SIPRpywonl(temp)<cutoff; temp=temp-0.01; end; lb_pyonl(1,1)=temp;
temp = round(opt_pyonl*100)/100;
while SIPRpywonl(temp)<cutoff; temp=temp+0.01; end; ub_pyonl(1,1)=temp;
disp('OPTIMAL PYONL RULE ESTIMATES AND CONFIDENCE INTERVALS')
cis_pyonl = [opt_pyonl;lb_pyonl;ub_pyonl]; disp(cis_pyonl);
clear cutoff temp

%%%% OPTIMAL PYSPG RULE %%%%%%%
cutoff = Wpyspg - (1/kappa)*log(1-x/100);
temp = round(opt_pyspg*100)/100;
while SIPRpywspg(temp)<cutoff; temp=temp-0.01; end; lb_pyspg(1,1)=temp;
temp = round(opt_pyspg*100)/100;
while SIPRpywspg(temp)<cutoff; temp=temp+0.01; end; ub_pyspg(1,1)=temp;
disp('OPTIMAL PYSPG RULE ESTIMATES AND CONFIDENCE INTERVALS')
cis_pyspg = [opt_pyspg;lb_pyspg;ub_pyspg]; disp(cis_pyspg);
clear cutoff temp

%%%% OPTIMAL PYWAGE RULE %%%%%%%
cutoff = Wpywage - (1/kappa)*log(1-x/100);
temp = round(opt_pywage*100)/100;
while SIPRpywwage(temp)<cutoff; temp=temp-0.01; end; lb_pywage(1,1)=temp;
temp = round(opt_pywage*100)/100;
while SIPRpywwage(temp)<cutoff; temp=temp+0.01; end; ub_pywage(1,1)=temp;
disp('OPTIMAL PYWAGE RULE ESTIMATES AND CONFIDENCE INTERVALS')
cis_pywage = [opt_pywage;lb_pywage;ub_pywage]; disp(cis_pywage);
clear cutoff temp

%%%% OPTIMAL PYINERTIA RULE %%%%%%%
cutoff = Wpyin - (1/kappa)*log(1-x/100);
temp = round(opt_pyin(1)*100)/100;
while SIPRpywin([temp opt_pyin(2)])<cutoff; temp=temp-0.01; end; lb_pyin(1,1)=temp;
temp = round(opt_pyin(1)*100)/100;
while SIPRpywin([temp opt_pyin(2)])<cutoff; temp=temp+0.01; end; ub_pyin(1,1)=temp;
temp = round(opt_pyin(2)*100)/100;
while SIPRpywin([opt_pyin(1) temp])<cutoff && temp>-1; temp=temp-0.01; end; lb_pyin(1,2)=temp;
temp = round(opt_pyin(2)*100)/100;
while SIPRpywin([opt_pyin(1) temp])<cutoff && temp<1; temp=temp+0.01; end; ub_pyin(1,2)=temp;
disp('OPTIMAL PYINERTIA RULE ESTIMATES AND CONFIDENCE INTERVALS')
cis_pyin = [opt_pyin;lb_pyin;ub_pyin]; disp(cis_pyin);
clear cutoff temp

%%%% OPTIMAL TAYLOR RULE %%%%%%%
cutoff = Wtr - (1/kappa)*log(1-x/100);
temp = round(opt_tr(1)*100)/100;
while SIPRtrw([temp opt_tr(2)])<cutoff; temp=temp-0.01; end; lb_tr(1,1)=temp;
temp = round(opt_tr(1)*100)/100;
while SIPRtrw([temp opt_tr(2)])<cutoff; temp=temp+0.01; end; ub_tr(1,1)=temp;
temp = round(opt_tr(2)*100)/100;
while SIPRtrw([opt_tr(1) temp])<cutoff && temp>1; temp=temp-0.01; end; lb_tr(1,2)=temp;
temp = round(opt_tr(2)*100)/100;
while SIPRtrw([opt_tr(1) temp])<cutoff; temp=temp+0.01; end; ub_tr(1,2)=temp;
disp('OPTIMAL TAYLOR RULE ESTIMATES AND CONFIDENCE INTERVALS')
cis_tr = [opt_tr;lb_tr;ub_tr]; disp(cis_tr);
clear cutoff temp

%%%% OPTIMAL TAYLOR RULE ON EMPLOYMENT %%%%%%%
cutoff = Wtronl - (1/kappa)*log(1-x/100);
temp = round(opt_tronl(1)*100)/100;
while SIPRtrwonl([temp opt_tronl(2)])<cutoff; temp=temp-0.01; end; lb_tronl(1,1)=temp;
temp = round(opt_tronl(1)*100)/100;
while SIPRtrwonl([temp opt_tronl(2)])<cutoff; temp=temp+0.01; end; ub_tronl(1,1)=temp;
temp = round(opt_tronl(2)*100)/100;
while SIPRtrwonl([opt_tronl(1) temp])<cutoff && temp>1; temp=temp-0.01; end; lb_tronl(1,2)=temp;
temp = round(opt_tronl(2)*100)/100;
while SIPRtrwonl([opt_tronl(1) temp])<cutoff; temp=temp+0.01; end; ub_tronl(1,2)=temp;
disp('OPTIMAL TAYLOR RULE ON L ESTIMATES AND CONFIDENCE INTERVALS')
cis_tronl = [opt_tronl;lb_tronl;ub_tronl]; disp(cis_tronl);
clear cutoff temp

%%%% OPTIMAL TAYLOR RULE ON SPEED-LIMIT %%%%%%%
cutoff = Wtrspg - (1/kappa)*log(1-x/100);
temp = round(opt_trspg(1)*100)/100;
while SIPRtrwspg([temp opt_trspg(2)])<cutoff; temp=temp-0.01; end; lb_trspg(1,1)=temp;
temp = round(opt_trspg(1)*100)/100;
while SIPRtrwspg([temp opt_trspg(2)])<cutoff; temp=temp+0.01; end; ub_trspg(1,1)=temp;
temp = round(opt_trspg(2)*100)/100;
while SIPRtrwspg([opt_trspg(1) temp])<cutoff && temp>1; temp=temp-0.01; end; lb_trspg(1,2)=temp;
temp = round(opt_trspg(2)*100)/100;
while SIPRtrwspg([opt_trspg(1) temp])<cutoff; temp=temp+0.01; end; ub_trspg(1,2)=temp;
disp('OPTIMAL TAYLOR RULE SPEED-LIMIT ESTIMATES AND CONFIDENCE INTERVALS')
cis_trspg = [opt_trspg;lb_trspg;ub_trspg]; disp(cis_trspg);
clear cutoff temp

%%%% OPTIMAL TAYLOR RULE WITH INERTIA %%%%%%%
cutoff = Wtrin - (1/kappa)*log(1-x/100);
temp = round(opt_trin(1)*100)/100;
while SIPRtrwin([temp opt_trin(2) opt_trin(3)])<cutoff; temp=temp-0.01; end; lb_trin(1,1)=temp;
temp = round(opt_trin(1)*100)/100;
while SIPRtrwin([temp opt_trin(2) opt_trin(3)])<cutoff; temp=temp+0.01; end; ub_trin(1,1)=temp;
temp = round(opt_trin(2)*100)/100;
while SIPRtrwin([opt_trin(1) temp opt_trin(3)])<cutoff && temp>1; temp=temp-0.01; end; lb_trin(1,2)=temp;
temp = round(opt_trin(2)*100)/100;
while SIPRtrwin([opt_trin(1) temp opt_trin(3)])<cutoff; temp=temp+0.01; end; ub_trin(1,2)=temp;
temp = round(opt_trin(3)*100)/100;
while SIPRtrwin([opt_trin(1) opt_trin(2) temp])<cutoff && temp>-1; temp=temp-0.01; end; lb_trin(1,3)=temp;
temp = round(opt_trin(3)*100)/100;
while SIPRtrwin([opt_trin(1) opt_trin(2) temp])<cutoff && temp<1; temp=temp+0.01; end; ub_trin(1,3)=temp;
disp('OPTIMAL TAYLOR RULE WITH INERTIA ESTIMATES AND CONFIDENCE INTERVALS')
cis_trin = [opt_trin;lb_trin;ub_trin]; disp(cis_trin);
clear cutoff temp

%%%% OPTIMAL TAYLOR RULE WITH WAGE %%%%%%%
cutoff = Wtrwage - (1/kappa)*log(1-x/100);
temp = round(opt_trwage(1)*100)/100;
while SIPRtrwwage([temp opt_trwage(2)])<cutoff; temp=temp-0.01; end; lb_trwage(1,1)=temp;
temp = round(opt_trwage(1)*100)/100;
while SIPRtrwwage([temp opt_trwage(2)])<cutoff; temp=temp+0.01; end; ub_trwage(1,1)=temp;
temp = round(opt_trwage(2)*100)/100;
while SIPRtrwwage([opt_trwage(1) temp])<cutoff; temp=temp-0.01; end; lb_trwage(1,2)=temp;
temp = round(opt_trwage(2)*100)/100;
while SIPRtrwwage([opt_trwage(1) temp])<cutoff; temp=temp+0.01; end; ub_trwage(1,2)=temp;
disp('OPTIMAL TAYLOR RULE WAGE ESTIMATES AND CONFIDENCE INTERVALS?')
cis_trwage = [opt_trwage;lb_trwage;ub_trwage]; disp(cis_trwage);
clear cutoff temp
