%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: optimal taylor rule with inattentive firms                  %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: Prior_USGpost has prior parameters                              %
%Output: OMPR_USGtable1.mat                                             %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N pars a b c d
path(path,'e:\SIPR')

%%%%% STEP 0: CHOICES %%%%%
N = 200;                        %Length of impulse responses
startUSG = [10 10];             %starting point in search
increments = [0.01 0.01];       %increments in grid
grids = 15;                     %grid points, must be odd
ubUSG = 0.082;                  %loss lower bound for plotting
lb=[-10,1.01]; ub=[10;10];      %bounds for search

%%%%% STEP 1: LOADING PARAMETERS%%%%%
load PriorUSG est_prior; pars = est_prior'; clear est_prior;
disp('~~Parameters: Using priors'); disp(' ');

%%%%% STATUS QUO %%%%%%%
pars_sq = pars;
[a b c d] = SIPRll(pars_sq); p_sq = SIPRtrp(pars_sq,'tr');
Wbar = SIPRw('all',pars_sq,p_sq,a,b,c,d);
clear a b c d pars_sq p_sq

%%%%% OPTIMAL POLICY %%%%%%%
pars(8) = 0; pars(9) = 0;   %rho and sigma for m
pars(18)=1; pars(19)=1;  %only firms inattentive
[a b c d] = SIPRll(pars);  %solution of model
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%% STEP 2: FINDING MAXIMUM WELFARE%%%%%
tr0 = startUSG;
options = optimset('MaxFunEvals',1000000);  %options
[opt_tr3 Wtr3] = fmincon(@SIPRtrw,tr0,[],[],[],[],lb,ub,[],options);
%[opt_tr3 Wtr3] = fminunc(@SIPRtrw,tr0,options);     %check 1
%[opt_tr3 Wtr3] = fminsearch(@SIPRtrw,tr0,options);  %check 2
opt_pars = pars; opt_pars(6) = opt_tr3(1); opt_pars(7) = opt_tr3(2); %parameter vector at optimum
opt_tr3_p = SIPRtrp(opt_pars,'tr');                 %optimal p path

%%%%% STEP 3: GRID TO LOOK BETTER AT FEATURES OF OPTIMUM
A=[];       %grid storing for search
start=startUSG; ubA=ubUSG;
start = start - increments*(grids-1)/2 - increments;
if start(2)<1; error('Trying phipi<1. Raise start or lower increments'); end
for i=1:grids; grid(i,1:2) = start + increments*(i-1); end
h = waitbar(0,'...Iterating over grid...');
for j=1:grids
    for k=1:grids; A(j,k)=SIPRtrw([grid(j,1);grid(k,2)]);  end
    waitbar(j/grids,h);
end
close(h);
Atemp=A; 
for i=1:grids; for j=1:grids; if A(i,j)>ubA; Atemp(i,j)=NaN; end; end; end; %pick to draw nicer
Atemp=-Atemp; surf(Atemp); title('Welfare trying to maximise')
%Check
if min(min(A))-Wtr3<0; disp('~~fmincon did not find global minimum'); end; disp(' ');
[temp1 temp2] = min(A); [Wtr_alt temp3] = min(temp1);
alt_tr=[grid(temp2(temp3),1); grid(temp3,2)];
disp('~~Grid-search optimum and loss are'); disp([alt_tr' Wtr_alt]);
clear temp1 temp2 temp3 h i j k tr0 startUSG startEMU ubA lb ub ...
    N options start
%disp(grid)

%%%%% STEP 4: DISPLAYING %%%%%%
kappa = 0.5*pars(1)*(1+1/pars(2)); %scaling factor
Wtr3gain = (100*(exp(kappa*(Wbar-Wtr3))-1));
clear Wtr_alt alt_tr a b c d trUSG trEMU A Atemp opt_p opt_pars ...
    ubUSG ubEMU increments grids grid ans kappa pars Wbar
disp('##########################################################')
disp('Parameters:  ')
disp('    phi_y     phi_pi'); disp(opt_tr3)
disp('   path of prices '); disp(opt_tr3_p(1:10,:))
disp('Welfare value:'); disp(Wtr3)
disp('Welfare gain:'); disp(Wtr3gain)
disp('##########################################################')
temp1 = opt_tr3; temp2 = Wtr3gain;
clear opt_tr3 opt_tr3_p Wtr3 Wtr3gain
load OMPR_USGtable1; 
  opt_tr3 = temp1; Wtr3gain = temp2; clear temp1 temp2;
save OMPR_USGtable1;

