%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: caluclate robustly-optimal price-targeting rule             %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: OMPR_USGpost has Bayesian draws, OMPRrobdraws has draws to      %
%  evaluate robustness,                                                 %
%Output: OMPR_USGrobpy.mat                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N ests Num dd

%%%%% STEP 0: CHOICES %%%%%
path(path,'e:\SIPR');         %Where SIPR programs are
start = -0.12;                %search start-point and grid mid-point
increments = 0.01;            %increments in grid
ubA = 0.17;                   %loss lower bound for plotting
grids = 11;                   %grid points, must be odd
N = 200;                      %Length of impulse responses
Num = 10000;                  %draws I will take

%%%%% STEP 1: LOADING PARAMETERS%%%%%
load OMPR_USGpost ests Md;
load OMPRrobdraws dd; dd = dd(1:Num);  %draws used

%%%%% STEP 2: GRID TO LOOK BETTER AT FEATURES OF OPTIMUM
A=[];       %grid storing for search
start = start - increments*(grids-1)/2 - increments;
for i=1:grids; grid(i,1) = start + increments*i; end
tic
global a b c d
for j=1:grids
    temp=[];
    h = waitbar(0,'Looking in grid for optimal policy...'); 
    for k=1:Num
        pars_try = ests(dd(k),:); pars_try(8) = 0; pars_try(9) = 0;
        [a b c d] = SIPRll(pars_try);
        p = SIPRpyp(pars_try,grid(j));
        temp(k) = SIPRw('all',pars_try,p,a,b,c,d);
        clear pars_try a b c d p
        waitbar(k/Num,h);
    end
    A(j) = mean(temp); clear temp;
    disp(j); close (h)
end
toc
Atemp=A; for i=1:grids; if A(i)>ubA; Atemp(i)=NaN; end; end;
Atemp=-Atemp; plot(grid,Atemp), title('Welfare trying to maximise')
[Wrob_py temp] = min(A); rob_py=grid(temp,1);
disp('~~Grid-search optimum and loss are'); disp([rob_py Wrob_py]);
disp('~~The grid was'); disp(grid);
clear temp a b c d h i j start startUSG startEMU increments grids ubA pars k

%%%%% STEP 3: DISPLAYING AND SAVING %%%%%%
clear Atemp N ests ubA ubUSG ubEMU Md Num
disp('##########################################################')
disp('Parameters:  ')
disp('    x  in p = x*(y-yn)'); disp(rob_py)
disp('Welfare value:'); disp(Wrob_py)
disp('##########################################################')
save OMPR_USGrobpy rob_py grid A;