%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: caluclate robustly-optimal Taylor rule                      %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: OMPR_USGpost has Bayesian draws, OMPRrobdraws has draws to      %
%  evaluate robustness,                                                 %
%Output: OMPR_USGrobtr.mat                                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear global; clear; clc; close all
global N ests Num dd

%%%%% STEP 0: CHOICES %%%%%
path(path,'e:\SIPR');        %Where SIPR programs are
start = [0.48 4.90];         %search start-point and grid mid-point
increments = [0.01 0.01];    %increments in grid
ubA = 0.18;                  %loss lower bound for plotting
grids = 3;                   %grid points, must be odd
N = 200;                     %Length of impulse responses
Num = 10000;                 %draws I will take

%%%%% STEP 1: LOADING PARAMETERS%%%%%
load OMPR_USGpost ests Md;
load OMPRrobdraws dd; dd = dd(1:Num);  %draws used

%%%%% STEP 2: GRID TO LOOK BETTER AT FEATURES OF OPTIMUM
A=[];       %grid storing for search
start = start - increments*(grids-1)/2 - increments;
for i=1:grids; grid(i,1:2) = start + increments*i; end
global pars a b c d
for j=1:grids
    h = waitbar(0,'Looking in grid for optimal policy...'); tic
    for k=1:grids
        temp=[];
        for z=1:Num
            pars = ests(dd(z),:); pars(8) = 0; pars(9) = 0;
            [a b c d] = SIPRll(pars);
            temp(z) = SIPRtrw([grid(j,1);grid(k,2)]); 
        end
        A(j,k) = mean(temp); clear temp
        waitbar(k/grids,h);
    end
    close(h); disp(j);
end
toc
Atemp=A;
for i=1:grids; for j=1:grids; if A(i,j)>ubA; Atemp(i,j)=NaN; end; end; end;
Atemp=-Atemp; surf(Atemp); title('Welfare trying to maximise')
[temp1 temp2] = min(A); [Wrob_tr temp3] = min(temp1);
rob_tr=[grid(temp2(temp3),1); grid(temp3,2)];
disp('~~Grid-search optimum and loss are'); disp([rob_tr' Wrob_tr]);
disp('~~The grid was'); disp(grid);
clear temp temp1 temp2 a b c d h i j start startUSG startEMU ...
    increments grids ubA pars k z

%%%%% STEP 3: DISPLAYING AND SAVING %%%%%%
clear Atemp N ests ubA ubUSG ubEMU Md Num
disp('##########################################################')
disp('Parameters:  ')
disp('    phi_y     phi_pi'); disp(rob_tr)
disp('Welfare value:'); disp(Wrob_tr)
disp('##########################################################')
save OMPR_USGrobtr rob_tr grid A;