function [set1 set2] = OMPRmoments(data)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: calculate moments in data                                   %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: data                                                            %
%Output: First-order serial correlations and Phillips correlation       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

nn = length(data);

%First-order serial correlations
temp1 = data(2:nn,:); temp2 = data(1:nn-1,:); temp3 = corr(temp1,temp2);
set1 = diag(temp3)';
clear temp1 temp2 temp3
%Accelerationist Phillips correlation
temp1=[]; for i=3:nn-2; temp1 = [temp1;data(i+2,1)-data(i-2,1)]; end
temp2=data(1,2); for i=2:nn; temp2=[temp2;temp2(i-1)+data(i,2)]; end
temp2 = temp2 - hpfilter(temp2,1600); temp2 = temp2(3:nn-2);
set2 = corr(temp1,temp2);
