function [Set1store Set2store] = OMPRmomentssim(pars,Nsim)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  This file is part of the replication files for the figures in:       %
%Reis, Ricardo (2009). "Optimal Monetary Policy Rule in an Estimated    %
%  Sticky-Information Model." American Economic Journal: Macroeconomics %
%  forthcoming                                                          %
%See the paper for a detailed explanation of the algorithms.            %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: calculate moments across many simulations of model          %
%Last revised: January 29, 2009                                         %
%Written by: Tiago Berriel and Ricardo Reis                             %
%Input: parameters and number of simulations                           %
%Output: First-order serial correlations and Phillips correlation       %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

global N T
[ma_m ma_a ma_g ma_nu ma_gam] = SIGEmafive(pars);
Set1store=[]; Set2store=[];
h = waitbar(0,'...Simulating...');
for j=1:Nsim
    e_m=pars(9)*randn(1,N+T); e_a=pars(11)*randn(1,N+T);
    e_g=pars(13)*randn(1,N+T); e_nu=pars(15)*randn(1,N+T);
    e_gam=pars(17)*randn(1,N+T);
    data_sim = [];
    for i=1:T  %from last to first observation
        temp2 = e_m(i:i+N)*ma_m + e_a(i:i+N)*ma_a + ...
            + e_g(i:i+N)*ma_g + e_nu(i:i+N)*ma_nu + e_gam(i:i+N)*ma_gam;
        data_sim=[temp2;data_sim];
    end
    [set1 set2]=OMPRmoments(data_sim);
    Set1store = [Set1store; set1]; Set2store = [Set2store; set2];
    waitbar(j/Nsim,h);
end
close(h);
