%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% This file replicates all of the figures in:                            %
% Mankiw, N. Gregory and Ricardo Reis (2009). "Imperfect Information and %
% Aggregate Supply." In B. Friedman and M. Woodford, eds., Handbook of   %
% Monetary Economics, vol. 3A, 183-230, Elsevier-North Holland, 2011.    %
% See the paper for a detailed explanation.                              %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Please cite if you use the programs. I do not provide tech support.    %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This file: produces figures in paper                                    %
%Last revised: August 10, 2010                                           %
%Written by: Ricardo Reis                             					 %
%Input: none                                                             %
%Output: all displayed on screen                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear; clc; close all; clear global

%Gauging value of alpha, reported in page 189
phi = [0.2; 1; 0.5]; gamma = [4; 10; 7];
alpha(1) = (1 + phi(1))./(phi(1) + gamma(2));
alpha(2) = (1 + phi(2))./(phi(2) + gamma(1));
alpha(3) = (1 + phi(3))./(phi(3) + gamma(3));
disp('Alpha, min, max and preferred'); disp(alpha');
clear phi gamma alpha

%Figure 1: From Reis (2009). "Inattentive Producers." Review of Economic Studies.

%Figure 2
gamma=7; phi=0.5; sigma=zeros(100,1); X=zeros(100,1);
for i=1:100; sigma(i)=0.00025*i; XP(i) = exp(-0.5*(sigma(i)^2)*gamma*(gamma-1)*(1+phi)/phi); end
cutoff = 0.99*ones(1,100);
figure(2);
plot(sigma,XP,'mo-',sigma,cutoff,'b-','LineWidth',2.5,'MarkerSize',10);
grid on; title('Profit function for uninformed firm in informed world');
print('-depsc','Fig2.eps')
%find Xp closer to 0.99
temp=find(XP>0.99); temp=length(temp); cut=sigma(temp);
disp('Cut-off value for sigma is'); disp(cut);
disp('Cut-off value for kappa as % of profits'); disp(100*(1-XP(40)));
clear phi gamma alpha sigma XP cutoff temp cut

%Figure 3: IRF in sticky-info model
lambda = 0.25; alpha = 0.2; sigma=0.01;
p=zeros(16,1); output=p; inflation=p; ttt=p; disagreement=p;
for i=1:16
    Lambda = (1-lambda)^i;
    p(i) = alpha*(1-Lambda)/(1-(1-alpha)*(1-Lambda));
    output(i) = 1 - p(i);
    if i==1; inflation(i)=p(i); else inflation(i)=p(i)-p(i-1); end
    ttt(i)=i;
    disagreement(i) = lambda*((1-lambda)^(i-1))*(1-lambda*((1-lambda)^(i-1)))*sum(inflation);
end
clear i Lambda
figure(3)
subplot(1,2,1),...
    plot(ttt,sigma*inflation,'mo-','LineWidth',2.5,'MarkerSize',10),
grid on; title('Impulse response of inflation'); xlim([1,16]);
set(gca,'XTick',2:2:16,'XTickLabel',2:2:16,'FontSize',10)
subplot(1,2,2),...
    plot(ttt,sigma*output,'mo-','LineWidth',2.5,'MarkerSize',10),
grid on; title('Impulse response of output'); xlim([1,16]);
set(gca,'XTick',2:2:16,'XTickLabel',2:2:16,'FontSize',10)
print('-depsc','Fig3.eps')
target = output(1);
clear inflation output p

%Figure 5: IRF of disagreement
figure(5)
plot(ttt,sigma*sqrt(disagreement),'mo-','LineWidth',2.5,'MarkerSize',10),
grid on; title('Impulse response of disagreement'); xlim([1,16]);
set(gca,'XTick',2:2:16,'XTickLabel',2:2:16,'FontSize',10);
print('-depsc','Fig5.eps')
Edis = sqrt(sum(disagreement))*sigma;
disp('Expected value of disagreement is'); disp(Edis);
clear Edis disagreement

%Figure 4: IRF in sticky price model
tao = 0.005; theta = (-alpha*tao + sqrt((alpha*tao)^2 + 4*alpha*tao));
disp('Output response with delayed and partial information');
disp([target 1-theta]);
disp('Tao and relative standard deviation'); disp([tao sqrt(1/tao)]);
p=zeros(16,1); output=p; inflation=p; ttt=p;
p(1)=theta; output(1)=1-theta; inflation(1)=p(1);
for i=2:16
    p(i) = (1-theta)*p(i-1) + theta;
    output(i) = 1 - p(i);
    inflation(i)=p(i)-p(i-1);
    ttt(i)=i;
end
figure(4)
subplot(1,2,1),...
    plot(ttt,sigma*inflation,'mo-','LineWidth',2.5,'MarkerSize',10),
grid on; title('Impulse response of inflation'); xlim([1,16]);
set(gca,'XTick',2:2:16,'XTickLabel',2:2:16,'FontSize',10)
subplot(1,2,2),...
    plot(ttt,sigma*output,'mo-','LineWidth',2.5,'MarkerSize',10),
grid on; title('Impulse response of output'); xlim([1,16]);
set(gca,'XTick',2:2:16,'XTickLabel',2:2:16,'FontSize',10)
print('-depsc','Fig4.eps')
clear target i p output inflation ttt tao theta

%Figure 6: From Mankiw Reis Wolfers (2004). "Disagreement about Inflation
% Expectations." NBER Macro Annual 2003.
