function [x1,p1,x2,p2,llf]=kfilt_llf(y,x1,p1,h,f,r,q)
%adapted from npi_em_4.gss;
%kalman filter procedure--hamilton notation
% y(t)=h'x(t)+w(t)
% x(t)=f x(t-1)+v(t)
%
% var(w(t))=r;
% var(v(t))=q;
%
% x1=x(t-1/t-1)--on input
% p1=p(t-1/t-1)--on input
% output includes innovations,variance of innovations & log-likelihood;

x2=f*x1;
e=y-h'*x2;
p2=f*p1*f'+q;
ht=h'*p2*h+r;
k=p2*h/ht;
x1=x2+k*e;
p1=(eye(size(p1,1))-k*h')*p2;


%compute log-likelihood%...
llf=-0.5*(log(det(ht))+(e'/ht*e));
end