%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Plot_SS.m 
% 
% Script file to plot the steady state characteristics  
% in Section 4 and 5 of Oh and Reis (2011) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%----------------------------------------------%
% 1. g(s) h(s) plot 
gk = VAR.gk;            % stationary distribution F(k,s)
T = VAR.T;              % net transfers T(s,h)
%----------------------------------------------%

%----------------------------------------------%
% 1.1. g(s) plot
g_s=zeros(ns,1); % g(s)
for is=1:ns
    if T(is,nh) >= 0
        g_s(is) = hgrid(nh-1);
    else
        g_s(is) = min(interp1q(fliplr(T(is,:)),flipud(hgrid),0),hgrid(nh-1));
    end
end
%----------------------------------------------%

%----------------------------------------------%
% 1.2. h(s) plot
hstar=zeros(nk,ns);
ndech_1 = VAR.ndech;         % labor decision n(k,s,h)
for ik=1:nk
    for is=1:ns
        hindex = find(ndech_1(ik,is,:)==1); % change!!
        if isempty(hindex) || (length(hindex) == 1)
            hstar(ik,is)=hgrid(nh-1);
        elseif length(hindex) == nh
            hstar(ik,is) = hgrid(1);
        else
            hstar(ik,is)=0.5*(hgrid(min(hindex)-1)+hgrid(min(hindex)));
        end
    end
end
hstar_s = sum(gk.*hstar,1)./sum(gk,1);
%----------------------------------------------%

%----------------------------------------------%
% 2. MPC: m(k,s,h)
cdech=VAR.cdech;     % consumption decision: c(k,s,h)
dck=zeros(nk,ns,nh); % initialize (dc/dk)
for ih = 1:nh
    for is = 1:ns
        dck(1,is,ih) = (cdech(2,is,ih)-cdech(1,is,ih))/(kgrid(2)-kgrid(1));
        dck(nk,is,ih) = (cdech(nk,is,ih)-cdech(nk-1,is,ih))/(kgrid(nk)-kgrid(nk-1));
        for ik = 2:nk-1
            dck(ik,is,ih) = 0.5*(cdech(ik,is,ih)-cdech(ik-1,is,ih))/(kgrid(ik)-kgrid(ik-1)) + 0.5*(cdech(ik+1,is,ih)-cdech(ik,is,ih))/(kgrid(ik+1)-kgrid(ik));
        end
    end
end
%----------------------------------------------%

%----------------------------------------------%
% mksh = m(k,s,h) : MPC wrt capital, income, and health
mksh = (1/(1-delta+rnew))*dck; % (dc/da)(k,s,h) = (dc/dk)*(dk/da) = (dc/dk)*(1/(1-delta+rnew))
%----------------------------------------------%

%----------------------------------------------%
% msh = m(s,h) : MPC wrt income and health
msh = zeros(ns,nh);  
for ih = 1:nh 
    msh(:,ih) = (sum(mksh(:,:,ih).*gk,1)./sp)';
end
%----------------------------------------------%

%----------------------------------------------%
% ms = m(s) : MPC wrt income
ms_1 = msh(:,nh);                       % healthy guys
ms_2 = (1/(nh-1))*sum(msh(:,1:nh-1),2); % less healthy guys
ms   = hp(nh)*ms_1 + (1-hp(nh))*ms_2;   % overall m(s)
%----------------------------------------------%

%----------------------------------------------%
% mh = m(h) : MPC wrt health
spmat = repmat(sp',1,nh);
mh= sum(msh.*spmat,1);
%----------------------------------------------%

%----------------------------------------------%
% mks = m(k,s) : MPC wrt capital and income
mks = hp(1)*mksh(:,:,1);
for ih = 2:nh
    mks = mks + hp(ih)*mksh(:,:,ih);
end
%----------------------------------------------%

%----------------------------------------------%
% mk = m(k) : MPC wrt capital
mk = mks*sp';
%----------------------------------------------%

%----------------------------------------------%
% m_mean = mean(m) : overall average MPC
m_mean=sum(sum(mks.*gk));
%----------------------------------------------%

%{
%----------------------------------------------%
% Corr(k,s)
kmean=kgrid'*sum(gk,2);
kvar=((kgrid-kmean).^2)' *sum(gk,2);
smean=sgrid'*sum(gk,1)';
svar=((sgrid-smean).^2)' *sum(gk,1)';

[KKm SSm]=ndgrid(kgrid-kmean,sgrid-smean);
covks=sum(sum(KKm.*SSm.*gk));
corrks = covks/(sqrt(kvar)*sqrt(svar));
disp(['Correlation of (k,s) is ' num2str(corrks)])

% Corr(n,h)
hmean=hgrid'*hp';
hvar=((hgrid-hmean).^2)'*hp';
ngrid_h = zeros(nh,1);
for i_n = 1:nh
    ngrid_h(i_n) = sum(sum(VAR.ndech(:,:,i_n).*gk));
end
nmean = ngrid_h'*hp';
nvar=((ngrid_h-nmean).^2)'*hp';
covnh=((ngrid_h-nmean).*(hgrid-hmean))'*hp';
corrnh = covnh/(sqrt(nvar)*sqrt(hvar));
disp(['Correlation of (n,h) is ' num2str(corrnh)])
%----------------------------------------------%
%}

%%%%%%%%%%%%%%%%%%%%% Plots %%%%%%%%%%%%%%%%%%%%%
% plot option
lw = 5;               % linewidth
fontsize = 22;        % fontsize
% index for capital and income (kmax=10, smax=3)
k10=find(kgrid<=10); k10=[k10; k10(end)+1];
s3=find(sgrid<=3); s3=[s3; s3(end)+1];

%*******************************************%
% Figure 1 : Neoclassical Transfers
%------------------------------------
% SSwithout.mat
%------------------------------------

figure(11)
plot(sgrid(s3),hstar_s(s3),'b','LineWidth',lw)
xlabel('s','FontSize',fontsize); 
ylabel('h','FontSize',fontsize);
axis([0 3 0 0.351])
grid on
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)
% With targeted transfers area
hold on
% rich
plot(sgrid([13 13 21 21]),hgrid([11 20 20 11]),'r','LineWidth',lw)
plot(sgrid([13 21]),hgrid([11 11]),'r','LineWidth',lw)
% poor
plot(sgrid([1 1 9 9]),hgrid([1 10 10 1]),'r','LineWidth',lw)
plot(sgrid([1 9]),hgrid([10 10]),'r','LineWidth',lw)

%*******************************************%
% Figure 2 : Keynesian Transfers
%------------------------------------
% SSwithout.mat
%------------------------------------

figure(21) 
plot(sgrid(s3),ms_1(s3),'b','LineWidth',lw)
xlabel('s','FontSize',fontsize); ylabel('MPC','FontSize',fontsize)
%legend('Healthy')
axis([0 3 0 0.251])
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)
% With direct transfers area
ms_1w = ms_1.*sp';
ms_1rich = sum(ms_1w(12:21))/sum(sp(12:21)); % average m(s) for rich
ms_1poor = sum(ms_1w(1:10))/sum(sp(1:10)); % average m(s) for poor
hold on
% rich
plot(sgrid([12 12 21 21]),[ms_1rich 0 0 ms_1rich],'r','LineWidth',lw)
plot(sgrid([12 21]),[ms_1rich ms_1rich],'r','LineWidth',lw)
% poor
plot(sgrid([1 1 10 10]),[ms_1poor 0 0 ms_1poor],'r','LineWidth',lw)
plot(sgrid([1 10]),[ms_1poor ms_1poor],'r','LineWidth',lw)

%*******************************************%
% Figure 3 : Systematic Transfers 
%------------------------------------
% SSwith.mat
%------------------------------------
 
figure(31) %subplot(2,2,1)
if isempty(find(g_s ~= 0,1))
    plot(sgrid(s3),hstar_s(s3),'b','LineWidth',lw)
    %legend('h(s)')
else
    plot(sgrid(s3),hstar_s(s3),'b',sgrid(s3),g_s(s3),'k--','LineWidth',lw)
    legend('h(s)','g(s)')
end
xlabel('s','FontSize',fontsize); 
ylabel('h','FontSize',fontsize);
axis([0 3 0 0.351])
grid on
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)

figure(32) %subplot(2,2,2)
plot(sgrid(s3),ms_1(s3),'b',sgrid(s3),ms_2(s3),'k--','LineWidth',lw)
xlabel('s','FontSize',fontsize); ylabel('MPC','FontSize',fontsize)
legend('h = 1','h < 1')
axis([0 3 0 0.351])
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)