%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Plot_TD.m 
% 
% Script file to plot the transition dynamics   
% in Section 4 and 5 of Oh and Reis (2011) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% 1. Distribution of Capital
gkkt=squeeze(sum(gkt,2)); % distribution dynamics of capital (integrate egrid)
% cdf dynamics of capital
cdfkt=gkkt;
for ik=2:nk
    cdfkt(ik,:)=cdfkt(ik-1,:)+gkkt(ik,:)+1e-10; % adding 1e-20 is just to make the CDF monotonically increasing
end

% 2. Consumption Dynamics
% Aggregate Consumption
Cagg=cdect.*gkt;
Ct=sum(sum(Cagg,1),2);
Ct=squeeze(Ct);
% Consumption Dynamics Percentile by Capital
Ckt=squeeze(sum(Cagg,2));
Csumkt=Ckt;
for ik=2:nk
    Csumkt(ik,:)=Csumkt(ik-1,:)+Ckt(ik,:);
end
Ctq = zeros(4,nt); % consumption by quantile
for it=1:nt
    Ctq(1,it)=interp1(cdfkt(:,it),Csumkt(:,it),0.2);
    Ctq(2,it)=interp1(cdfkt(:,it),Csumkt(:,it),0.4);
    Ctq(3,it)=interp1(cdfkt(:,it),Csumkt(:,it),0.6);
    Ctq(4,it)=interp1(cdfkt(:,it),Csumkt(:,it),0.8);
end

% 3. Labor Supply Dynamics (Et)
% Aggregate Labor Supply
Eagg=ndect.*gkt;
% Labor Supply Dynamics Percentile by Capital
Ekt=squeeze(sum(Eagg,2));
Esumkt = Ekt;
for ik=2:nk
    Esumkt(ik,:)=Esumkt(ik-1,:)+Ekt(ik,:);
end
Etq = zeros(4,nt); % aggregate labor supply by quantile
for it=1:nt
    Etq(1,it)=interp1(cdfkt(:,it),Esumkt(:,it),0.2);
    Etq(2,it)=interp1(cdfkt(:,it),Esumkt(:,it),0.4);
    Etq(3,it)=interp1(cdfkt(:,it),Esumkt(:,it),0.6);
    Etq(4,it)=interp1(cdfkt(:,it),Esumkt(:,it),0.8);
end

% 4. Output
Yt=At.*Kt.^alpha.*Xt.^(1-alpha); 

%%%%%%%%%%%%%%%%%%%%% Plots %%%%%%%%%%%%%%%%%%%%%
% plot option
lw = 5;               % linewidth 
fontsize = 22;        % fontsize
time=20;              % max time path

%*******************************************%
% Figure 1 : Neoclassical Transfers Shock
%------------------------------------
% TDneoclassical.mat
%------------------------------------

figure(12) %subplot(2,2,2)
%title('Labor Supply Dynamics of Each Quantile by Capital','FontSize',fontsize)
hold on
plot(0:time,0*[0:time],'k','LineWidth',lw)
p1=plot(0:time,100*log(Etq(1,1:time+1)/Etq(1,1)),'k:','LineWidth',lw);
p2=plot(0:time,100*log((Etq(2,1:time+1)-Etq(1,1:time+1))/(Etq(2,1)-Etq(1,1))),'b--','LineWidth',lw);
p3=plot(0:time,100*log((Etq(3,1:time+1)-Etq(2,1:time+1))/(Etq(3,1)-Etq(2,1))),'g','LineWidth',lw);
p4=plot(0:time,100*log((Etq(4,1:time+1)-Etq(3,1:time+1))/(Etq(4,1)-Etq(3,1))),'m-*','LineWidth',lw);
p5=plot(0:time,100*log((Et(1:time+1)'-Etq(4,1:time+1))/(Et(1)-Etq(4,1))),'r-^','LineWidth',lw);
legend([p1 p2 p3 p4 p5],'1st  Quintile','2nd Quintile','3rd Quintile','4th Quintile','5th Quintile')
ylabel('percentage (%)','FontSize',fontsize); xlabel('period','FontSize',fontsize)
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)

figure(13) %subplot(2,2,3)
%title('Aggregate Labor Supply Dynamics','FontSIze',fontsize)
hold on
plot(0:time,0*[0:time],'k','LineWidth',lw)
plot(0:time,100*log(Et(1:time+1)/Et(1)),'b','LineWidth',lw)
ylabel('percentage (%)','FontSize',fontsize); xlabel('period','FontSize',fontsize)
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)
axis([0 time -0.21 1.01])

figure(14) %subplot(2,2,4)
%title('Output','FontSize',fontsize)
hold on
plot(0:time,zeros(time+1,1),'k',0:time,100*log(Yt(1:time+1)/Yt(1)),'b','LineWidth',lw)
xlabel('period','FontSize',fontsize); ylabel('percentage (%)','FontSize',fontsize)
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)
axis([0 time -0.21 1.01])

%*******************************************%
% Figure 2 : Keynesian Transfers Shock
%------------------------------------
% TDkeynesian.mat
%------------------------------------

figure(22) %subplot(2,2,2)
%title('Consumption Dynamics of Each Quantile by Capital','FontSize',fontsize)
hold on
plot(0:time,0*[0:time],'k','LineWidth',lw)
p1=plot(0:time,100*log(Ctq(1,1:time+1)/Ctq(1,1)),'k:','LineWidth',0.95*lw);
p2=plot(0:time,100*log((Ctq(2,1:time+1)-Ctq(1,1:time+1))/(Ctq(2,1)-Ctq(1,1))),'b--','LineWidth',lw);
p3=plot(0:time,100*log((Ctq(3,1:time+1)-Ctq(2,1:time+1))/(Ctq(3,1)-Ctq(2,1))),'g','LineWidth',lw);
p4=plot(0:time,100*log((Ctq(4,1:time+1)-Ctq(3,1:time+1))/(Ctq(4,1)-Ctq(3,1))),'m-*','LineWidth',lw);
p5=plot(0:time,100*log((Ct(1:time+1)'-Ctq(4,1:time+1))/(Ct(1)-Ctq(4,1))),'r-^','LineWidth',lw);
legend([p1 p2 p3 p4 p5],'1st  Quintile','2nd Quintile','3rd Quintile','4th Quintile','5th Quintile')
ylabel('percentage (%)','FontSize',fontsize); xlabel('period','FontSize',fontsize)
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)

figure(23) %subplot(2,2,3)
%title('Aggregate Labor Supply Dynamics','FontSIze',fontsize)
hold on
plot(0:time,100*log(Et(1:time+1)/Et(1)),'b','LineWidth',lw)
plot(0:time,0*[0:time],'k','LineWidth',lw)
ylabel('percentage (%)','FontSize',fontsize); xlabel('period','FontSize',fontsize)
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)
axis([0 time -0.101 0.151])

figure(24) %subplot(2,2,4)
%title('Output')
hold on
plot(0:time,100*log(Yt(1:time+1)/Yt(1)),'b',0:time,zeros(time+1,1),'k','LineWidth',lw)
xlabel('period','FontSize',fontsize); ylabel('percentage (%)','FontSize',fontsize)
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)
axis([0 time -0.101 0.151])

%*******************************************%
% Figure 3 : Systematic Transfers Shock
%------------------------------------
% TDnontargeted.mat (3.4% T and 1.0% G)
% TDsystematic.mat
% TDlucas.mat
%------------------------------------

% figure 3c
figure(33)
%title('Aggregate Labor Supply Dynamics','FontSIze',fontsize)
hold on
plot(0:time,0*[0:time],'k','LineWidth',lw)
p3031=plot(0:time,100*log(Et(1:time+1)/Et(1)),'b','LineWidth',lw);
%p3032=plot(0:time,100*log(Et(1:time+1)/Et(1)),'k--','LineWidth',lw);
%legend([p3031 p3032],'top to bottom','systematic rule')
ylabel('percentage (%)','FontSize',fontsize); xlabel('period','FontSize',fontsize)
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)
axis([0 time -0.051 0.101])

% figure 3d
figure(34)
%title('Output','FontSIze',fontsize)
hold on
plot(0:time,0*[0:time],'k','LineWidth',lw)
p3041=plot(0:time,100*log(Yt(1:time+1)/Yt(1)),'b','LineWidth',lw);
%p3042=plot(0:time,100*log(Yt(1:time+1)/Yt(1)),'k--','LineWidth',lw);
%legend([p3041 p3042],'top to bottom','systematic rule')
ylabel('percentage (%)','FontSize',fontsize); xlabel('period','FontSize',fontsize)
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)
axis([0 time -0.101 0.151])

% figure 3e
figure(35)
%title('Aggregate Labor Supply Dynamics','FontSIze',fontsize)
hold on
plot(0:time,0*[0:time],'k','LineWidth',lw)
p3051=plot(0:time,100*log(Et(1:time+1)/Et(1)),'b','LineWidth',lw);
%p3052=plot(0:time,100*log(Et(1:time+1)/Et(1)),'k--','LineWidth',lw);
%legend([p3051 p3052],'government purchases','transfers with fixed K-low beta')
ylabel('percentage (%)','FontSize',fontsize); xlabel('period','FontSize',fontsize)
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)
axis([0 time -0.051 0.101])

% figure 3f
figure(36)
%title('Output','FontSIze',fontsize)
hold on
plot(0:time,0*[0:time],'k','LineWidth',lw)
p3061=plot(0:time,100*log(Yt(1:time+1)/Yt(1)),'b','LineWidth',lw);
%p3062=plot(0:time,100*log(Yt(1:time+1)/Yt(1)),'k--','LineWidth',lw);
%legend([p3061 p3062],'government purchases','transfers with fixed K-low beta')
ylabel('percentage (%)','FontSize',fontsize); xlabel('period','FontSize',fontsize)
set(gca,'FontSize',fontsize,'FontName','Times','LineWidth',lw)
%axis([0 time -0.101 0.151])