function [val] = nvaluef(kp,np,PARA)
% negative value function at (kgrid(ik),sgrid(is),hgrid(ih)) 
% by choosing "kp" as capital next period and 
% "np" as labor supply this period. 
% Case 1: np = 0 (no work)
% Case 2: np = 1 (work)

delta=PARA.delta; r=PARA.r; w=PARA.w; T=PARA.T; d=PARA.d;
beta=PARA.beta; chi=PARA.chi; phi=PARA.phi; 
uform=PARA.uform; gamma=PARA.gamma; EZ=PARA.EZ;
kgrid=PARA.kgrid; sgrid=PARA.sgrid; hgrid=PARA.hgrid;  
ik=PARA.ik; is=PARA.is; ih=PARA.ih;  
  
% consumption decision given decisions for capital and labor
cp = (1-delta+r)*kgrid(ik) + sgrid(is)*w*np + T(is,ih) + d - kp;
% value function (piecewise linear) 
vfh = utilf(cp,uform,gamma) -chi*np*(1-hgrid(ih))^(phi)+ beta*qinterp1(kgrid,EZ(:,is),kp); 
val= -vfh; 