function [val VAR] = VFksh01Lucas(X,r,PARA)
% discretization method

beta=PARA.beta; uform=PARA.uform; gamma=PARA.gamma;
alpha=PARA.alpha; chi=PARA.chi; phi=PARA.phi; delta=PARA.delta; 
mu=PARA.mu; G=PARA.G; A=PARA.A; K=PARA.K;
nk=PARA.nk; ns=PARA.ns; nh=PARA.nh;
kgrid=PARA.kgrid; sgrid=PARA.sgrid; hgrid=PARA.hgrid; 
sprob=PARA.sprob; sp=PARA.sp; hp=PARA.hp;
xx=PARA.xx; tyratio=PARA.tyratio; Spolicy=PARA.Spolicy; Hpolicy=PARA.Hpolicy;

% determination of (p,w,Y,T,d) given (X,r)
KXratio = K/X;
p = (1-alpha)*A*(KXratio)^(alpha); % marginal cost of aggregate intermediate good
w = p/mu; % wage = MC/markup
d = (mu-1)*w*X; % intermediate firm dividend
Y = A*(KXratio)^(alpha)*X; % output
Rk = alpha*Y; % final good firm profit

% Transfers policy (endogenous calibration of coefficients)
Ssum = (Spolicy*hp')'*sp'; 
Hsum = (Hpolicy*hp')'*sp'; 
if (Ssum == 0) || (Hsum==0)
    gam_s=0; gam_h=0;
else
    gam_s = (tyratio*Y)/((1+xx)*Ssum); % coefficient on income shock
    gam_h = xx*gam_s*Ssum/Hsum; % coefficient on health shock
end
Tpolicy = gam_s*Spolicy + gam_h*Hpolicy; % transfers policy
Tsum = (Tpolicy*hp')'*sp'; % steady state aggregate transfers
tau = Tsum + G; % total lump-sum tax to balance the budget
T = Tpolicy-tau; % net transfers (transfers - lumpsum taxes)
Tm=zeros(nk,ns,nh);
for ik=1:nk
    Tm(ik,:,:)=T; % array of transfers policy
end

%%%%%%%% Step 3: Value Function Iteration %%%%%%%%
% construct a grid for (assets,income,health) 
[ Km Sm Hm ] = ndgrid(kgrid,sgrid,hgrid);
% initialize value and decision function
%Vh = ones(nk,ns,nh); % Plain Vanilla Initialization
Vh = utilf((1-delta+r)*Km + w*Sm + Tm + d - Km,uform,gamma)/(1-beta); % This one might be faster than the above
Vh1 = Vh; Vh2 = Vh; 
decis = zeros(nk,ns,nh); decis1 = decis; decis2 = decis; % index of asset decision (1: no work; 2: work)
kdec1 = decis1; kdec2 = decis2; 
decisn = decis; % labor supply decision
Z = (1/nh)*sum(Vh,3);
EZ = Z*sprob';

iter=1; % initial iteration
diffZ=1; % initial difference between value functions
tic
% VF approximation by discretization method
for ih = 1:nh
    for is = 1:ns
        for ik =1:nk
            % Case 1: n=0 (no work)
            np = 0;
            cp = (1-delta+r)*kgrid(ik) + sgrid(is)*w*np + T(is,ih) + d - kgrid;
            vfh = utilf(cp,uform,gamma) - np*chi*(1-hgrid(ih))^(phi) + beta*EZ(:,is);
            [Vh1(ik,is,ih), decis1(ik,is,ih)] = max ( vfh ) ;
            
            % Case 2: n=1 (work)
            np = 1;
            cp = (1-delta+r)*kgrid(ik) + sgrid(is)*w*np + T(is,ih) + d - kgrid;
            vfh = utilf(cp,uform,gamma) - np*chi*(1-hgrid(ih))^(phi) + beta*EZ(:,is);
            [Vh2(ik,is,ih), decis2(ik,is,ih)] = max ( vfh ) ;
                
            % work decision
            [Vh(ik,is,ih), decisn(ik,is,ih)] = max([ Vh1(ik,is,ih) Vh2(ik,is,ih) ]);                                 
        end
    end
end
Z = hp(1)*Vh(:,:,1);
for iih = 2:nh
    Z = Z + hp(iih)*Vh(:,:,iih);
end
EZ = Z*sprob';
    
while (iter <= 200) && (diffZ > 1e-13)
    % pin down decis (capital decision with endogenous labor)
    % labor supply decision (0 or 1)
    ndec = (decisn == 2);
    % capital decision (decis: index, kdec: value)
    decis = (1-ndec).*decis1 + ndec.*decis2;
    kdec = kgrid(decis(:,:,:));
    % consumption decision (cdec)
    cdec = (1-delta+r)*Km + ndec.*Sm*w + Tm + d - kdec; 
    % evaluate utility
    U = utilf(cdec,uform,gamma); 
    
    % Iterate over the policy function for 50 periods or so...
    % that is, assume the same policy is used forever
    % use this as new expected utility
    for iHOWARD = 1:50
        for ih=1:nh
            for ik=1:nk
                for is=1:ns
                    Vh(ik,is,ih) = U(ik,is,ih) -chi*(1-hgrid(ih))^(phi)*ndec(ik,is,ih) + beta*EZ(decis(ik,is,ih),is);
                end
            end
        end
        % Update EZ
        Z = hp(1)*Vh(:,:,1);
        for iih = 2:nh
            Z = Z + hp(iih)*Vh(:,:,iih);
        end
        EZ = Z*sprob';
    end
    
    for ih = 1:nh
        for is = 1:ns
            for ik =1:nk
                % Case 1: n=0 (no work)
                np = 0;
                cp = (1-delta+r)*kgrid(ik) + sgrid(is)*w*np + T(is,ih) + d - kgrid;
                vfh = utilf(cp,uform,gamma) - np*chi*(1-hgrid(ih))^(phi) + beta*EZ(:,is);
                [Vh1(ik,is,ih), decis1(ik,is,ih)] = max ( vfh ) ;
                
                % Case 2: n=1 (work)
                np = 1;
                cp = (1-delta+r)*kgrid(ik) + sgrid(is)*w*np + T(is,ih) + d - kgrid;
                vfh = utilf(cp,uform,gamma) - np*chi*(1-hgrid(ih))^(phi) + beta*EZ(:,is);
                [Vh2(ik,is,ih), decis2(ik,is,ih)] = max ( vfh ) ;
                
                % work decision
                [Vh(ik,is,ih), decisn(ik,is,ih)] = max([ Vh1(ik,is,ih) Vh2(ik,is,ih) ]);                                 
            end
        end
    end
    Znew = hp(1)*Vh(:,:,1);
    for iih = 2:nh
        Znew = Znew + hp(iih)*Vh(:,:,iih);
    end
    EZnew = Znew*sprob';
    
    diffZ = max(abs((EZnew(:)-EZ(:)))); % Don't divide by Znew(:) since this value goes to negative and hits zero
    iter  = iter + 1;
    
    % update for next iteration
    Z    = Znew ;
    EZ   = EZnew;
end
toc

cdech = cdec; % 3 state consumption
ndech = ndec; % 3 state labor supply
kdech = kdec; % 3 state capital
% decision function (average over h)
cdec_new = hp(1)*cdec(:,:,1);
kdec_new = hp(1)*kdec(:,:,1);
ndec_new = hp(1)*ndec(:,:,1);
for iih = 2:nh
    cdec_new = cdec_new + hp(iih)*cdec(:,:,iih);
    kdec_new = kdec_new + hp(iih)*kdec(:,:,iih);
    ndec_new = ndec_new + hp(iih)*ndec(:,:,iih);
end

%%%%%%%% Stationary Distribution of (k,s) and Aggregation %%%%%%%%
% gk: stationary distribution
% pknew: price of a unit share of profit
[gk,pknew]=pdf_ke(kgrid,kdec_new,kgrid,sprob,sp); 

% Enew: aggregate labor
Enew = sum(sum(gk.*ndec_new));

% Lnew: aggregate effective labor
smatrix=repmat(sgrid',nk,1);
heff=smatrix.*ndec_new;
Lnew=sum(sum(gk.*heff)); 

% Xnew: aggregate intermediate input
Xmu = (smatrix.^(1/mu)).*ndec_new;
Xnew = (sum(sum(gk.*Xmu)))^(mu);

% 
KXrationew = K/Xnew;
pnew = (1-alpha)*A*(KXrationew)^(alpha);
wnew = pnew/mu;
dnew = (mu-1)*wnew*Xnew;
Ynew = A*(KXrationew)^(alpha)*Xnew;
Rknew = alpha*Ynew;
rnew = Rknew/pknew;

val = max( [abs((rnew-r)/r), abs((Xnew-X)/X)] ); % convergence criterion
%

VAR.Enew=Enew; VAR.rnew=rnew; VAR.Xnew=Xnew; VAR.wnew=w;
VAR.Y=Y; VAR.pknew=pknew; VAR.Rknew=Rk;
VAR.pnew=p; VAR.dnew=d; VAR.T=T; % T: net transfers (Tpolicy-tau)
VAR.gam_s = gam_s; VAR.gam_h=gam_h; VAR.tau=tau; VAR.Lnew=Lnew; 
VAR.gk=gk; VAR.kdec=kdec_new; VAR.cdec=cdec_new; VAR.ndec=ndec_new;  
VAR.VF=Z; VAR.cdech=cdech; VAR.ndech=ndech; VAR.kdech=kdech; VAR.VF2=EZ;

