function [x] = gss1(f,a,b,tol)
% [x] = gss1(f,a,b,tol)
%
% Performs golden section search on the function f.
% Assumptions: f is continuous on [a,b], and 
%              f has only one minimum in [a,b].
% When b-a < tol, the iteration stops.
%
% Example: [x] = gss('myfun',0,1,1e-5)
%

c = (-1+sqrt(5))/2;
x1 = c*a + (1-c)*b;
fx1 = feval(f,x1);
x2 = (1-c)*a + c*b;
fx2 = feval(f,x2);

while abs(b-a) > tol
    if fx1 <= fx2
        b = x2;
        x2 = x1;
        fx2 = fx1;
        x1 = c*a + (1-c)*b;
        fx1 = feval(f,x1);
    else
        a = x1;
        x1 = x2;
        fx1 = fx2;
        x2 = (1-c)*a + c*b;
        fx2 = feval(f,x2);
    end
end
x = a + (b-a)/2;
