function [p] = limitdist1(P,p0)
% [p] = limitdist1(P,p0)
% returns the stationary distribution of the transition probability matrix
% "P" by iterating over the distribution: p(t) = p(t-1)*P
% starting with p(0) = "p0".
% Here, p0 should be a row vector. 
% If p0 is not specified, uniform is the default distribution.  
%
% Input:
% P: transition probability matrix [P(i,j) = Prob(t+1=j | t=i)]
% p0: initial distribution (row vector)
% 
% Output: 
% p : stationary distribution (row vector such that p=p*P)
%
% Last Modified: Jul 3, 2010

[nr nc] = size(P);

% If initial distribution not provided, use the uniform.
if nargin==1
    p0 = 1/(nc) * ones(1,nc);
end

% Setup for loop
i=1; crit=1; maxit=10000; tol = 1e-20; tol1 = 1e-15; 

% iteration
while (i<=maxit) && (crit>tol)
    p1=p0*P;
    crit=max(abs(p1-p0));
    i=i+1;
    p0=p1;
end

p = p1;

if crit>= tol1; % set this tolerance level smaller since I am annoyed by the frequent warning during iteration, but still want to be accurate
    disp(['Warning: Stationary distribution for (k,e) not converging under tolerance ' num2str(tol1)])
    fprintf('The maximum difference compared to the tolerance level is : %.4e \n', crit)
end