function [yval] = qinterp1(xvec,yvec,x)
% [yval] = qinterp1(xvec,yvec,x)
% returns a quick linear interpolation of yvec on the point x for the
% function yvec(xvec)
% If x is a vector, the function returns a column vector with pointwise
% linear interpolation
%
% Last Modified: Jul 20, 2010

n=length(xvec);
i=sum((xvec<=x));
if i >= n
    yval = yvec(n);
else
    yval = yvec(i)+( (yvec(i+1)-yvec(i)) / (xvec(i+1)-xvec(i)) )*(x-xvec(i));
end







%nx=length(x);
%n=length(xvec);
%yval=zeros(nx,1);

%for j = 1:nx
%    i=sum((xvec<=x(j)));
%    if i >= n
%        yval(j) = yvec(n);
%    else
%        yval(j) = yvec(i)+( (yvec(i+1)-yvec(i)) / (xvec(i+1)-xvec(i)) )*(x(j)-xvec(i));
%    end
%end


