function [u] = utilf(c,uspec,gamma)
% [u] = utilf(c,uspec,gamma)
% 
% Utility function for "CRRA" or "CARA"

if strcmp(uspec,'CRRA')==1;
    % Utility is only defined if c>=0 for gamma<1 and c>0 if gamma>1
    %u = -inf*ones(size(c)); %start -inf, change only those c positive
    u = (-1e+100)*ones(size(c)); % this might be better when doing golden section search
    cpos = find(c>0);       %find positive c
    if gamma==1; u(cpos)=log(c(cpos));
    else u(cpos) = (c(cpos).^(1-gamma))./(1-gamma);
    end
elseif strcmp(uspec,'CARA')==1;
    u = -exp(-gamma*c)/gamma;
end