(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     65332,       1566]
NotebookOptionsPosition[     63568,       1509]
NotebookOutlinePosition[     63922,       1525]
CellTagsIndexPosition[     63879,       1522]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 StyleBox[
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Replication", " ", 
     StyleBox["files", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox[
         StyleBox["f", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "or"}]], ":", "\[IndentingNewLine]", 
      StyleBox[
       RowBox[{
        StyleBox[
         StyleBox[
          StyleBox["R", "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "ei", 
        StyleBox[
         StyleBox[
          StyleBox[
           StyleBox[
            StyleBox[
             StyleBox["s", "Title",
              FontColor->RGBColor[1, 0, 0]], "Title",
             FontColor->RGBColor[1, 0, 0]], "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]]}]]}]}], 
    StyleBox[
     StyleBox[
      StyleBox[
       StyleBox[
        StyleBox[
         StyleBox[",", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "Title",
       FontColor->RGBColor[1, 0, 0]], "Title",
      FontColor->RGBColor[1, 0, 0]], "Title",
     FontColor->RGBColor[1, 0, 0]], 
    StyleBox[" ", "Title",
     FontColor->RGBColor[1, 0, 0]], 
    RowBox[{
     StyleBox[
      RowBox[{
       StyleBox[
        StyleBox["R", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "icardo"}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      RowBox[{
       StyleBox[
        StyleBox[
         StyleBox["(", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], 
       StyleBox[
        RowBox[{
         StyleBox[
          StyleBox[
           StyleBox[
            StyleBox["f", "Title",
             FontColor->RGBColor[1, 0, 0]], "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "orthcoming"}]], 
       StyleBox[
        StyleBox[
         StyleBox[
          StyleBox[
           StyleBox[
            StyleBox[
             StyleBox[")", "Title",
              FontColor->RGBColor[1, 0, 0]], "Title",
             FontColor->RGBColor[1, 0, 0]], "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}], 
      StyleBox[
       StyleBox[
        StyleBox[".", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "Title",
       FontColor->RGBColor[1, 0, 0]], 
      StyleBox[" ", "Title",
       FontColor->RGBColor[1, 0, 0]], 
      StyleBox[
       RowBox[{"T", 
        StyleBox[
         StyleBox[
          StyleBox[
           StyleBox["h", "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "e"}]]}], " ", "Portuguese", " ", 
     StyleBox[
      RowBox[{"S", 
       StyleBox[
        StyleBox[
         StyleBox[
          StyleBox["l", "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ump"}]], " ", "and", " ", "Crash", 
     " ", "and", " ", "the", " ", "Euro", " ", "Crisis"}], 
    StyleBox[
     StyleBox[",", "Title",
      FontColor->RGBColor[1, 0, 0]], "Title",
     FontColor->RGBColor[1, 0, 0]], 
    StyleBox[" ", "Title",
     FontColor->RGBColor[1, 0, 0]], 
    RowBox[{
     StyleBox[
      RowBox[{
       StyleBox[
        StyleBox["B", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ro", 
       StyleBox[
        StyleBox["o", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ki", 
       StyleBox[
        StyleBox["n", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "gs"}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{
       StyleBox["Pa", "Title",
        FontColor->RGBColor[1, 0, 0]], "pe", 
       StyleBox[
        StyleBox["r", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], 
       StyleBox[
        StyleBox[
         StyleBox["s", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox["on", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{
       StyleBox["Ec", "Title",
        FontColor->RGBColor[1, 0, 0]], "on", 
       StyleBox[
        StyleBox["o", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "mi", 
       StyleBox[
        StyleBox["c", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{
       StyleBox["Ac", "Title",
        FontColor->RGBColor[1, 0, 0]], "ti", 
       StyleBox[
        StyleBox["v", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "it", 
       StyleBox[
        StyleBox["y", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}]], "\[IndentingNewLine]", "by", " ", 
     "Ricardo", " ", "Reis", "\[IndentingNewLine]", 
     StyleBox[
      RowBox[{
       StyleBox[
        StyleBox[
         StyleBox["J", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ul", 
       StyleBox["y", "Title",
        FontColor->RGBColor[1, 0, 0]]}]]}], ",", " ", "2013"}], 
   "\[IndentingNewLine]", " ", "*)"}], "Title",
  FontColor->RGBColor[1, 0, 0]]], "Input",
 CellChangeTimes->{{3.5768586463353033`*^9, 3.57685866096115*^9}, {
  3.576930877732305*^9, 3.57693090213638*^9}, {3.578503629704011*^9, 
  3.578503630127324*^9}, {3.578504323070333*^9, 3.5785043682483597`*^9}, {
  3.583630582179241*^9, 3.583630609446631*^9}},
 TextAlignment->Center],

Cell[BoxData[
 StyleBox[
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "finds", " ", "the", " ", "impulse", " ", 
    "response", " ", "for", " ", "an", " ", "economy"}], "*)"}], 
  "Subtitle"]], "Input",
 CellChangeTimes->{{3.578504418952533*^9, 3.57850442746059*^9}, {
  3.5785047340999813`*^9, 3.5785047700006037`*^9}, {3.583595940477027*^9, 
  3.583595940961279*^9}},
 TextAlignment->Center],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{"Setting", " ", "parameters"}], "*)"}], "Subtitle"], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", 
    RowBox[{
    "\[Beta]", ",", "\[Alpha]", ",", "rf", ",", "\[Gamma]", ",", "\[Psi]", 
     ",", "abar", ",", "A", ",", "\[Tau]", ",", "\[Theta]", ",", "\[Phi]"}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Beta]", "=", "0.84"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rf", "=", "1.08"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Alpha]", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Gamma]", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Psi]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"abar", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Theta]", "=", "0.25"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.576568142463111*^9, 3.576568250815782*^9}, {
   3.57656828901313*^9, 3.5765684365491657`*^9}, {3.5765684678228083`*^9, 
   3.576568475827259*^9}, {3.576568926935154*^9, 3.57656894367924*^9}, 
   3.576594851669853*^9, {3.5765962848431664`*^9, 3.576596285042989*^9}, {
   3.576596641397138*^9, 3.576596645884503*^9}, 3.57659675410345*^9, {
   3.5765970164220743`*^9, 3.57659701674228*^9}, {3.576597297101964*^9, 
   3.576597297557336*^9}, {3.576597344411269*^9, 3.576597371943157*^9}, {
   3.576597467645091*^9, 3.5765974887279997`*^9}, {3.5765975341117163`*^9, 
   3.576597562571989*^9}, {3.57659765584583*^9, 3.576597678572938*^9}, {
   3.576597718986532*^9, 3.576597726545978*^9}, {3.576604261781291*^9, 
   3.576604277391655*^9}, {3.5768452591919317`*^9, 3.5768452688646183`*^9}, {
   3.5768580122918587`*^9, 3.576858029562742*^9}, {3.5768585549965763`*^9, 
   3.576858570769487*^9}, 3.576858744360077*^9, {3.576859220674953*^9, 
   3.576859220888139*^9}, {3.576867859219014*^9, 3.576867859337244*^9}, 
   3.576868057031089*^9, {3.576930917764817*^9, 3.5769309589300337`*^9}, {
   3.576931001641756*^9, 3.576931069318158*^9}, {3.576932441246785*^9, 
   3.5769324804574842`*^9}, {3.576946156073378*^9, 3.576946157708376*^9}, {
   3.576953694234235*^9, 3.5769537145289507`*^9}, {3.576953751174453*^9, 
   3.5769537636279087`*^9}, {3.576954334582453*^9, 3.576954334687639*^9}, {
   3.577747323228088*^9, 3.577747350983404*^9}, {3.5777474399205503`*^9, 
   3.5777474718168707`*^9}, {3.577748385824712*^9, 3.577748396650079*^9}, 
   3.577748725541854*^9, {3.577748958697901*^9, 3.5777489617703867`*^9}, {
   3.577749336466115*^9, 3.577749414486216*^9}, 3.5777503368578863`*^9, {
   3.577750694259536*^9, 3.577750862707471*^9}, {3.577751221076071*^9, 
   3.5777512596612787`*^9}, {3.577751290256172*^9, 3.5777513103171587`*^9}, {
   3.57775134852606*^9, 3.577751415975402*^9}, {3.577751596888599*^9, 
   3.577751611132166*^9}, 3.577752846396555*^9, {3.5777550849332533`*^9, 
   3.577755091303933*^9}, {3.577755744575688*^9, 3.5777557451491003`*^9}, {
   3.577763946430201*^9, 3.5777639465220833`*^9}, {3.57776449158388*^9, 
   3.577764508201206*^9}, {3.578503666675148*^9, 3.578503722305316*^9}, {
   3.5785041900078382`*^9, 3.5785042183500566`*^9}, {3.5785042697792797`*^9, 
   3.578504281377235*^9}, {3.578505290058704*^9, 3.578505296292351*^9}, {
   3.583591053989065*^9, 3.58359105443643*^9}, {3.583594329351725*^9, 
   3.583594332748045*^9}, {3.583600186264749*^9, 3.583600189039103*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"The", " ", "initial", " ", "steady", " ", "state"}], ",", " ", 
     RowBox[{"see", " ", "BP_portugal60", " ", "for", " ", 
      RowBox[{"explanations", "."}]}]}], "*)"}], "Subtitle"], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"\[Tau]", "=", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "0.115"}], ")"}], "/", "1.118"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Phi]", "=", "0.0001"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Phi]0", "=", "\[Phi]"}], ";", 
    RowBox[{"\[Tau]0", "=", "\[Tau]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"w", ",", "r", ",", "p"}], "]"}], ";", 
    RowBox[{"w", "=", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
          FractionBox[
           RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
         "\[Alpha]", "\[Times]", 
         SuperscriptBox["A", 
          RowBox[{"1", "/", "\[Alpha]"}]]}], "rf"], ")"}], 
      FractionBox["\[Alpha]", 
       RowBox[{"1", "-", "\[Alpha]"}]]]}], ";", 
    RowBox[{
     RowBox[{"r", "[", "a_", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       FractionBox[
        RowBox[{"\[Theta]", "\[Times]", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Phi]"}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}], "\[Times]", 
         "\[Beta]"}]], ")"}], "\[Times]", 
      FractionBox["abar", "a"]}]}], ";", " ", 
    RowBox[{
     RowBox[{"p", "[", "a_", "]"}], "=", 
     RowBox[{
      FractionBox[
       SuperscriptBox["w", 
        RowBox[{"1", "-", "\[Alpha]"}]], "a"], "\[Times]", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         FractionBox["1", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", 
             RowBox[{"\[Theta]", " ", "\[Phi]"}]}], 
            RowBox[{"r", "[", "a", "]"}]], "+", 
           FractionBox[
            RowBox[{"\[Theta]", " ", "\[Phi]"}], "rf"]}]], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
           FractionBox[
            RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
          "\[Alpha]"}]], ")"}], "\[Alpha]"]}]}], " ", ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"temp1", ",", "temp2", ",", "M"}], "]"}], ";", " ", 
    RowBox[{
     RowBox[{"temp1", "[", "a_", "]"}], " ", "=", " ", 
     RowBox[{"\[Alpha]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
       FractionBox[
        RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"p", "[", "a", "]"}], 
         SuperscriptBox["w", 
          RowBox[{"1", "-", "\[Alpha]"}]]], ")"}], 
       RowBox[{"1", "/", "\[Alpha]"}]]}]}], ";", 
    RowBox[{
     RowBox[{"temp2", "[", "a_", "]"}], "=", 
     RowBox[{"\[Theta]", "\[Times]", 
      RowBox[{"temp1", "[", "a", "]"}], "\[Times]", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "-", "\[Phi]"}], 
         RowBox[{"r", "[", "a", "]"}]], "+", 
        FractionBox["\[Phi]", "rf"]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"M", "[", "a_", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         RowBox[{"temp1", "[", "a", "]"}], "\[Times]", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Theta]"}], ")"}]}], "abar"], ")"}], "\[Times]", 
      FractionBox[
       RowBox[{"a", "-", "abar", "-", 
        RowBox[{"a", "\[Times]", 
         RowBox[{"Hypergeometric2F1", "[", 
          RowBox[{"1", ",", "\[Alpha]", ",", 
           RowBox[{"1", "+", "\[Alpha]"}], ",", 
           RowBox[{
            SuperscriptBox["a", 
             FractionBox["1", "\[Alpha]"]], " ", 
            RowBox[{"temp2", "[", "a", "]"}]}]}], "]"}]}], "+", 
        RowBox[{"abar", "\[Times]", 
         RowBox[{"Hypergeometric2F1", "[", 
          RowBox[{"1", ",", "\[Alpha]", ",", 
           RowBox[{"1", "+", "\[Alpha]"}], ",", 
           RowBox[{
            SuperscriptBox["abar", 
             FractionBox["1", "\[Alpha]"]], " ", 
            RowBox[{"temp2", "[", "a", "]"}]}]}], "]"}]}]}], 
       RowBox[{"temp2", "[", "a", "]"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ClearAll", "[", 
    RowBox[{"temp1", ",", "temp2"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EQ", "[", "a_", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       FractionBox[
        RowBox[{"1", "-", "\[Theta]"}], 
        RowBox[{"\[Beta]", "\[Times]", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}]}]], ")"}], "-", 
      RowBox[{"M", "[", "a", "]"}]}]}], ";", "  ", 
    RowBox[{"asol", "=", 
     RowBox[{"Extract", "[", 
      RowBox[{
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"FindRoot", "[", 
          RowBox[{
           RowBox[{"Re", "[", 
            RowBox[{"EQ", "[", "j", "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0.5", ",", "0", ",", "0.99999"}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"{", "1", "}"}]}], "]"}], ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"With", " ", "it", " ", "calculated"}], ",", " ", 
     RowBox[{
      RowBox[{
      "now", " ", "write", " ", "down", " ", "the", " ", "initial", " ", 
       "conditions", " ", "at", " ", "that", " ", "steady", " ", "state", " ",
        "for", " ", "reduced"}], "-", 
      RowBox[{"form", " ", "equilibrium"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a0", "=", "asol"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w0", "=", "w"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p0", "=", 
     RowBox[{"p", "[", "asol", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r0", "=", 
     RowBox[{"r", "[", "asol", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L0", "=", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"w", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Tau]"}], ")"}]}], 
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          RowBox[{"-", "\[Gamma]"}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Gamma]"}], ")"}], 
          RowBox[{"\[Gamma]", "-", "1"}]], 
         RowBox[{
          RowBox[{"p", "[", "asol", "]"}], "^", "\[Gamma]"}]}]], ")"}], 
      RowBox[{"1", "/", "\[Psi]"}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Z0", "=", 
     FractionBox[
      RowBox[{"w", " ", "L0"}], 
      RowBox[{"\[Beta]", "-", "1", "+", 
       FractionBox["1", 
        RowBox[{"\[Gamma]", " ", "\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}]}]]}]]}], " ", ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Same", " ", "but", " ", "for", " ", "the", " ", "other", " ", 
     "variables", " ", "that", " ", "I", " ", "use", " ", "to", " ", 
     "calculate", " ", "GDP", " ", "and", " ", "TFP"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Y0", " ", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Alpha]"}], ")"}], "\[Times]", "w0", "\[Times]", 
      "L0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tfp0", "=", 
     RowBox[{"0.5", "\[Times]", 
      RowBox[{"(", 
       RowBox[{"abar", "+", "a0"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Phi]0", "=", "\[Phi]"}], ";", 
    RowBox[{"\[Theta]0", "=", "\[Theta]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"{", 
     RowBox[{
     "a0", ",", "w0", ",", "p0", ",", "r0", ",", "L0", ",", "Z0", ",", "Y0", 
      ",", "tfp0"}], "}"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.583594345544524*^9, 3.583594345689232*^9}, 
   3.5836001973409157`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.673141751128398`", ",", "0.40428039610636896`", ",", 
   "1.1363830705464946`", ",", "0.44210112525862566`", ",", 
   "0.1501038309550448`", ",", "0.009326201100903483`", ",", 
   "0.042478825364912265`", ",", "0.836570875564199`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.583594364968026*^9, 3.583595001855123*^9, 3.583595159095558*^9, 
   3.583595829613806*^9, {3.583595895712379*^9, 3.5835959130426598`*^9}, 
   3.583630749011022*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{"Shocks", " ", "to", " ", "parameters"}], " ", "*)"}], "Subtitle"],
   "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", 
    RowBox[{"\[Phi]", ",", "\[Tau]"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Phi]", "=", "0.35"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Tau]", "=", "\[Tau]0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"\[Tau]", "=", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "0.124"}], ")"}], "/", "1.126"}]}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"cc", "=", 
      RowBox[{"\[Tau]", "-", "\[Tau]0"}]}], ";", " ", 
     RowBox[{"\[Tau]", "=", 
      RowBox[{"1", "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "0.124"}], ")"}], "/", "1.126"}], "+", "cc"}]}], 
     ";"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"ClearAll", "[", 
    RowBox[{"w", ",", "r", ",", "p", ",", "M", ",", "EQ", ",", "asol"}], 
    "]"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Getting", " ", "rid", " ", "of", " ", "steady"}], "-", 
     RowBox[{"state", " ", "system"}]}], "*)"}], " ", " "}]}]], "Input",
 CellChangeTimes->{{3.576568142463111*^9, 3.576568250815782*^9}, {
   3.57656828901313*^9, 3.5765684365491657`*^9}, {3.5765684678228083`*^9, 
   3.576568475827259*^9}, {3.576568926935154*^9, 3.57656894367924*^9}, 
   3.576594851669853*^9, {3.5765962848431664`*^9, 3.576596285042989*^9}, {
   3.576596641397138*^9, 3.576596645884503*^9}, 3.57659675410345*^9, {
   3.5765970164220743`*^9, 3.57659701674228*^9}, {3.576597297101964*^9, 
   3.576597297557336*^9}, {3.576597344411269*^9, 3.576597371943157*^9}, {
   3.576597467645091*^9, 3.5765974887279997`*^9}, {3.5765975341117163`*^9, 
   3.576597562571989*^9}, {3.57659765584583*^9, 3.576597678572938*^9}, {
   3.576597718986532*^9, 3.576597726545978*^9}, {3.576604261781291*^9, 
   3.576604277391655*^9}, {3.5768452591919317`*^9, 3.5768452688646183`*^9}, {
   3.5768580122918587`*^9, 3.576858029562742*^9}, {3.5768585549965763`*^9, 
   3.576858570769487*^9}, 3.576858744360077*^9, {3.576859220674953*^9, 
   3.576859220888139*^9}, {3.576867859219014*^9, 3.576867859337244*^9}, 
   3.576868057031089*^9, {3.576930917764817*^9, 3.5769309589300337`*^9}, {
   3.576931001641756*^9, 3.576931069318158*^9}, {3.576932441246785*^9, 
   3.5769324804574842`*^9}, {3.576946156073378*^9, 3.576946157708376*^9}, {
   3.576953694234235*^9, 3.5769537145289507`*^9}, {3.576953751174453*^9, 
   3.5769537636279087`*^9}, {3.576954334582453*^9, 3.576954334687639*^9}, {
   3.576954377324704*^9, 3.576954448171402*^9}, {3.577009759973589*^9, 
   3.577009760877378*^9}, {3.577009807351359*^9, 3.5770098103625507`*^9}, {
   3.5770177665933743`*^9, 3.577017797100525*^9}, {3.5770182393313217`*^9, 
   3.577018249360651*^9}, {3.5770182802782087`*^9, 3.577018290710071*^9}, 
   3.577021071404306*^9, {3.57702721836016*^9, 3.577027230980986*^9}, {
   3.577027494836749*^9, 3.5770275010197477`*^9}, 3.577029959422717*^9, {
   3.577030379658023*^9, 3.57703040421618*^9}, {3.577030556175338*^9, 
   3.5770305563332987`*^9}, {3.5770309132475*^9, 3.577030915913233*^9}, {
   3.5777524573469067`*^9, 3.5777524575441847`*^9}, 3.577752627222561*^9, {
   3.577752671406*^9, 3.577752714496785*^9}, {3.57775276645535*^9, 
   3.5777527697010307`*^9}, {3.57775280926698*^9, 3.577752819953932*^9}, {
   3.577752877929471*^9, 3.577752879942328*^9}, {3.5777554023734713`*^9, 
   3.577755406003168*^9}, {3.577755760381462*^9, 3.5777557606054277`*^9}, {
   3.577755805826351*^9, 3.577755833288972*^9}, {3.577756431976489*^9, 
   3.5777564325396967`*^9}, {3.577756565260528*^9, 3.57775656543491*^9}, {
   3.577756721386959*^9, 3.577756721865856*^9}, {3.577764826008483*^9, 
   3.5777648262241163`*^9}, 3.5777665743315973`*^9, {3.577766664462385*^9, 
   3.577766740274211*^9}, 3.577767449751445*^9, {3.577768098905307*^9, 
   3.577768101094222*^9}, {3.5777681881779003`*^9, 3.5777682096551228`*^9}, {
   3.5777683372647543`*^9, 3.577768339287616*^9}, {3.57776840774852*^9, 
   3.577768411466818*^9}, {3.577768755647347*^9, 3.577768756806068*^9}, {
   3.5777688259390583`*^9, 3.577768829057131*^9}, {3.577768918630642*^9, 
   3.57776896168237*^9}, 3.577768993360383*^9, 3.577769031486478*^9, 
   3.577769067115802*^9, 3.577769116296884*^9, {3.5777691576223516`*^9, 
   3.577769183123699*^9}, 3.577769331307075*^9, 3.57776952852348*^9, {
   3.577770604228904*^9, 3.577770606132168*^9}, {3.577771511441264*^9, 
   3.577771514459856*^9}, {3.577771592454712*^9, 3.5777715942190723`*^9}, {
   3.577771719986549*^9, 3.577771847480386*^9}, {3.5777718998953323`*^9, 
   3.577771924651072*^9}, {3.577772120841693*^9, 3.5777721597159977`*^9}, {
   3.577782321481996*^9, 3.577782323794705*^9}, {3.577782407985108*^9, 
   3.577782409620945*^9}, {3.577782527494239*^9, 3.577782582006694*^9}, {
   3.577782614692233*^9, 3.57778263075247*^9}, 3.577782678460883*^9, {
   3.577782728021605*^9, 3.5777827530000477`*^9}, {3.577782940822111*^9, 
   3.57778297170745*^9}, {3.5777830021231937`*^9, 3.5777830951397038`*^9}, {
   3.577783251836049*^9, 3.577783253539332*^9}, {3.5779942731912518`*^9, 
   3.577994313725197*^9}, {3.577994457367481*^9, 3.577994465807864*^9}, {
   3.578505201552644*^9, 3.578505258355994*^9}, 3.578507278660129*^9, {
   3.5785073099542437`*^9, 3.5785073521899033`*^9}, {3.5785073848606997`*^9, 
   3.578507410049756*^9}, {3.5785074448097897`*^9, 3.578507454605893*^9}, {
   3.578507548977249*^9, 3.578507549240138*^9}, {3.5785092185701733`*^9, 
   3.578509220384676*^9}, {3.5835918154092484`*^9, 3.583591823645336*^9}, {
   3.583591864777338*^9, 3.583591887480379*^9}, {3.5835919932501173`*^9, 
   3.5835920768680067`*^9}, 3.5836002071558647`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{
    "Definining", " ", "the", " ", "equations", " ", "of", " ", "the", " ", 
     "model", " ", "as", " ", "a", " ", "function", " ", "of", " ", "the", 
     " ", "guess", " ", "a"}], "*)"}], "Subtitle"], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Initial", " ", "conditions"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"loop", ",", "Beginloop", ",", "maxloop"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{
     "wpath", ",", "Lpath", ",", "apath", ",", "ppath", ",", "Zpath", ",", 
      "Yindex", ",", "tfpindex"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"apath", "[", "0", "]"}], "=", "a0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ppath", "[", "0", "]"}], "=", "p0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Zpath", "[", "0", "]"}], "=", "Z0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Yindex", "[", "0", "]"}], "=", "1"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"tfpindex", "[", "0", "]"}], "=", "1"}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.5770196325059767`*^9, {3.5770200974037533`*^9, 3.577020113813343*^9}, {
   3.577020316701213*^9, 3.577020317418762*^9}, {3.577027235913951*^9, 
   3.5770272623467693`*^9}, {3.57775238687857*^9, 3.577752396433614*^9}, {
   3.5777561330063887`*^9, 3.577756151988963*^9}, {3.57775631054602*^9, 
   3.577756322760045*^9}, {3.577756379267497*^9, 3.5777563798406487`*^9}, {
   3.578509236643421*^9, 3.5785092424991913`*^9}, {3.578509376420991*^9, 
   3.578509566218018*^9}, {3.583591625751354*^9, 3.5835916303284283`*^9}, {
   3.5835919194808073`*^9, 3.583591923565205*^9}, {3.5835935709401007`*^9, 
   3.5835935715953493`*^9}, {3.583595167894635*^9, 3.5835951685800743`*^9}, {
   3.583595342759144*^9, 3.583595346584428*^9}, {3.583595833864387*^9, 
   3.583595928077612*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{"Solving", " ", "the", " ", "model"}], "*)"}], "Subtitle"], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"loop", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"maxloop", "=", "20"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Label", "[", "BeginLoop", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ClearAll", "[", 
       RowBox[{
       "w", ",", "L", ",", "x", ",", "r", ",", "EQ1", ",", "temp1", ",", 
        "temp2", ",", "M", ",", "EQ2"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"w", "=", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
            FractionBox[
             RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
           "\[Alpha]", "\[Times]", 
           SuperscriptBox["A", 
            RowBox[{"1", "/", "\[Alpha]"}]]}], "rf"], ")"}], 
        FractionBox["\[Alpha]", 
         RowBox[{"1", "-", "\[Alpha]"}]]]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"eq", " ", "29"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"L", " ", "[", "p_", "]"}], "=", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"w", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Tau]"}], ")"}]}], 
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            RowBox[{"-", "\[Gamma]"}]], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Gamma]"}], ")"}], 
            RowBox[{"\[Gamma]", "-", "1"}]], 
           SuperscriptBox["p", "\[Gamma]"]}]], ")"}], 
        RowBox[{"1", "/", "\[Psi]"}]]}], ";", " ", 
      RowBox[{"(*", 
       RowBox[{"eq", " ", "37"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"x", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
        "\[Alpha]", "\[Times]", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           RowBox[{"p", " ", "a"}], 
           SuperscriptBox["w", 
            RowBox[{"1", "-", "\[Alpha]"}]]], ")"}], 
         RowBox[{"1", "/", "\[Alpha]"}]]}]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"eq", " ", "6"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"r", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}], 
         RowBox[{"x", "[", 
          RowBox[{"p", ",", "a"}], "]"}]}], 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"\[Theta]", " ", "\[Phi]", " ", 
           RowBox[{"x", "[", 
            RowBox[{"p", ",", "a"}], "]"}]}], "rf"]}]]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"eqs", " ", "19", " ", "and", " ", "40"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"EQ1", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Beta]", "-", "1", "+", 
           FractionBox["1", 
            RowBox[{"\[Gamma]", " ", "\[Alpha]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}]}]]}], ")"}], 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}], "\[Beta]"}], 
          RowBox[{"\[Theta]", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Phi]"}], ")"}]}]], 
         FractionBox["a", "abar"], 
         RowBox[{"r", "[", 
          RowBox[{"p", ",", "a"}], "]"}], 
         RowBox[{"Zpath", "[", 
          RowBox[{"loop", "-", "1"}], "]"}]}], "-", 
        RowBox[{"w", "*", 
         RowBox[{"L", "[", "p", "]"}]}]}]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"eqs", " ", "38", " ", "and", " ", "39"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"temp1", "[", "p_", "]"}], " ", "=", " ", 
       RowBox[{"\[Alpha]", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["p", 
           SuperscriptBox["w", 
            RowBox[{"1", "-", "\[Alpha]"}]]], ")"}], 
         RowBox[{"1", "/", "\[Alpha]"}]]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"temp2", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       RowBox[{"\[Theta]", "\[Times]", 
        RowBox[{"temp1", "[", "p", "]"}], "\[Times]", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"1", "-", "\[Phi]"}], 
           RowBox[{"r", "[", 
            RowBox[{"p", ",", "a"}], "]"}]], "+", 
          FractionBox["\[Phi]", "rf"]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"M", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         FractionBox[
          RowBox[{
           RowBox[{"temp1", "[", "p", "]"}], "\[Times]", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Theta]"}], ")"}]}], "abar"], ")"}], 
        "\[Times]", 
        FractionBox[
         RowBox[{"a", "-", "abar", "-", 
          RowBox[{"a", "\[Times]", 
           RowBox[{"Hypergeometric2F1", "[", 
            RowBox[{"1", ",", "\[Alpha]", ",", 
             RowBox[{"1", "+", "\[Alpha]"}], ",", 
             RowBox[{
              SuperscriptBox["a", 
               FractionBox["1", "\[Alpha]"]], " ", 
              RowBox[{"temp2", "[", 
               RowBox[{"p", ",", "a"}], "]"}]}]}], "]"}]}], "+", 
          RowBox[{"abar", "\[Times]", 
           RowBox[{"Hypergeometric2F1", "[", 
            RowBox[{"1", ",", "\[Alpha]", ",", 
             RowBox[{"1", "+", "\[Alpha]"}], ",", 
             RowBox[{
              SuperscriptBox["abar", 
               FractionBox["1", "\[Alpha]"]], " ", 
              RowBox[{"temp2", "[", 
               RowBox[{"p", ",", "a"}], "]"}]}]}], "]"}]}]}], 
         RowBox[{"temp2", "[", 
          RowBox[{"p", ",", "a"}], "]"}]]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"EQ2", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Theta]"}], ")"}], "\[Times]", 
           RowBox[{"r", "[", 
            RowBox[{"p", ",", "a"}], "]"}], "\[Times]", "a"}], 
          RowBox[{"\[Theta]", "\[Times]", 
           RowBox[{"(", 
            RowBox[{"1", "-", " ", "\[Phi]"}], ")"}], "\[Times]", "abar"}]], 
         ")"}], "-", 
        RowBox[{"M", "[", 
         RowBox[{"p", ",", "a"}], "]"}]}]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"eq", " ", "41"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ClearAll", "[", 
       RowBox[{
       "temp1", ",", "temp2", ",", "temp3", ",", "temp4", ",", "temp5", ",", 
        "temp6"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"temp1", "=", 
       RowBox[{"ppath", "[", 
        RowBox[{"loop", "-", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"temp2", "=", 
       RowBox[{"apath", "[", 
        RowBox[{"loop", "-", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"temp3", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", 
            RowBox[{"EQ2", "[", 
             RowBox[{"ps", ",", "as"}], "]"}], "]"}], ",", 
           RowBox[{"EQ1", "[", 
            RowBox[{"ps", ",", "as"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"ps", ",", "temp1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"as", ",", "temp2"}], "}"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp4", "=", 
       RowBox[{"Extract", "[", 
        RowBox[{"temp3", ",", 
         RowBox[{"{", "1", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"psol", "=", 
       RowBox[{"Extract", "[", 
        RowBox[{"temp4", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"temp5", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", 
            RowBox[{"EQ2", "[", 
             RowBox[{"ps", ",", "as"}], "]"}], "]"}], ",", 
           RowBox[{"EQ1", "[", 
            RowBox[{"ps", ",", "as"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"ps", ",", "psol"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"as", ",", "temp2"}], "}"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp6", "=", 
       RowBox[{"Extract", "[", 
        RowBox[{"temp5", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"asol", "=", 
       RowBox[{"Extract", "[", 
        RowBox[{"temp6", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", "asol", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"wpath", "[", "loop", "]"}], "=", "w"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Lpath", "[", "loop", "]"}], "=", 
       RowBox[{"L", "[", "psol", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"apath", "[", "loop", "]"}], "=", "asol"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ppath", "[", "loop", "]"}], "=", "psol"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Zpath", "[", "loop", "]"}], "=", 
       FractionBox[
        RowBox[{
         RowBox[{"wpath", "[", "loop", "]"}], " ", 
         RowBox[{"Lpath", "[", "loop", "]"}]}], 
        RowBox[{"\[Beta]", "-", "1", "+", 
         FractionBox["1", 
          RowBox[{"\[Gamma]", " ", "\[Alpha]", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}]}]]}]]}], " ", ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Ypath", "[", "loop", "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Alpha]"}], ")"}], "\[Times]", 
        RowBox[{"wpath", "[", "loop", "]"}], "\[Times]", 
        RowBox[{"Lpath", "[", "loop", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tfp", "[", "loop", "]"}], "=", 
       RowBox[{"0.5", "\[Times]", 
        RowBox[{"(", 
         RowBox[{"abar", "+", 
          RowBox[{"apath", "[", "loop", "]"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Yindex", "[", "loop", "]"}], "=", 
       RowBox[{
        RowBox[{"Ypath", "[", "loop", "]"}], "/", "Y0"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tfpindex", "[", "loop", "]"}], "=", 
       RowBox[{
        RowBox[{"tfp", "[", "loop", "]"}], "/", "tfp0"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"ClearAll", "[", 
       RowBox[{"psol", ",", "asol", ",", "ps", ",", "as"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"loop", "=", 
       RowBox[{"loop", "+", "1"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"loop", "\[LessEqual]", "maxloop"}], ",", " ", 
        RowBox[{"Goto", "[", "BeginLoop", "]"}]}], "]"}]}], ")"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Printed", " ", "are", " ", "the", " ", "solutions", " ", "for", " ", "a",
      "*", " ", "see", " ", "if", " ", "they", " ", "seem", " ", "to", " ", 
     "converge"}], " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.576568848259672*^9, 3.576568924112115*^9}, {
   3.5765689635497217`*^9, 3.576569010667634*^9}, {3.576593960663879*^9, 
   3.576593962844702*^9}, 3.576594801516539*^9, {3.5765971483308687`*^9, 
   3.576597168756711*^9}, 3.576845379735968*^9, {3.576845618110015*^9, 
   3.57684570685353*^9}, {3.57684574910823*^9, 3.5768457537743*^9}, 
   3.5768458642009907`*^9, {3.576845906347534*^9, 3.576845944895134*^9}, {
   3.5768460925105267`*^9, 3.576846092861925*^9}, {3.576846435818573*^9, 
   3.576846505355893*^9}, {3.576846536647139*^9, 3.576846578734788*^9}, 
   3.576846642096393*^9, {3.576846674427297*^9, 3.576846706915126*^9}, 
   3.576857564279457*^9, 3.5768586851800537`*^9, {3.576931103232319*^9, 
   3.576931118525176*^9}, {3.576931169410565*^9, 3.5769312767352*^9}, {
   3.5769313139086437`*^9, 3.576931339234105*^9}, {3.576931379326527*^9, 
   3.576931425708765*^9}, 3.57693161309846*^9, {3.57693248583175*^9, 
   3.576932496488472*^9}, {3.577008922508029*^9, 3.577009193647162*^9}, {
   3.57700926013571*^9, 3.577009339066244*^9}, {3.577009386273306*^9, 
   3.5770094275666447`*^9}, {3.577009540207925*^9, 3.577009642488489*^9}, {
   3.577010251147545*^9, 3.577010262463252*^9}, {3.57701780960213*^9, 
   3.577017810026084*^9}, {3.5770183095403547`*^9, 3.5770183670459347`*^9}, {
   3.577018415817087*^9, 3.577018490042233*^9}, {3.577018625115223*^9, 
   3.57701886189013*^9}, {3.5770190362448387`*^9, 3.5770194288151503`*^9}, {
   3.57701946329136*^9, 3.577019466948351*^9}, {3.577019501991807*^9, 
   3.577019528977051*^9}, {3.577019561856369*^9, 3.577019605949305*^9}, {
   3.577019647337861*^9, 3.577019701701527*^9}, {3.57701981122571*^9, 
   3.5770198849868727`*^9}, {3.57702005512297*^9, 3.577020073897745*^9}, {
   3.5770201479334517`*^9, 3.577020350128683*^9}, {3.5770204045011377`*^9, 
   3.577020413788368*^9}, {3.5770204488837214`*^9, 3.5770205981502857`*^9}, {
   3.577021089563033*^9, 3.5770210897654552`*^9}, {3.577021159842229*^9, 
   3.577021182274872*^9}, {3.577021231920166*^9, 3.577021279705537*^9}, {
   3.577027843719658*^9, 3.577027889277466*^9}, {3.57702814553866*^9, 
   3.5770281868879147`*^9}, 3.577030295981948*^9, {3.5777524020072107`*^9, 
   3.5777524143380527`*^9}, {3.577755678636342*^9, 3.577755681695964*^9}, {
   3.577756160968165*^9, 3.577756173169348*^9}, {3.577756254838807*^9, 
   3.577756264416573*^9}, {3.577756330564275*^9, 3.577756332650766*^9}, {
   3.577768110321865*^9, 3.5777681104561462`*^9}, {3.578505392885482*^9, 
   3.5785054340344543`*^9}, {3.578505814808563*^9, 3.578505826962782*^9}, {
   3.5785077162836733`*^9, 3.5785077164528217`*^9}, {3.5835920840643177`*^9, 
   3.5835920944759502`*^9}, {3.58359221753226*^9, 3.583592240402791*^9}, {
   3.583592281350213*^9, 3.583592287511373*^9}, {3.583592655801856*^9, 
   3.58359269526478*^9}, {3.583592747485918*^9, 3.583592799648731*^9}, {
   3.583592863330517*^9, 3.583592944484764*^9}, {3.5835930166630297`*^9, 
   3.583593121832058*^9}, {3.583593214211474*^9, 3.583593417331991*^9}, {
   3.58359346316883*^9, 3.583593636979582*^9}, {3.583594415193169*^9, 
   3.5835944625697412`*^9}, {3.5835945123935432`*^9, 3.583594512955429*^9}, {
   3.5835949654756203`*^9, 3.583594970825944*^9}, {3.5835950108761177`*^9, 
   3.58359503746485*^9}, {3.58359518232732*^9, 3.583595253889654*^9}, {
   3.583595314375044*^9, 3.5835953354054813`*^9}, {3.5835954283798847`*^9, 
   3.583595669400648*^9}, {3.5835957043191147`*^9, 3.5835957831969957`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["0.6076977137522088`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5836307491713867`*^9}],

Cell[BoxData["0.6098723398992004`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5836307492142563`*^9}],

Cell[BoxData["0.6101162469667574`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749292737*^9}],

Cell[BoxData["0.6101424135362937`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749295939*^9}],

Cell[BoxData["0.6101452072503647`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749298881*^9}],

Cell[BoxData["0.6101455053724151`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5836307493030643`*^9}],

Cell[BoxData["0.6101455371837903`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5836307493074093`*^9}],

Cell[BoxData["0.6101455405782295`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749310522*^9}],

Cell[BoxData["0.6101455409404353`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749313512*^9}],

Cell[BoxData["0.6101455409790847`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749316515*^9}],

Cell[BoxData["0.6101455409832087`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749319583*^9}],

Cell[BoxData["0.6101455409836487`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749391453*^9}],

Cell[BoxData["0.6101455409836958`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749394607*^9}],

Cell[BoxData["0.6101455409837008`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749399246*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"FindRoot", "::", "lstol"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The line search decreased the step size to within \
tolerance specified by AccuracyGoal and PrecisionGoal but was unable to find \
a sufficient decrease in the merit function. You may need more than \
\[NoBreak]\\!\\(MachinePrecision\\)\[NoBreak] digits of working precision to \
meet these tolerances. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/FindRoot/lstol\\\", ButtonNote -> \
\\\"FindRoot::lstol\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{3.58363074953239*^9}],

Cell[CellGroupData[{

Cell[BoxData["0.6101455409837008`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5836307497493067`*^9}],

Cell[BoxData["0.6101455409837008`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749750945*^9}],

Cell[BoxData["0.6101455409837008`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749756755*^9}],

Cell[BoxData["0.6101455409837008`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.583630749762022*^9}],

Cell[BoxData["0.6101455409837008`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5836307497712812`*^9}],

Cell[BoxData["0.6101455409837008`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5836307497743807`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{"Display", " ", "solution"}], "*)"}], "Subtitle"], 
  StyleBox["\[IndentingNewLine]", "Subtitle"], 
  RowBox[{
   RowBox[{
    RowBox[{"figure1", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"tfpindex", "[", "j", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"1", ",", 
             RowBox[{"tfpindex", "[", "maxloop", "]"}]}], "]"}], "-", 
           "0.05"}], ",", 
          RowBox[{
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"tfpindex", "[", "0", "]"}], ",", 
             RowBox[{"tfpindex", "[", "maxloop", "]"}]}], "]"}], "+", 
           "0.05"}]}], "}"}]}], ",", 
       RowBox[{"PlotJoined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Hue", "[", ".6", "]"}]}], ",", 
       RowBox[{"PlotLabel", "\[Rule]", "\"\<Threshold\>\""}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"figure1", ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", "\"\<Figure 1. Impulse response for TFP\>\""}], 
     ",", 
     StyleBox[
      RowBox[{"ImageSize", "->", "700"}], "MR"]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"tfpindex", "[", "0", "]"}], ",", 
      RowBox[{"tfpindex", "[", "1", "]"}], ",", 
      RowBox[{"tfpindex", "[", "2", "]"}], ",", 
      RowBox[{"tfpindex", "[", "3", "]"}], ",", 
      RowBox[{"tfpindex", "[", "4", "]"}], ",", 
      RowBox[{"tfpindex", "[", "5", "]"}], ",", 
      RowBox[{"tfpindex", "[", "maxloop", "]"}]}], "}"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"figure2", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Yindex", "[", "j", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{
             RowBox[{"Yindex", "[", "0", "]"}], ",", 
             RowBox[{"Yindex", "[", "maxloop", "]"}]}], "]"}], "-", "0.05"}], 
          ",", 
          RowBox[{
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"Yindex", "[", "0", "]"}], ",", 
             RowBox[{"Yindex", "[", "maxloop", "]"}]}], "]"}], "+", 
           "0.05"}]}], "}"}]}], ",", 
       RowBox[{"PlotJoined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Hue", "[", ".6", "]"}]}], ",", 
       RowBox[{"PlotLabel", "\[Rule]", "\"\<Threshold\>\""}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"figure2", ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<Figure 2. Impulse response for output index\>\""}], ",", 
     StyleBox[
      RowBox[{"ImageSize", "->", "700"}], "MR"]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Yindex", "[", "0", "]"}], ",", 
      RowBox[{"Yindex", "[", "1", "]"}], ",", 
      RowBox[{"Yindex", "[", "2", "]"}], ",", 
      RowBox[{"Yindex", "[", "3", "]"}], ",", 
      RowBox[{"Yindex", "[", "4", "]"}], ",", 
      RowBox[{"Yindex", "[", "5", "]"}], ",", 
      RowBox[{"Yindex", "[", "maxloop", "]"}]}], "}"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.577756599981761*^9, 3.577756600179932*^9}, {
  3.5777566887781477`*^9, 3.577756706428228*^9}, {3.5777681321903477`*^9, 
  3.5777681342622747`*^9}, {3.5785057065812263`*^9, 3.578505795164377*^9}, {
  3.578505853706347*^9, 3.578505878271718*^9}, {3.578507723314719*^9, 
  3.578507735801302*^9}, {3.5835936712339497`*^9, 3.5835936967880507`*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.6], 
    LineBox[{{0., 1.}, {1., 0.9608855392365576}, {2., 0.9621852654226534}, {
     3., 0.9623310433087126}, {4., 0.9623466824914171}, {5., 
     0.9623483522328296}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.915},
  DisplayFunction:>Identity,
  ImageSize->700,
  PlotLabel->FormBox[
   "\"Figure 1. Impulse response for TFP\"", TraditionalForm],
  PlotRange->{{0., 5.}, {0.9123485516978993, 1.05}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{
  3.5835950023408537`*^9, 3.5835957864828*^9, 3.583595840056633*^9, {
   3.583595896133157*^9, 3.583595913445622*^9}, 3.583630749982476*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0.9608855392365576`", ",", "0.9621852654226534`", ",", 
   "0.9623310433087126`", ",", "0.9623466824914171`", ",", 
   "0.9623483522328296`", ",", "0.9623485516978993`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.583595002361383*^9, 3.583595786491796*^9, 3.583595840065131*^9, {
   3.583595896144064*^9, 3.583595913455843*^9}, 3.583630749994485*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.6], 
    LineBox[{{0., 1.}, {1., 0.9903454317963208}, {2., 0.9793754782751886}, {
     3., 0.978210901006066}, {4., 0.9780867023757414}, {5., 
     0.9780734505102612}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.93},
  DisplayFunction:>Identity,
  ImageSize->700,
  PlotLabel->FormBox[
   "\"Figure 2. Impulse response for output index\"", TraditionalForm],
  PlotRange->{{0., 5.}, {0.9280718675683644, 1.05}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{
  3.5835950023408537`*^9, 3.5835957864828*^9, 3.583595840056633*^9, {
   3.583595896133157*^9, 3.583595913445622*^9}, 3.583630750053344*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "0.9903454317963208`", ",", "0.9793754782751886`", ",", 
   "0.978210901006066`", ",", "0.9780867023757414`", ",", 
   "0.9780734505102612`", ",", "0.9780718675683644`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.583595002361383*^9, 3.583595786491796*^9, 3.583595840065131*^9, {
   3.583595896144064*^9, 3.583595913455843*^9}, 3.583630750063809*^9}]
}, Open  ]]
},
WindowSize->{1440, 852},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 7023, 206, 334, "Input"],
Cell[7583, 228, 407, 10, 39, "Input"],
Cell[7993, 240, 3514, 61, 178, "Input"],
Cell[CellGroupData[{
Cell[11532, 305, 8443, 239, 573, "Input"],
Cell[19978, 546, 484, 10, 20, "Print"]
}, Open  ]],
Cell[20477, 559, 5808, 98, 147, "Input"],
Cell[26288, 659, 2087, 50, 163, "Input"],
Cell[CellGroupData[{
Cell[28400, 713, 15705, 373, 1057, "Input"],
Cell[CellGroupData[{
Cell[44130, 1090, 599, 9, 20, "Print"],
Cell[44732, 1101, 599, 9, 20, "Print"],
Cell[45334, 1112, 597, 9, 20, "Print"],
Cell[45934, 1123, 597, 9, 20, "Print"],
Cell[46534, 1134, 597, 9, 20, "Print"],
Cell[47134, 1145, 599, 9, 20, "Print"],
Cell[47736, 1156, 599, 9, 20, "Print"],
Cell[48338, 1167, 597, 9, 20, "Print"],
Cell[48938, 1178, 597, 9, 20, "Print"],
Cell[49538, 1189, 597, 9, 20, "Print"],
Cell[50138, 1200, 597, 9, 20, "Print"],
Cell[50738, 1211, 597, 9, 20, "Print"],
Cell[51338, 1222, 597, 9, 20, "Print"],
Cell[51938, 1233, 597, 9, 20, "Print"]
}, Open  ]],
Cell[52550, 1245, 687, 13, 40, "Message"],
Cell[CellGroupData[{
Cell[53262, 1262, 599, 9, 20, "Print"],
Cell[53864, 1273, 597, 9, 20, "Print"],
Cell[54464, 1284, 597, 9, 20, "Print"],
Cell[55064, 1295, 597, 9, 20, "Print"],
Cell[55664, 1306, 599, 9, 20, "Print"],
Cell[56266, 1317, 599, 9, 20, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[56914, 1332, 4300, 112, 178, "Input"],
Cell[61217, 1446, 758, 19, 461, "Output"],
Cell[61978, 1467, 402, 8, 20, "Print"],
Cell[62383, 1477, 765, 19, 463, "Output"],
Cell[63151, 1498, 401, 8, 20, "Print"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
