*************************************************************************************************************************
* Replication file for:
* Reis, Ricardo (forthcoming) "The Portuguese Slump and Crash and the Euro Crisis" Brookings Papers on Economic Activity.
* Created: 22 July 2013
* Authors: Stephane Dupraz and Ricardo Reis
*************************************************************************************************************************

clear all
set memory 1g
set more off
// cd "C:\..." complete path directory

* AMECO
clear all
insheet using AMECO.txt
drop if v1==""
drop v25-v27
rename v1 geo
rename v2 unit
drop if geo=="Country"	
gen variable = geo if unit==""
replace variable = variable[_n-1] if missing(variable)
drop if unit=="" 
forvalues i = 3(1)24 {
	local date = 2015-`i'
	rename v`i' y`date'
	destring y`date', replace ignore(NA)
	replace y`date' = y`date'*10^9 if word(unit,1)=="Mrd"|word(unit,1)=="(Mrd"
    replace y`date' = y`date'*10^3 if word(unit,1)=="1000"
	}
drop unit
replace geo="EU27" if geo=="European Union (27 countries)"
replace geo="EU15" if geo=="European Union (15 countries)"
replace geo="euro17" if geo=="Euro area (17 countries)"
replace geo="euro12" if geo=="Euro area (12 countries)"
replace geo="EU15" if geo==" Germany) " & geo[_n+1]==" Germany) "              // "EU15 (including DEL "linked" Germany)"
replace geo="euro12" if geo==" Germany) " 				    				   // "EA12 (including DEL "linked" Germany)"
replace geo="UK" if geo=="United Kingdom"
format geo %10s
gen stat="NominalGVATotal" if variable=="Gross Value Added at current prices: total of branches  (UVG0)"
replace stat="NominalGVAAgriculture" if variable=="Gross Value Added at current prices: agriculture, forestry and fishery products  (UVG1)"
replace stat="NominalGVAIndustry" if variable=="Gross value added at current prices: industry excluding building and construction  (UVG2)"
replace stat="NominalGVAConstruction" if variable=="Gross value added at current prices: building and construction  (UVG4)"
replace stat="NominalGVAServices" if variable=="Gross value added at current prices: services  (UVG5)"
replace stat="NominalGVAManufacturing" if variable=="Gross value added at current prices: manufacturing industry  (UVGM)"

replace stat="RealGVATotal" if variable=="Gross value added at 2005 prices: total of branches  (OVG0)"
replace stat="RealGVAAgriculture" if variable=="Gross value added at 2005 prices: agriculture, forestry and fishery products  (OVG1)"
replace stat="RealGVAIndustry" if variable=="Gross value added at 2005 prices: industry excluding building and construction  (OVG2)"
replace stat="RealGVAConstruction" if variable=="Gross value added at 2005 prices: building and construction  (OVG4)"
replace stat="RealGVAServices" if variable=="Gross value added at 2005 prices: services  (OVG5)"
replace stat="RealGVAManufacturing" if variable=="Gross value added at 2005 prices: manufacturing industry  (OVGM)"

replace stat="CompensationAgriculture" if variable=="Compensation of employees: agriculture, forestry and fishery products  (UWC1)"
replace stat="CompensationIndustry" if variable=="Compensation of employees: industry excluding building and construction  (UWC2)"
replace stat="CompensationConstruction" if variable=="Compensation of employees: building and construction  (UWC4)"
replace stat="CompensationServices" if variable=="Compensation of employees: services  (UWC5)"
replace stat="CompensationManufacturing" if variable=="Compensation of employees: manufacturing industry  (UWCM)"
replace stat="RealCompensationTotal" if variable=="Real compensation per employee, deflator GDP: total economy  (RWCDV)"

replace stat="EmploymentAgriculture" if variable=="Employment, persons: agriculture, forestry and fishery products (National accounts)  (NET1)"
replace stat="EmploymentIndustry" if variable=="Employment, persons: industry excluding building and construction (National accounts)  (NET2)"
replace stat="EmploymentConstruction" if variable=="Employment, persons: building and construction (National accounts)  (NET4)"
replace stat="EmploymentServices" if variable=="Employment, persons: services (National accounts)  (NET5)"
replace stat="EmploymentManufacturing" if variable=="Employment, persons: manufacturing industry (National accounts)  (NETM)"
replace stat="EmploymentTotal" if variable=="Employment, persons: total economy (National accounts)  (NETN)"

replace stat="DeflatorAgriculture" if variable=="Price deflator gross value added: agriculture, forestry and fishery products  (PVG1)"
replace stat="DeflatorIndustry" if variable=="Price deflator gross value added: industry excluding building and construction  (PVG2)"
replace stat="DeflatorConstruction" if variable=="Price deflator gross value added: building and construction  (PVG4)"
replace stat="DeflatorServices" if variable=="Price deflator gross value added: services  (PVG5)"
replace stat="DeflatorManufacturing" if variable=="Price deflator gross value added: manufacturing industry  (PVGM)"

replace stat="NominalLaborCostManufacturing" if variable=="Nominal unit labour costs: manufacturing industry  (PLCM)"
replace stat="RealLaborCostManufacturing" if variable=="Real unit labour costs: manufacturing industry  (QLCM)"
replace stat="NominalLaborCost" if variable=="Nominal unit labour costs: total economy (Ratio of compensation per employee to real GDP per person employed.)  (PLCD)"
replace stat="RealLaborCost" if variable=="Real unit labour costs: total economy (Ratio of compensation per employee to nominal GDP per person employed.)  (QLCD)"
replace stat="LaborIncomeShare" if variable=="Adjusted wage share: total economy: as percentage of GDP at current market prices (Compensation per employee as percentage of GDP at market prices per person employed.)  (ALCD0)"
replace stat="ShareWorldExports" if variable=="Share of exports of goods in world exports including intra EU exports :- Foreign trade statistics  (AXGT)"
replace stat="ShareWorldTrade" if variable=="Average share of imports and exports of goods in world trade including intra EU trade :- Foreign trade statistics  (AAGT)"
replace stat="TOT" if variable=="Terms of trade goods and services (National accounts)  (APGS)"
replace stat="TFP" if variable=="Total factor productivity: total economy  (ZVGDF)"
replace stat="NominalGDPCapita" if variable=="Gross domestic product at current market prices per head of population  (HVGDP)"
replace stat="RealGDP" if variable=="Gross domestic product at 2005 market prices  (OVGD)"
replace stat="RealGDPCapita" if variable=="Gross domestic product at 2005 market prices per head of population  (RVGDP)"
replace stat="NominalGDP" if variable=="Gross domestic product at current market prices  (UVGD)"
replace stat="NominalGovernementInvestment" if variable=="Gross fixed capital formation at current prices: general government  (UIGG)"
replace stat="NominalPrivateInvestment" if variable=="Gross fixed capital formation at current prices: private sector  (UIGP)"
replace stat="NominalInvestment" if variable=="Gross fixed capital formation at current prices: total economy  (UIGT)"
replace stat="NominalGovernmentConsumption" if variable=="Final consumption expenditure of general government at current prices  (UCTG)"
replace stat="NominalPrivateConsumptionCapita" if variable=="Private final consumption expenditure at current prices per head of population  (HCPHP)"
replace stat="DeflatorPrivateConsumption" if variable=="Price deflator private final consumption expenditure  (PCPH)"
replace stat="UnemploymentRate" if variable=="Unemployment rate: total :- Member States: definition EUROSTAT  (ZUTN)"
replace stat="Imports" if variable=="Imports of goods and services at current prices (National accounts)  (UMGS)"
replace stat="Exports" if variable=="Exports of goods and services at current prices (National accounts)  (UXGS)"
replace stat="ExtraEUImports" if variable=="Extra EU imports of goods :- Foreign trade statistics (1960-1998 Former EU-15)  (DMGE)"
replace stat="ExtraEUExports" if variable=="Extra EU exports of goods :- Foreign trade statistics (1960-1998 Former EU-15)  (DXGE)"
replace stat="NominalGrossIncome" if variable=="Gross national income at current market prices  (UVGN)"
replace stat="NominalGrossDisposableIncome" if variable=="Gross national disposable income  (UVGT)"
replace stat="NominalIncome" if variable=="National income at current market prices  (UVNN)"
replace stat="NominalDisposableIncome" if variable=="National disposable income  (UVNT)"
order stat geo
gen source="AMECO"
save "data.dta", replace

* OECD Aggregates
clear all
insheet using OECDAggregates.txt
drop v2
drop if v1==""|v1=="Frequency"
gen variable=v3 if v1=="Variable"
replace variable = variable[_n-1] if missing(variable)
drop if v1=="Variable"
forvalues i = 3(1)26 {
	local date = `i'+1988
	rename v`i' y`date'
	replace y`date'=":" if y`date'==".."  			// ".." makes stata remove decimal comma
	destring y`date', replace ignore(:)
	}
drop if v1=="Country"
rename v1 geo
drop if geo=="Time"
drop if geo=="Country"
replace geo="euro15" if geo=="Euro area (15 countries)"
replace geo="UK" if geo=="United Kingdom"
format geo %10s
gen stat="CAinGDP" if variable=="CBGDPR: Current account balance, as a percentage of GDP"
replace stat="CompetitivenessCPI" if variable=="CPIDR: Competitiveness indicator, relative consumer prices (CPI), overall weights"
replace stat="NEER" if variable=="EXCHEB: Nominal effective exchange rate, chain-linked, overall weights"
replace stat="CompetitivenessWages" if variable=="ULCDR: Competitiveness indicator, relative unit labour costs, overall economy"
replace stat="PublicDebtinGDP" if variable=="GGFLMQ: Gross public debt, Maastricht criterion, as a percentage of GDP"
replace stat="GovernmentDisbursementsinGDP" if variable=="YPGTQ: Total disbursements, general government, as a percentage of GDP"
replace stat="GovernmentReceiptsinGDP" if variable=="YRGTQ: Total receipts general government, as a percentage of GDP"
replace stat="RealGovernementConsumption" if variable=="CGV: Government final consumption expenditure, volume"
replace stat="RealPrivateConsumption" if variable=="CPV: Private final consumption expenditure, volume"
replace stat="NominalGDP" if variable=="GDP: Gross domestic product, value, market prices"
replace stat="RealGDP" if variable=="GDPV: Gross domestic product, volume, market prices"
replace stat="RealGrossInvestmentHousing" if variable=="IHV: Gross fixed capital formation, housing, volume"
replace stat="RealGrossInvestment" if variable=="ITV: Gross fixed capital formation, total, volume"
replace stat="CPI" if variable=="CPIH: Consumer price index, harmonised"
replace stat="DeflatorPrivateConsumption" if variable=="PCP: Private final consumption expenditure, deflator"
replace stat="DeflatorGDP" if variable=="PGDP: Gross domestic product, deflator, market prices"
replace stat="Employment" if variable=="ET: Total employment"
drop if stat=="Employment" 		// see Employment Protection data a better series
replace stat="LaborForce" if variable=="LF: Labour force"
replace stat="LaborProductivity" if variable=="PDTY: Labour productivity of the total economy"
replace stat="LaborCost" if variable=="ULC: Unit labour cost in total economy"
replace stat="UnemploymentRate" if variable=="UNR: Unemployment rate"
replace stat="CompensationRate" if variable=="WSST: Compensation rate, total economy"
replace stat="IRL" if variable=="IRL: Long-term interest rate on government bonds"
replace stat="ERLocalperDollar" if variable=="EXCHUD: Exchange rate, National currency per USD"
replace stat="NominalCAinDollars" if variable=="CBD: Current account balance, value in USD"
replace stat="NominalTBinDollars" if variable=="FBGSD: Net exports of goods and services, value, National Accounts basis, USD"
order stat geo
gen source="OECD"
append using data.dta
format geo %10s
save data.dta, replace

* OECD Protection
clear all
insheet using OECDProtection.txt
drop v14-v22
rename v1 geo
replace geo = geo[_n-1] if missing(geo) & v2!=""
replace geo = "EU21" if geo == "European Union 21" 
replace geo = "OECD" if geo == "OECD countries"
replace geo = geo + " " + v4[_n+2] if geo[_n+2]=="Age"
drop if geo=="Series"|geo=="Time"|geo=="Country"|geo=="Sex"|geo=="Frequency"|geo=="Employment status"|geo=="Age"|geo==""
drop if regexm(geo, "^data ")
gen variable=geo if missing(v2) & missing(v3)
replace variable =variable[_n-1] if missing(variable)
replace variable =variable + v2 if v2 !=""
drop if missing(v2) & missing(v3)
drop v2
forvalues i = 3(1)5 {
	replace v`i'=":" if v`i'==".." 			// destring removes decimal comma if ignore(..)
	destring v`i', replace ignore(":")
	}
forvalues i= 13(1)13 {
	replace v`i'=":" if v`i'==".." 			// destring removes decimal comma if ignore(..)
	destring v`i', replace ignore(":")
	}
forvalues i = 3(1)13 {
	local date = `i'+1996
	rename v`i' y`date'
	replace y`date' = y`date'*10^3 if word(variable,2)=="Employment"
	}
gen stat="ProtectionOverall" if variable=="Dataset: Strictness of employment protection  overall"
replace stat="ProtectionRegular" if variable=="Dataset: Strictness of employment protection  regular employment"
replace stat="ProtectionTemporary" if variable=="Dataset: Strictness of employment protection  temporary employment"
replace stat="ProtectionCollectiveDismissal" if variable=="Dataset: Strictness of employment protection  collective dismissals"

replace stat="EmploymentPermanent" if variable=="Dataset: Employment by permanency of the job TotalPermanent employment"
replace stat="EmploymentTemporary" if variable=="Dataset: Employment by permanency of the job TotalTemporary employment"
replace stat="Employment" if variable=="Dataset: Employment by permanency of the job TotalTotal declared"

replace stat="EmploymentYoungPermanent" if variable=="Dataset: Employment by permanency of the job 15 to 24Permanent employment"
replace stat="EmploymentYoungTemporary" if variable=="Dataset: Employment by permanency of the job 15 to 24Temporary employment"
replace stat="EmploymentYoung" if variable=="Dataset: Employment by permanency of the job 15 to 24Total declared"

order stat geo
sort stat geo
format geo %10s
gen source="OECD"
append using data.dta
format geo %10s
save data.dta, replace

* OECD Retirement
clear all
insheet using OECDRetirement.txt
drop if missing(v1)
gen variable = v1 if word(v1,1)=="Average"
replace variable=variable[_n-1] if missing(variable)
drop if word(v1,1)=="Average"
drop v2-v22
rename v1 geo 
forvalues i = 23(1)43 {
	local date = `i'+1968
	rename v`i' y`date'
	replace y`date'=":" if y`date'==".."  			// ".." makes stata remove decimal comma
	destring y`date', replace ignore(:)
	}
keep if geo=="Portugal"|geo=="Spain"|geo=="Germany"|geo=="France"
format geo %10s	
gen stat="RetirementAgeMen" if variable=="Average effective age of retirement: men"
replace stat="RetirementAgeWomen" if variable=="Average effective age of retirement: women"
order stat geo
gen source="OECD"
append using data.dta
format geo %10s
save data.dta, replace

* eurostat
clear all
insheet using eurostat.txt
drop v24-v29
drop if v1=="" & v2==""
drop if v1=="Last update"|v1=="Extracted on"|v1=="Source of Data"|v1=="GEO/TIME"|v1=="Special values:"|v1=="0"|v1==":"|v1=="SEX"	
replace v2 = v2 + " " + v2[_n-1] if v20=="" & v20[_n-1]==""
gen variable = v2 if v20=="" & v20[_n+1]!=""
replace variable = variable[_n-1] if variable==""
rename v1 geo
drop if geo =="AGE"|geo =="COFOG99"|geo =="INDIC_NA"|geo =="SECTOR"|geo =="SPDEPB"|geo =="SPDEPM"|geo=="UNIT"|geo==""
forvalues i = 2(1)23 {
	local date = `i'+1989
	rename v`i' y`date'
	destring y`date', replace ignore(":")
	}
replace geo="EU27" if geo=="European Union (27 countries)"
replace geo="EU15" if geo=="European Union (15 countries)"
replace geo="EU25" if geo=="European Union (25 countries)"
replace geo="euro17" if geo=="Euro area (17 countries)"
replace geo="euro16" if geo=="Euro area (16 countries)"
replace geo="euro15" if geo=="Euro area (15 countries)"
replace geo="euro12" if geo=="Euro area (12 countries)"
replace geo="euroevol" if geo=="Euro area (EA11-2000, EA12-2006, EA13-2007, EA15-2008, EA16-2010, EA17)"
replace geo="Germany" if geo=="Germany (including  former GDR from 1991)"            
format geo %10s
gen stat="GinGDP" if variable=="Total general government expenditure Total General government Percentage of GDP "
replace stat="GinGDPGeneral" if variable=="Total general government expenditure General public services General government Percentage of GDP"
replace stat="GinGDPDefence" if variable=="Total general government expenditure Defence General government Percentage of GDP"
replace stat="GinGDPOrderSafety" if variable=="Total general government expenditure Public order and safety General government Percentage of GDP"
replace stat="GinGDPEconomicAffairs" if variable=="Total general government expenditure Economic affairs General government Percentage of GDP"
replace stat="GinGDPEnvironment" if variable=="Total general government expenditure Environment protection General government Percentage of GDP"
replace stat="GinGDPCommunityAmenities" if variable=="Total general government expenditure Housing and community amenities General government Percentage of GDP"
replace stat="GinGDPHealth" if variable=="Total general government expenditure Health General government Percentage of GDP"
replace stat="GinGDPCulture" if variable=="Total general government expenditure Recreation, culture and religion General government Percentage of GDP"
replace stat="GinGDPEducation" if variable=="Total general government expenditure Education General government Percentage of GDP"
replace stat="GinGDPSPTotal" if variable=="Total general government expenditure Social protection General government Percentage of GDP"
replace stat="GinGDPSPSickness" if variable=="Total general government expenditure Sickness and disability General government Percentage of GDP"
replace stat="GinGDPSPOldAge" if variable=="Total general government expenditure Old age General government Percentage of GDP"
replace stat="GinGDPSPSurvivors" if variable=="Total general government expenditure Survivors General government Percentage of GDP"
replace stat="GinGDPSPFamily" if variable=="Total general government expenditure Family and children General government Percentage of GDP"
replace stat="GinGDPSPUnemployment" if variable=="Total general government expenditure Unemployment General government Percentage of GDP"
replace stat="GinGDPSPHousing" if variable=="Total general government expenditure Housing General government Percentage of GDP"
replace stat="GinGDPSPExclusion" if variable=="Total general government expenditure Social exclusion n.e.c. General government Percentage of GDP"
replace stat="GinGDPSPRD" if variable=="Total general government expenditure R&D Social protection General government Percentage of GDP"
replace stat="GinGDPSPOthers" if variable=="Total general government expenditure Social protection n.e.c. General government Percentage of GDP"
replace stat="Pop" if variable=="Total Population on 1 January by broad age group and sex [demo_pjanbroad]"
replace stat="Pop65plus" if variable=="65 years or over Population on 1 January by broad age group and sex [demo_pjanbroad]"
replace stat="PopPension" if variable=="Total Total Persons Pensions beneficiaries at 31st December [spr_pns_ben]"
replace stat="PopOldAgePension" if variable=="Old age pension Total Persons Pensions beneficiaries at 31st December [spr_pns_ben] "
replace stat="PopOldAgeAnticipatedPension" if variable=="Anticipated old age pension Total Persons Pensions beneficiaries at 31st December [spr_pns_ben] "
replace stat="PopOldAgePensionMeansTest" if variable=="Old age pension Means-tested Persons Pensions beneficiaries at 31st December [spr_pns_ben] "
gen source="eurostat"
order stat geo	
append using data.dta
format geo %10s
save data.dta, replace

* KLEMS
clear all
insheet using KLEMS.txt
tab v1 v2 if v2==" "
keep if inlist(v4,"TOT","D","F","K","LtQ","G")
forvalues i = 5(1)42 {
	local date = `i'+1965
	rename v`i' y`date'
	destring y`date', replace ignore()
	}
rename v1 geo
replace geo="euro12" if geo=="euro"
replace v3="Total" if v3=="TOTAL INDUSTRIES"
replace v3="Manufacturing" if v3=="TOTAL MANUFACTURING"
replace v3="Construction" if v3=="CONSTRUCTION"
replace v3="Retail" if v3=="WHOLESALE AND RETAIL TRADE"
replace v3="RealEstate" if v3=="REAL ESTATE, RENTING AND BUSINESS ACTIVITIES" |v3=="  REAL ESTATE, RENTING AND BUSINESS ACTIVITIES"
replace v3="CommunityServices" if v3=="COMMUNITY SOCIAL AND PERSONAL SERVICES"
gen stat=v2+v3
drop v2 v3 v4
order stat geo
append using data.dta
format geo %10s
save data.dta, replace

* European Commission
clear all
insheet using Commission.txt
gen variable=v1 if word(v1,1)=="Table"
replace variable=variable[_n-1] if missing(variable)
drop v2-v6
drop v23-v28
drop if missing(v1)
forvalues i = 7(1)22 {
	local date = `i'+1988
	rename v`i' y`date'
	destring y`date', replace ignore(:)
	}
rename v1 geo
replace geo="euro17" if geo[_n-1]=="EA-17 averages"
keep if inlist(geo,"DE","ES","FR","PT","euro17")
replace geo="Germany" if geo=="DE"
replace geo="Spain" if geo=="ES"
replace geo="France" if geo=="FR"
replace geo="Portugal" if geo=="PT"
format geo %10s
gen stat="TaxesinGDP" if variable=="Table Tot_G: Total Taxes (including SSC) as % of GDP"
replace stat="TaxesComsumptioninGDP" if variable=="Table C.1_G: Taxes on Consumption as % of GDP - Total"
replace stat="TaxesLaborinGDP" if variable=="Table C.2_G: Taxes on Labour as % of GDP - Total"
replace stat="TaxesCapitalinGDP" if variable=="Table C.3_G: Taxes on Capital as % of GDP - Total"
order stat geo
gen source="KLEMS"
append using data.dta
format geo %10s
save data.dta, replace

* Johnson
clear all
insheet using Johnson.txt
gen geo="Portugal"
rename v1 variable
drop if variable==""
forvalues i = 2(1)16 {
	local date = `i'+1993
	rename v`i' y`date'
	replace y`date' = y`date'*100
	}
gen stat="REERJohnsonCPI" if variable=="CPI conventional REER"
replace stat="REERJohnsonVA" if variable=="Vadded RER"
replace stat="REERJOhnsonCPIIMF" if variable=="IMF CPI-based"
gen source="Johnson"
order stat geo
append using data.dta
format geo %10s
drop variable
drop if stat=="NominalGDP" & source=="OECD" | stat=="RealGDP" & source=="OECD"| stat=="UnemploymentRate" & source=="OECD"| stat=="DeflatorPrivateConsumption" & source=="OECD"   // Double Sources
drop source

* Reshape
reshape long y, i(geo stat) j(time)
reshape wide y, i(geo time) j(stat) string
renpfix y
sort geo time
save data.dta, replace

* Lane
clear all
insheet using Lane.txt
drop if country!="Portugal"
drop ifscode v27
foreach variable of varlist * {
		destring `variable', replace
			}
rename year time
rename country geo
rename portfolioequityassets EquityAssetsinDollars
rename portfolioequityliabilities EquityLiabilitiesinDollars
rename fdiassets FDIAssetsinDollars
rename fdiliabilities FDILiabilitiesinDollars
rename debtassetsportfoliodebtotherinve DebtAssetsinDollars
rename debtliabilitiesportfoliodebtothe DebtLiabilitiesinDollars
rename financialderivativesassets DerivativesAssetsinDollars
rename financialderivativesliabilities DerivativesLiabilitiesinDollars
rename fxreservesminusgold FXReservesinDollars
rename totalassets AssetsinDollars
rename totalliabilities LiabilitiesinDollars
rename netforeignassetsnfa NFAinDollars
rename netiipasofficiallyreported NetIIPinDollars
rename nfaalternativefdivaluation NFAotherFDIvalinDollars
rename gdpus NominalGDPinDollarsinDollars
rename portfoliodebtassets PortDebtAssetsinDollars
rename portfoliodebtliabilities PortDebtLiabilitiesinDollars
rename otherinvestmentassets OthersAssetsinDollars
rename otherinvestmentliabilities OthersLiabilitiesinDollars
rename fdiassetsothervaluation FDIothervalAssetsinDollars
rename fdiliabilitiesothervaluation FDIothervalLiabilitiesinDollars
drop exchangeratevisvisusdollarperiod  		// apparenty in escudos until 2007
drop exchangeratevisvisusdollarendofp   	// id
foreach variable of varlist EquityAssets-FDIothervalLiabilities {
	replace `variable' = `variable'*10^6 
	}
drop if time < 1991  						// Restrict to main time range
sort geo time
merge 1:1 geo time using data.dta, nogenerate
format geo %10s
save data.dta, replace

* Pordata
clear all
insheet using Pordata.txt
drop v12-v19
gen geo="Portugal"
rename v1 time
rename v2 PensionersinLaborForce
rename v3 PensionersSSinLaborForce
rename v4 PensionersCSRFinLaborForce
rename v5 PensionersinPop15plus
rename v6 RetirementAgeOldness
rename v7 RetirementAgeOldnessMen
rename v8 RetirementAgeOldnessWomen
rename v9 RetirementAgeDisablement
rename v10 RetirementAgeDisablementMen
rename v11 RetirementAgeDisablementWomen
drop if missing(time)|time=="Tempo"
foreach variable of varlist * {
		replace `variable'=word(`variable',2) if word(`variable',1)=="T"
		destring `variable', replace ignore(x)
			}
sort geo time
order geo time
merge 1:1 geo time using data.dta, nogenerate
format geo %10s
save data.dta, replace
