*************************************************************************************************************************
* Replication file for:
* Reis, Ricardo (forthcoming) "The Portuguese Slump and Crash and the Euro Crisis" Brookings Papers on Economic Activity.
* Created: 22 July 2013
* Authors: Stephane Dupraz and Ricardo Reis
*************************************************************************************************************************

clear all
set more off
set memory 1g
//cd "C:\..." complete path directory
use data.dta

* Generate additional variables
* Table 1
gen RealPrivateConsumptionCapita = NominalPrivateConsumption/DeflatorPrivateConsumption*100
* Table 2		 	
gen ExtraEUTB= ExtraEUExports-ExtraEUImports
gen OpennessRatio=(Imports+Exports)/NominalGDP*100
gen NFAinEuros = NFAinDollars*ERLocalperDollar
* Table3
replace VA_PTotal=VATotal/VA_QITotal if VA_QITotal!=.
replace VA_PCommunityServices=VACommunityServices/VA_QICommunityServices if VA_QICommunityServices!=. 
replace VA_PConstruction=VAConstruction/VA_QIConstruction if VA_QIConstruction!=.
replace VA_PManufacturing=VAManufacturing/VA_QIManufacturing if VA_QIManufacturing!=.
replace VA_PRealEstate=VARealEstate/VA_QIRealEstate if VA_QIRealEstate!=.
replace VA_PRetail=VARetail/VA_QIRetail if VA_QIRetail!=.
drop VA_QITotal VA_QICommunityServices VA_QIConstruction VA_QIManufacturing VA_QIRealEstate VA_QIRetail
label define orderrelative 1 Portugal 2 euro15 3 Spain 4 Germany 5 France
encode geo, gen(relative) label(orderrelative)
sort time relative
gen CPIrelEuro = CPI/CPI[_n+1] if relative==1
gen CPIrelSpain = CPI/CPI[_n+2] if relative==1
gen CPIrelGermany = CPI/CPI[_n+3]  if relative==1
gen CPIrelFrance = CPI/CPI[_n+4] if relative==1
drop relative
* Table 4
gen ShareGVAManufacturing=NominalGVAManufacturing/NominalGVATotal*100
gen ShareEmploymentManufacturing=EmploymentManufacturing/EmploymentTotal*100
gen ShareVAManufacting=VAManufacturing/VATotal*100
gen ShareVAConstruction=VAConstruction/VATotal*100
gen ShareVARealEstate=VARealEstate/VATotal*100
gen ShareVACommunityServices=VACommunityServices/VATotal*100
gen ShareVARetail=VARetail/VATotal*100
gen ShareEMPManufacting=EMPManufacturing/EMPTotal*100
gen ShareEMPConstruction=EMPConstruction/EMPTotal*100
gen ShareEMPRealEstate=EMPRealEstate/EMPTotal*100
gen ShareEMPCommunityServices=EMPCommunityServices/EMPTotal*100
gen ShareEMPRetail=EMPRetail/EMPTotal*100
* Table 5
gen Markup = -log(LaborIncomeShare)*100
gen MarkupTotal = -log(LABTotal/VATotal)*100
gen MarkupManufacturing = -log(LABManufacturing/VAManufacturing)*100
gen MarkupConstruction = -log(LABConstruction/VAConstruction)*100
gen MarkupRealEstate = -log(LABRealEstate/VARealEstate)*100
gen MarkupCommunityServices = -log(LABCommunityServices/VACommunityServices)*100
gen MarkupRetail = -log(LABRetail/VARetail)*100
* Table 6
gen GovernmentPurchasesinGDP= (NominalGovernmentConsumption+NominalGovernementInvestment)/NominalGDP*100
gen SharePop65plus= Pop65plus/Pop*100
gen RetirementAge = 0.5*(RetirementAgeMen+RetirementAgeWomen)
* Figures of section 2.8
gen ShareEmploymentTemporary=EmploymentTemporary/Employment*100
gen ShareEmploymentYoungTemporary=EmploymentYoungTemporary/EmploymentYoung*100
* Calibration PHI
gen PHI=-NominalCA/NominalInvestment

* Generate alon geo and time dimensions
foreach x of var * {
	rename `x' y`x' 
} 
rename ygeo geo
rename ytime time
reshape long y, i(time geo) j(stat) string
* time
reshape wide y, i(geo stat) j(time)
gen yChange07= y2007-y2000
gen yChange06= y2006-y2000
gen yAnnualChange07=yChange07/7
gen yAnnualChange06=yChange06/6
gen yPercentageGrowth07=(y2007/y2000-1)*100
gen yPercentageGrowth06=(y2006/y2000-1)*100
gen yPercentageGrowth05=(y2005/y2000-1)*100
gen yPercentageAnnualGrowth07=((y2007/y2000)^(1/7)-1)*100
gen yPercentageAnnualGrowth06=((y2006/y2000)^(1/6)-1)*100
gen yPercentageAnnualGrowth05=((y2005/y2000)^(1/5)-1)*100
gen yCumulative07=y2001+y2002+y2003+y2004+y2005+y2006+y2007
reshape long y, i(geo stat) j(time) string
* geo
reshape wide y, i(time stat) j(geo) string
gen yeuro = yeuro12 										// by default, eurozone = 12; if missing, closest to 12
replace yeuro = yeuro15 if missing(yeuro)
replace yeuro = yeuro16 if missing(yeuro)
replace yeuro = yeuro17 if missing(yeuro)
replace yeuro = yeuroevol if missing(yeuro)
replace yeuro = yeuro8 if missing(yeuro)
gen yPartners = 0.5*ySpain+0.3*yGermany+0.2*yFrance
reshape long y, i(time stat) j(geo) string
* end
reshape wide y, i(time geo) j(stat) string
renpfix y
sort geo time

* Generate for relative prices relative Partners  (table 3); this creates averages of growth rates, not growth rate of averages
gen CPIrelPartners = 0.5*CPIrelSpain + 0.3*CPIrelGermany + 0.2*CPIrelFrance
label define auxorder 1 Portugal 2 euro15 3 Spain 4 Germany 5 France 6 euro12
encode geo, gen(relative) label(auxorder)
sort time relative
gen TOTrelEuro = DeflatorManufacturing - DeflatorManufacturing[_n+5] if relative==1
gen TOTrelPartners = DeflatorManufacturing - 0.5*DeflatorManufacturing[_n+2]- 0.3*DeflatorManufacturing[_n+3]- 0.2*DeflatorManufacturing[_n+4]
gen VA_PTotalrelEuro = VA_PTotal - VA_PTotal[_n+5] if relative==1
gen VA_PTotalrelPartners = VA_PTotal - 0.5*VA_PTotal[_n+2] - 0.3*VA_PTotal[_n+3] - 0.2*VA_PTotal[_n+4]
gen VA_PManufacturingrelEuro = VA_PManufacturing - VA_PManufacturing[_n+5] if relative==1
gen VA_PManufacturingrelPartners = VA_PManufacturing - 0.5*VA_PManufacturing[_n+2] - 0.3*VA_PManufacturing[_n+3] - 0.2*VA_PManufacturing[_n+4]
drop relative
gen ResCompetitivenessCPI=CompetitivenessCPI-TOT
gen ResTOTrelEuro = CPIrelEuro - TOTrelEuro
gen ResTOTrelPartners = CPIrelPartners-TOTrelPartners

save dataPortugal.dta, replace

clear all
use dataPortugal.dta

* Clearing and ordering for display
keep if geo=="Portugal"|geo=="Partners"|geo=="euro"|geo=="Spain"|geo=="Germany"|geo=="France"|geo=="EU21"|geo=="OECD"		// Keep only euro, which is euro12, or the the closest to it when euro12 missing
label define geoorder 1 Portugal 2 euro 3 Partners 4 Spain 5 Germany 6 France 7 EU21 8 OECD
gen aux = geo
drop geo
encode aux, gen(geo) label(geoorder)
drop aux
order geo time
sort geo time

* Table 1
preserve
keep geo time RealGDPCapita NominalGDPCapita NominalPrivateConsumptionCapita RealPrivateConsumptionCapita RealCompensationTotal UnemploymentRate IRL
keep if (time=="2007" | time=="PercentageAnnualGrowth07" | time=="Change07") & geo<=3
list geo time NominalGDPCapita NominalPrivateConsumptionCapita UnemploymentRate IRL if time=="2007" & geo==1
list geo time RealGDPCapita RealPrivateConsumptionCapita RealCompensationTotal if time=="PercentageAnnualGrowth07" 
list geo time UnemploymentRate IRL if time=="Change07"
restore

* Table 2
preserve
keep geo time NFAinDollars NFAinEuros NominalCAinDollars NominalTBinDollars ExtraEUTB NominalGDP NominalGDPinDollars OpennessRatio
keep if geo==1
keep if time=="2007"|time=="Change07"|time=="Cumulative07"
local GDP2007=NominalGDP[1]
local GDPinDollars2007=NominalGDPinDollars[1]
gen NFAnorm=NFAinDollars/`GDPinDollars2007'*100
gen CAnorm =NominalCAinDollars/`GDPinDollars2007'*100
gen TBnorm =NominalTBinDollars/`GDPinDollars2007'*100
gen ExtraEUTBnorm =ExtraEUTB/`GDP2007'*100
list geo time NFAnorm if time=="2007"|time=="Change07"
list geo time CAnorm TBnorm ExtraEUTBnorm if time=="Cumulative07"
* text
list geo time NFAinEuros if geo==1 & time=="2007"
list geo time OpennessRatio if geo==1 & time=="2007"
restore

* Table 3
preserve
keep geo time CompetitivenessCPI NEER TOT ResCompetitivenessCPI CPIrelEuro TOTrelEuro ResTOTrelEuro CPIrelPartners TOTrelPartners ResTOTrelPartners /// 
		REERJohnsonVA VA_PTotalrelEuro VA_PTotalrelPartners VA_PManufacturingrelEuro VA_PManufacturingrelPartners
keep if (time=="PercentageGrowth07"|time=="Change07"|time=="PercentageGrowth06") & geo==1
list geo time NEER CompetitivenessCPI TOT ResCompetitivenessCPI if time=="PercentageGrowth07"
list geo time CPIrelEuro TOTrelEuro ResTOTrelEuro if time=="PercentageGrowth07" 
list geo time CPIrelPartners TOTrelPartners ResTOTrelPartners if time=="PercentageGrowth07"
list geo time REERJohnsonVA if time=="Change07"
list geo time VA_PTotalrelEuro VA_PManufacturingrelEuro  if time=="PercentageGrowth06"
list geo time VA_PTotalrelPartners VA_PManufacturingrelPartners if time=="PercentageGrowth06"
restore

* Table 4
preserve
keep geo time ShareVAManufacting ShareVAConstruction ShareVARealEstate ShareVACommunityServices ShareVARetail ShareEMPManufacting ShareEMPConstruction ShareEMPRealEstate ShareEMPCommunityServices ShareEMPRetail
keep if (time=="2000"|time=="2006"|time=="Change06") & (geo<=4)
list geo time ShareEMPManufacting ShareEMPConstruction ShareEMPRealEstate ShareEMPCommunityServices ShareEMPRetail ShareVAManufacting ShareVAConstruction ShareVARealEstate ShareVACommunityServices ShareVARetail ///
	if geo==1 & time=="2006"
list geo time ShareEMPManufacting ShareEMPConstruction ShareEMPRealEstate ShareEMPCommunityServices ShareEMPRetail ShareVAManufacting ShareVAConstruction ShareVARealEstate ShareVACommunityServices ShareVARetail ///
	if time=="Change06"
* text
list geo time ShareVAConstruction if (geo==1|geo==4) & (time=="2000"|time=="2006")
restore

* Table 5
preserve
keep geo time TFPTotal TFPManufacturing TFPConstruction TFPRealEstate TFPCommunityServices TFPRetail ///
			  MarkupTotal MarkupManufacturing MarkupConstruction MarkupRealEstate MarkupCommunityServices MarkupRetail
keep if (time=="PercentageAnnualGrowth05"|time=="AnnualChange06") & geo<=3
list geo time TFPTotal TFPManufacturing TFPConstruction TFPRealEstate TFPCommunityServices TFPRetail ///
	if time=="PercentageAnnualGrowth05"
list geo time MarkupTotal MarkupManufacturing MarkupConstruction MarkupRealEstate MarkupCommunityServices MarkupRetail ///
	if time=="AnnualChange06"
restore

* Table 6
preserve
keep geo time PublicDebtinGDP GinGDP GovernmentPurchasesinGDP GinGDPSPTotal GinGDPSPOldAge /// 
	TaxesCapitalinGDP TaxesComsumptioninGDP TaxesLaborinGDP TaxesinGDP ///
	SharePop65plus PensionersinLaborForce RetirementAge
keep if (time=="2007"|time=="Change07") & geo<=3
list geo time PublicDebtinGDP TaxesinGDP TaxesComsumptioninGDP TaxesLaborinGDP TaxesCapitalinGDP ///
	GinGDP GovernmentPurchasesinGDP GinGDPSPTotal GinGDPSPOldAge /// 
	SharePop65plus PensionersinLaborForce RetirementAge /// 
	if geo==1 & time=="2007"
list geo time PublicDebtinGDP TaxesinGDP TaxesComsumptioninGDP TaxesLaborinGDP TaxesCapitalinGDP /// 
	GinGDP GovernmentPurchasesinGDP GinGDPSPTotal GinGDPSPOldAge ///
	SharePop65plus PensionersinLaborForce RetirementAge ///
	if time=="Change07"
restore

* Figures of section 2.8
preserve
keep geo time ShareEmploymentTemporary ShareEmploymentYoungTemporary
keep if (time=="2007") & (geo==1|geo==7|geo==8)
list
restore
