(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     40243,       1029]
NotebookOptionsPosition[     39010,        985]
NotebookOutlinePosition[     39364,       1001]
CellTagsIndexPosition[     39321,        998]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 StyleBox[
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Replication", " ", 
     StyleBox["files", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox[
         StyleBox["f", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "or"}]], ":", "\[IndentingNewLine]", 
      StyleBox[
       RowBox[{
        StyleBox[
         StyleBox[
          StyleBox["R", "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "ei", 
        StyleBox[
         StyleBox[
          StyleBox[
           StyleBox[
            StyleBox[
             StyleBox["s", "Title",
              FontColor->RGBColor[1, 0, 0]], "Title",
             FontColor->RGBColor[1, 0, 0]], "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]]}]]}]}], 
    StyleBox[
     StyleBox[
      StyleBox[
       StyleBox[
        StyleBox[
         StyleBox[",", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "Title",
       FontColor->RGBColor[1, 0, 0]], "Title",
      FontColor->RGBColor[1, 0, 0]], "Title",
     FontColor->RGBColor[1, 0, 0]], 
    StyleBox[" ", "Title",
     FontColor->RGBColor[1, 0, 0]], 
    RowBox[{
     StyleBox[
      RowBox[{
       StyleBox[
        StyleBox["R", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "icardo"}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      RowBox[{
       StyleBox[
        StyleBox[
         StyleBox["(", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], 
       StyleBox[
        RowBox[{
         StyleBox[
          StyleBox[
           StyleBox[
            StyleBox["f", "Title",
             FontColor->RGBColor[1, 0, 0]], "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "orthcoming"}]], 
       StyleBox[
        StyleBox[
         StyleBox[
          StyleBox[
           StyleBox[
            StyleBox[
             StyleBox[")", "Title",
              FontColor->RGBColor[1, 0, 0]], "Title",
             FontColor->RGBColor[1, 0, 0]], "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}], 
      StyleBox[
       StyleBox[
        StyleBox[".", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "Title",
       FontColor->RGBColor[1, 0, 0]], 
      StyleBox[" ", "Title",
       FontColor->RGBColor[1, 0, 0]], 
      StyleBox[
       RowBox[{"T", 
        StyleBox[
         StyleBox[
          StyleBox[
           StyleBox["h", "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "e"}]]}], " ", "Portuguese", " ", 
     StyleBox[
      RowBox[{"S", 
       StyleBox[
        StyleBox[
         StyleBox[
          StyleBox["l", "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ump"}]], " ", "and", " ", "Crash", 
     " ", "and", " ", "the", " ", "Euro", " ", "Crisis"}], 
    StyleBox[
     StyleBox[",", "Title",
      FontColor->RGBColor[1, 0, 0]], "Title",
     FontColor->RGBColor[1, 0, 0]], 
    StyleBox[" ", "Title",
     FontColor->RGBColor[1, 0, 0]], 
    RowBox[{
     StyleBox[
      RowBox[{
       StyleBox[
        StyleBox["B", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ro", 
       StyleBox[
        StyleBox["o", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ki", 
       StyleBox[
        StyleBox["n", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "gs"}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{
       StyleBox["Pa", "Title",
        FontColor->RGBColor[1, 0, 0]], "pe", 
       StyleBox[
        StyleBox["r", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], 
       StyleBox[
        StyleBox[
         StyleBox["s", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox["on", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{
       StyleBox["Ec", "Title",
        FontColor->RGBColor[1, 0, 0]], "on", 
       StyleBox[
        StyleBox["o", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "mi", 
       StyleBox[
        StyleBox["c", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{
       StyleBox["Ac", "Title",
        FontColor->RGBColor[1, 0, 0]], "ti", 
       StyleBox[
        StyleBox["v", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "it", 
       StyleBox[
        StyleBox["y", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}]], "\[IndentingNewLine]", "by", " ", 
     "Ricardo", " ", "Reis", "\[IndentingNewLine]", 
     StyleBox[
      RowBox[{
       StyleBox[
        StyleBox[
         StyleBox["J", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ul", 
       StyleBox["y", "Title",
        FontColor->RGBColor[1, 0, 0]]}]]}], ",", " ", "2013"}], 
   "\[IndentingNewLine]", " ", "*)"}], "Title",
  FontColor->RGBColor[1, 0, 0]]], "Input",
 CellChangeTimes->{{3.5768586463353033`*^9, 3.57685866096115*^9}, {
  3.576930877732305*^9, 3.57693090213638*^9}, {3.578503629704011*^9, 
  3.578503630127324*^9}, {3.578504323070333*^9, 3.5785043682483597`*^9}, {
  3.583630582179241*^9, 3.583630609446631*^9}},
 TextAlignment->Center],

Cell[BoxData[
 StyleBox[
  RowBox[{"(*", 
   RowBox[{
   "This", " ", "file", " ", "finds", " ", "the", " ", "steady", " ", 
    "state"}], "*)"}], "Subtitle"]], "Input",
 CellChangeTimes->{{3.578504418952533*^9, 3.57850442746059*^9}},
 TextAlignment->Center],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{"Setting", " ", "parameters"}], "*)"}], "Subtitle"], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", 
    RowBox[{
    "\[Beta]", ",", "\[Alpha]", ",", "rf", ",", "\[Gamma]", ",", "\[Psi]", 
     ",", "abar", ",", "A", ",", "\[Tau]", ",", "\[Theta]", ",", "\[Phi]"}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Beta]", "=", "0.84"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rf", "=", "1.08"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Alpha]", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Gamma]", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Psi]", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"abar", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Theta]", "=", "0.25"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"\[Tau]", "=", 
    RowBox[{"1", "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "0.115"}], ")"}], "/", "1.118"}]}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Phi]", "=", "0.0001"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.576568142463111*^9, 3.576568250815782*^9}, {
   3.57656828901313*^9, 3.5765684365491657`*^9}, {3.5765684678228083`*^9, 
   3.576568475827259*^9}, {3.576568926935154*^9, 3.57656894367924*^9}, 
   3.576594851669853*^9, {3.5765962848431664`*^9, 3.576596285042989*^9}, {
   3.576596641397138*^9, 3.576596645884503*^9}, 3.57659675410345*^9, {
   3.5765970164220743`*^9, 3.57659701674228*^9}, {3.576597297101964*^9, 
   3.576597297557336*^9}, {3.576597344411269*^9, 3.576597371943157*^9}, {
   3.576597467645091*^9, 3.5765974887279997`*^9}, {3.5765975341117163`*^9, 
   3.576597562571989*^9}, {3.57659765584583*^9, 3.576597678572938*^9}, {
   3.576597718986532*^9, 3.576597726545978*^9}, {3.576604261781291*^9, 
   3.576604277391655*^9}, {3.5768452591919317`*^9, 3.5768452688646183`*^9}, {
   3.5768580122918587`*^9, 3.576858029562742*^9}, {3.5768585549965763`*^9, 
   3.576858570769487*^9}, 3.576858744360077*^9, {3.576859220674953*^9, 
   3.576859220888139*^9}, {3.576867859219014*^9, 3.576867859337244*^9}, 
   3.576868057031089*^9, {3.576930917764817*^9, 3.5769309589300337`*^9}, {
   3.576931001641756*^9, 3.576931069318158*^9}, {3.576932441246785*^9, 
   3.5769324804574842`*^9}, {3.576946156073378*^9, 3.576946157708376*^9}, {
   3.576953694234235*^9, 3.5769537145289507`*^9}, {3.576953751174453*^9, 
   3.5769537636279087`*^9}, {3.576954334582453*^9, 3.576954334687639*^9}, {
   3.577747323228088*^9, 3.577747350983404*^9}, {3.5777474399205503`*^9, 
   3.5777474718168707`*^9}, {3.577748385824712*^9, 3.577748396650079*^9}, 
   3.577748725541854*^9, {3.577748958697901*^9, 3.5777489617703867`*^9}, {
   3.577749336466115*^9, 3.577749414486216*^9}, 3.5777503368578863`*^9, {
   3.577750694259536*^9, 3.577750862707471*^9}, {3.577751221076071*^9, 
   3.5777512596612787`*^9}, {3.577751290256172*^9, 3.5777513103171587`*^9}, {
   3.57775134852606*^9, 3.577751415975402*^9}, {3.577751596888599*^9, 
   3.577751611132166*^9}, 3.577752846396555*^9, {3.5777550849332533`*^9, 
   3.577755091303933*^9}, {3.577755744575688*^9, 3.5777557451491003`*^9}, {
   3.577763946430201*^9, 3.5777639465220833`*^9}, {3.57776449158388*^9, 
   3.577764508201206*^9}, {3.578503666675148*^9, 3.578503722305316*^9}, {
   3.5785041900078382`*^9, 3.5785042183500566`*^9}, {3.5785042697792797`*^9, 
   3.578504281377235*^9}, {3.578507512059187*^9, 3.578507519513529*^9}, {
   3.578507825002359*^9, 3.5785078306221237`*^9}, {3.583587074448292*^9, 
   3.5835870901671553`*^9}, 3.583587137668283*^9, {3.583596227693034*^9, 
   3.5835962296353893`*^9}, {3.58359709363325*^9, 3.583597106922111*^9}, {
   3.58360036785462*^9, 3.583600373349001*^9}, {3.5836004405369797`*^9, 
   3.583600458461372*^9}}],

Cell[BoxData["0.20840787119856896`"], "Output",
 CellChangeTimes->{
  3.583592487045879*^9, 3.583592956262433*^9, 3.5835949347277727`*^9, 
   3.583594995957182*^9, 3.583596230685862*^9, 3.583597109397461*^9, 
   3.583600377698431*^9, {3.583600441930234*^9, 3.583600459879724*^9}, 
   3.5836306805343943`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{
    "Definining", " ", "the", " ", "equations", " ", "of", " ", "the", " ", 
     "model", " ", "as", " ", "a", " ", "a", " ", "function", " ", "of", " ", 
     "the", " ", "guess", " ", "a"}], "*)"}], "Subtitle"], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", 
    RowBox[{"w", ",", "r", ",", "p"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"w", "=", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
        "\[Alpha]", "\[Times]", 
        SuperscriptBox["A", 
         RowBox[{"1", "/", "\[Alpha]"}]]}], "rf"], ")"}], 
     FractionBox["\[Alpha]", 
      RowBox[{"1", "-", "\[Alpha]"}]]]}], "   ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"This", " ", "is", " ", "the", " ", "exogenous", " ", "wage"}], 
     ",", " ", 
     RowBox[{"from", " ", "equation", " ", "29"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r", "[", "a_", "]"}], "=", 
    RowBox[{
     RowBox[{"(", 
      FractionBox[
       RowBox[{"\[Theta]", "\[Times]", 
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Phi]"}], ")"}]}], 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}], "\[Times]", 
        "\[Beta]"}]], ")"}], "\[Times]", 
     FractionBox["abar", "a"]}]}], "  ", 
   RowBox[{"(*", 
    RowBox[{
    "This", " ", "is", " ", "equation", " ", "39", " ", "in", " ", "terms", 
     " ", "of", " ", "r"}], "*)"}], " ", "\[IndentingNewLine]", " ", 
   RowBox[{
    RowBox[{"p", "[", "a_", "]"}], "=", 
    RowBox[{
     FractionBox[
      SuperscriptBox["w", 
       RowBox[{"1", "-", "\[Alpha]"}]], "a"], "\[Times]", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        FractionBox["1", 
         RowBox[{
          FractionBox[
           RowBox[{"1", "-", 
            RowBox[{"\[Theta]", " ", "\[Phi]"}]}], 
           RowBox[{"r", "[", "a", "]"}]], "+", 
          FractionBox[
           RowBox[{"\[Theta]", " ", "\[Phi]"}], "rf"]}]], 
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
          FractionBox[
           RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
         "\[Alpha]"}]], ")"}], "\[Alpha]"], " ", 
     RowBox[{"(*", 
      RowBox[{
      "This", " ", "is", " ", "equation", " ", "40", " ", "in", " ", "terms", 
       " ", "of", " ", "pN"}], "*)"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.576568848259672*^9, 3.576568924112115*^9}, {
   3.5765689635497217`*^9, 3.576569010667634*^9}, {3.576593960663879*^9, 
   3.576593962844702*^9}, 3.576594801516539*^9, {3.5765971483308687`*^9, 
   3.576597168756711*^9}, 3.576845379735968*^9, {3.576845618110015*^9, 
   3.57684570685353*^9}, {3.57684574910823*^9, 3.5768457537743*^9}, 
   3.5768458642009907`*^9, {3.576845906347534*^9, 3.576845944895134*^9}, {
   3.5768460925105267`*^9, 3.576846092861925*^9}, {3.576846435818573*^9, 
   3.576846505355893*^9}, {3.576846536647139*^9, 3.576846578734788*^9}, 
   3.576846642096393*^9, {3.576846674427297*^9, 3.576846706915126*^9}, 
   3.576857564279457*^9, 3.5768586851800537`*^9, {3.576931103232319*^9, 
   3.576931118525176*^9}, {3.576931169410565*^9, 3.5769312767352*^9}, {
   3.5769313139086437`*^9, 3.576931339234105*^9}, {3.576931379326527*^9, 
   3.576931425708765*^9}, 3.57693161309846*^9, {3.57693248583175*^9, 
   3.576932496488472*^9}, {3.578504296163105*^9, 3.578504307432406*^9}, {
   3.578504563238595*^9, 3.578504579453232*^9}, {3.5835872935211077`*^9, 
   3.583587320224003*^9}, {3.5835874102137747`*^9, 3.583587418652483*^9}, {
   3.583587766195733*^9, 3.583587796909667*^9}, {3.583588338406481*^9, 
   3.5835883412226143`*^9}, {3.583590287066794*^9, 3.583590290090981*^9}}],

Cell[BoxData["0.40428039610636896`"], "Output",
 CellChangeTimes->{
  3.583592487091729*^9, 3.583592956304669*^9, 3.583594934782463*^9, 
   3.583594996019848*^9, 3.583596230749704*^9, 3.583597109453187*^9, 
   3.58360037775176*^9, {3.583600441985346*^9, 3.583600459931798*^9}, 
   3.583630680586301*^9}],

Cell[BoxData[
 FractionBox["0.2975967256324265`", "a"]], "Output",
 CellChangeTimes->{
  3.583592487091729*^9, 3.583592956304669*^9, 3.583594934782463*^9, 
   3.583594996019848*^9, 3.583596230749704*^9, 3.583597109453187*^9, 
   3.58360037775176*^9, {3.583600441985346*^9, 3.583600459931798*^9}, 
   3.583630680590518*^9}],

Cell[BoxData[
 FractionBox[
  RowBox[{"0.9771761832464781`", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox["1", 
      RowBox[{"0.000023148148148148147`", "\[VeryThinSpace]", "+", 
       RowBox[{"3.36016801890189`", " ", "a"}]}]], ")"}], "0.3`"]}], 
  "a"]], "Output",
 CellChangeTimes->{
  3.583592487091729*^9, 3.583592956304669*^9, 3.583594934782463*^9, 
   3.583594996019848*^9, 3.583596230749704*^9, 3.583597109453187*^9, 
   3.58360037775176*^9, {3.583600441985346*^9, 3.583600459931798*^9}, 
   3.583630680593421*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", " ", 
    RowBox[{"Solving", " ", "the", " ", "key", " ", "integral"}], " ", "*)"}],
    "Subtitle"], " ", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", 
    RowBox[{"temp1", ",", "temp2", ",", "M"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{"(*", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{
      RowBox[{"The", " ", "integral", " ", 
       RowBox[{"is", ":", " ", 
        RowBox[{"M", "[", "a_", "]"}]}]}], "=", 
      RowBox[{
       SubsuperscriptBox["\[Integral]", "a", "abar"], 
       RowBox[{
        RowBox[{"R", "[", "aa", "]"}], 
        RowBox[{"daa", "/", 
         RowBox[{"abar", ".", " ", "And"}]}], " ", "where", " ", "a", " ", 
        "is", " ", "the", " ", "a", "*", " ", "in", " ", "the", " ", 
        "test"}]}]}], ",", " ", 
     RowBox[{
      RowBox[{
      "while", " ", "aa", " ", "is", " ", "the", " ", "variable", " ", "of", 
       " ", "integration"}], ";", "\[IndentingNewLine]", "Now"}], ",", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"R", "[", 
        RowBox[{"aa_", ",", "a_"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Theta]"}], ")"}], 
           RowBox[{"xx", "[", 
            RowBox[{"aa", ",", "a"}], "]"}]}], 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]", "\[Times]", 
            RowBox[{"xx", "[", 
             RowBox[{"aa", ",", "a"}], "]"}], "\[Times]", 
            RowBox[{"(", 
             RowBox[{
              FractionBox[
               RowBox[{"1", "-", "\[Phi]"}], 
               RowBox[{"r", "[", "a", "]"}]], "+", 
              FractionBox["\[Phi]", "rf"]}], ")"}]}]}]], " ", "and", " ", 
         RowBox[{"xx", "[", 
          RowBox[{"aa_", ",", "a_"}], "]"}]}], "=", 
        RowBox[{"\[Alpha]", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
          FractionBox[
           RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{
             RowBox[{"p", "[", "a", "]"}], "\[Times]", " ", "aa"}], 
            SuperscriptBox["w", 
             RowBox[{"1", "-", "\[Alpha]"}]]], ")"}], 
          RowBox[{"1", "/", "\[Alpha]"}]]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Let", " ", 
        RowBox[{"temp1", "[", "a_", "]"}]}], " ", "=", " ", 
       RowBox[{
        RowBox[{"\[Alpha]", 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
          FractionBox[
           RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
         SuperscriptBox[
          RowBox[{"(", 
           FractionBox[
            RowBox[{"p", "[", "a", "]"}], 
            SuperscriptBox["w", 
             RowBox[{"1", "-", "\[Alpha]"}]]], ")"}], 
          RowBox[{"1", "/", "\[Alpha]"}]], "  ", "so", " ", "that", " ", 
         RowBox[{"xx", "[", 
          RowBox[{"aa_", ",", "a_"}], "]"}]}], "=", 
        RowBox[{
         RowBox[{"temp1", "[", "a", "]"}], "\[Times]", 
         SuperscriptBox["aa", 
          RowBox[{"1", "/", "\[Alpha]"}]]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Also", " ", "define", " ", 
        RowBox[{"temp2", "[", "a", "]"}]}], "=", 
       RowBox[{"\[Theta]", "\[Times]", 
        RowBox[{"temp1", "[", "a", "]"}], "\[Times]", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"1", "-", "\[Phi]"}], 
           RowBox[{"r", "[", "a", "]"}]], "+", 
          FractionBox["\[Phi]", "rf"]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{
        RowBox[{"Then", " ", "can", " ", "re"}], "-", 
        RowBox[{"write", " ", "the", " ", "problem", " ", "as", " ", 
         RowBox[{
         "calculating", ":", "\[IndentingNewLine]", "\[IndentingNewLine]", 
          RowBox[{"M", "[", "a_", "]"}]}]}]}], "=", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"temp1", "[", "a", "]"}], 
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Theta]"}], ")"}]}], "abar"], 
        RowBox[{
         SubsuperscriptBox["\[Integral]", "a", "abar"], 
         RowBox[{
          FractionBox[
           SuperscriptBox["aa", 
            RowBox[{"1", "/", "\[Alpha]"}]], 
           RowBox[{"1", "-", 
            RowBox[{
             RowBox[{"temp2", "[", "a", "]"}], "\[Times]", 
             SuperscriptBox["aa", 
              RowBox[{"1", "/", "\[Alpha]"}]]}]}]], "daa"}]}]}]}], ";"}]}], 
    "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{
     "It", " ", "is", " ", "easy", " ", "to", " ", "recognize", " ", "the", 
      " ", "solution", " ", "as", " ", 
      RowBox[{"giving", ":", "\[IndentingNewLine]", 
       RowBox[{
        SubsuperscriptBox["\[Integral]", "a", "abar"], 
        RowBox[{
         FractionBox[
          SuperscriptBox["aa", 
           RowBox[{"1", "/", "\[Alpha]"}]], 
          RowBox[{"1", "-", 
           RowBox[{"temp2", "\[Times]", 
            SuperscriptBox["aa", 
             RowBox[{"1", "/", "\[Alpha]"}]]}]}]], 
         RowBox[{"\[DifferentialD]", "aa"}]}]}]}]}], "=", 
     FractionBox[
      RowBox[{"a", "-", "abar", "-", 
       RowBox[{"a", " ", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{"1", ",", "\[Alpha]", ",", 
          RowBox[{"1", "+", "\[Alpha]"}], ",", 
          RowBox[{
           SuperscriptBox["a", 
            FractionBox["1", "\[Alpha]"]], " ", "temp2"}]}], "]"}]}], "+", 
       RowBox[{"abar", " ", 
        RowBox[{"Hypergeometric2F1", "[", 
         RowBox[{"1", ",", "\[Alpha]", ",", 
          RowBox[{"1", "+", "\[Alpha]"}], ",", 
          RowBox[{
           SuperscriptBox["abar", 
            FractionBox["1", "\[Alpha]"]], " ", "temp2"}]}], "]"}]}]}], 
      "temp2"]}], "\[IndentingNewLine]", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"temp1", "[", "a_", "]"}], " ", "=", " ", 
     RowBox[{"\[Alpha]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
       FractionBox[
        RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"p", "[", "a", "]"}], 
         SuperscriptBox["w", 
          RowBox[{"1", "-", "\[Alpha]"}]]], ")"}], 
       RowBox[{"1", "/", "\[Alpha]"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"temp2", "[", "a_", "]"}], "=", 
     RowBox[{"\[Theta]", "\[Times]", 
      RowBox[{"temp1", "[", "a", "]"}], "\[Times]", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "-", "\[Phi]"}], 
         RowBox[{"r", "[", "a", "]"}]], "+", 
        FractionBox["\[Phi]", "rf"]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"M", "[", "a_", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         RowBox[{"temp1", "[", "a", "]"}], "\[Times]", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Theta]"}], ")"}]}], "abar"], ")"}], "\[Times]", 
      FractionBox[
       RowBox[{"a", "-", "abar", "-", 
        RowBox[{"a", "\[Times]", 
         RowBox[{"Hypergeometric2F1", "[", 
          RowBox[{"1", ",", "\[Alpha]", ",", 
           RowBox[{"1", "+", "\[Alpha]"}], ",", 
           RowBox[{
            SuperscriptBox["a", 
             FractionBox["1", "\[Alpha]"]], " ", 
            RowBox[{"temp2", "[", "a", "]"}]}]}], "]"}]}], "+", 
        RowBox[{"abar", "\[Times]", 
         RowBox[{"Hypergeometric2F1", "[", 
          RowBox[{"1", ",", "\[Alpha]", ",", 
           RowBox[{"1", "+", "\[Alpha]"}], ",", 
           RowBox[{
            SuperscriptBox["abar", 
             FractionBox["1", "\[Alpha]"]], " ", 
            RowBox[{"temp2", "[", "a", "]"}]}]}], "]"}]}]}], 
       RowBox[{"temp2", "[", "a", "]"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ClearAll", "[", 
    RowBox[{"temp1", ",", "temp2"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.5768468571516657`*^9, 3.57684691041683*^9}, {
   3.5768469857904654`*^9, 3.5768469946911783`*^9}, {3.576847565881254*^9, 
   3.576847569967368*^9}, {3.576857566831423*^9, 3.5768577158696404`*^9}, {
   3.576857782565434*^9, 3.576857959920382*^9}, {3.576857991223371*^9, 
   3.576858000906186*^9}, {3.5768581059110193`*^9, 3.5768581508600893`*^9}, {
   3.57685819254263*^9, 3.576858204590559*^9}, {3.576858239299294*^9, 
   3.576858408852191*^9}, {3.576858592702072*^9, 3.576858606101223*^9}, {
   3.576858828100573*^9, 3.576859094364891*^9}, {3.576859146613373*^9, 
   3.576859192474997*^9}, 3.5768592331205*^9, 3.576931576164703*^9, {
   3.5769316228756104`*^9, 3.576931658601111*^9}, {3.576931688780582*^9, 
   3.576931880292488*^9}, {3.576932021412521*^9, 3.5769324197135897`*^9}, {
   3.576932505322534*^9, 3.5769326229928513`*^9}, {3.5769326632914057`*^9, 
   3.5769327117487583`*^9}, {3.5769327541710978`*^9, 3.576932808652616*^9}, 
   3.57693284442811*^9, {3.576932984306223*^9, 3.5769330535394497`*^9}, 
   3.576946165889996*^9, {3.5769525489622717`*^9, 3.576952549225515*^9}, 
   3.583588332342703*^9, {3.583588734204674*^9, 3.58358873789813*^9}, {
   3.583589082530775*^9, 3.58358925661087*^9}, {3.5835893175572968`*^9, 
   3.583589600018507*^9}, {3.583589692996664*^9, 3.583589742758882*^9}, {
   3.58358978343629*^9, 3.583589907207775*^9}, 3.5835929509587393`*^9, {
   3.583630653644511*^9, 3.5836306547573338`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{"Finally", ",", " ", 
     RowBox[{"verify", " ", "the", " ", "guess"}], ",", " ", 
     RowBox[{"or", " ", "better"}], ",", " ", 
     RowBox[{
     "search", " ", "for", " ", "the", " ", "a", " ", "that", " ", "makes", 
      " ", "the", " ", "last", " ", "condition", " ", "hold"}]}], "*)"}], 
   "Subtitle"], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"EQ", "[", "a_", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       FractionBox[
        RowBox[{"1", "-", "\[Theta]"}], 
        RowBox[{"\[Beta]", "\[Times]", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}]}]], ")"}], "-", 
      RowBox[{"M", "[", "a", "]"}]}]}], ";"}], "  ", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"equation", " ", "41"}], ",", " ", 
     RowBox[{"combined", " ", "with", " ", "equation", " ", "39"}]}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"EQ", "[", "j", "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0.5", ",", "abar"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"FindRoot", "[", 
    RowBox[{
     RowBox[{"Re", "[", 
      RowBox[{"EQ", "[", "j", "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"j", ",", "0.5", ",", "0", ",", "0.99999"}], "}"}]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Extract", "[", 
     RowBox[{"%", ",", 
      RowBox[{"{", "1", "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"asol", "=", 
     RowBox[{"Extract", "[", 
      RowBox[{"%", ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.576932399556925*^9, 3.5769324063493*^9}, {
   3.5769328658185387`*^9, 3.5769328864067087`*^9}, {3.576932944651577*^9, 
   3.576932945603396*^9}, {3.576946173542378*^9, 3.576946185333956*^9}, {
   3.583588322991691*^9, 3.583588367251719*^9}, 3.583589978966113*^9, {
   3.583630669887651*^9, 3.583630671229877*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.67, 0.6, 0.6], LineBox[CompressedData["
1:eJwtjwk0lAsbx9Fi1yDxSW6ytEjWKC1/ua46RNKiK1FTn0pRKkuLm60SYcK5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     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0.5, 0},
  PlotRange->{{0.5, 1}, {0., 0.8928794618070629}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{
  3.583592487352997*^9, 3.583592956462838*^9, 3.583594934942512*^9, 
   3.5835949961977882`*^9, 3.5835962308757553`*^9, 3.5835971095974913`*^9, 
   3.583600377916122*^9, {3.583600442145712*^9, 3.5836004600870934`*^9}, 
   3.583630680885688*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"j", "\[Rule]", "0.673141751128398`"}], "}"}]], "Output",
 CellChangeTimes->{
  3.583592487352997*^9, 3.583592956462838*^9, 3.583594934942512*^9, 
   3.5835949961977882`*^9, 3.5835962308757553`*^9, 3.5835971095974913`*^9, 
   3.583600377916122*^9, {3.583600442145712*^9, 3.5836004600870934`*^9}, 
   3.5836306809445467`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"The", " ", "rest", " ", "of", " ", "the", " ", "reduced"}], "-", 
     RowBox[{"form", " ", "steady"}], "-", 
     RowBox[{"state", " ", "equilibrium"}]}], "*)"}], "Subtitle"], 
  "\[IndentingNewLine]", 
  RowBox[{"w", "\[IndentingNewLine]", 
   RowBox[{"p", "[", "asol", "]"}], "\[IndentingNewLine]", 
   RowBox[{"r", "[", "asol", "]"}], "\[IndentingNewLine]", 
   RowBox[{"L", "=", 
    SuperscriptBox[
     RowBox[{"(", 
      FractionBox[
       RowBox[{"w", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Tau]"}], ")"}]}], 
       RowBox[{
        SuperscriptBox["\[Gamma]", 
         RowBox[{"-", "\[Gamma]"}]], 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Gamma]"}], ")"}], 
         RowBox[{"\[Gamma]", "-", "1"}]], 
        RowBox[{
         RowBox[{"p", "[", "asol", "]"}], "^", "\[Gamma]"}]}]], ")"}], 
     RowBox[{"1", "/", "\[Psi]"}]]}], "\[IndentingNewLine]", 
   RowBox[{"Z", "=", 
    FractionBox[
     RowBox[{"w", " ", "L"}], 
     RowBox[{"\[Beta]", "-", "1", "+", 
      FractionBox["1", 
       RowBox[{"\[Gamma]", " ", "\[Alpha]", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}]}]]}]]}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{"Y", " ", "=", " ", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{"1", "-", "\[Alpha]"}], ")"}], "\[Times]", "w", "\[Times]", 
     "L"}]}]}]}]], "Input",
 CellChangeTimes->{{3.576932959671446*^9, 3.576932970357568*^9}, {
  3.57694620471819*^9, 3.576946356305372*^9}, {3.577755695199609*^9, 
  3.577755698696042*^9}, {3.578504661131913*^9, 3.578504671899908*^9}, {
  3.5835900790777617`*^9, 3.5835900884055023`*^9}, {3.583600388164817*^9, 
  3.5836004013965797`*^9}}],

Cell[BoxData["0.40428039610636896`"], "Output",
 CellChangeTimes->{
  3.583592487413863*^9, 3.583592956526754*^9, 3.5835949349953213`*^9, 
   3.583594996263379*^9, 3.583596230926641*^9, 3.58359710966917*^9, {
   3.583600377985003*^9, 3.583600402433042*^9}, {3.583600442218943*^9, 
   3.5836004601944103`*^9}, 3.583630680987155*^9}],

Cell[BoxData["1.1363830705464946`"], "Output",
 CellChangeTimes->{
  3.583592487413863*^9, 3.583592956526754*^9, 3.5835949349953213`*^9, 
   3.583594996263379*^9, 3.583596230926641*^9, 3.58359710966917*^9, {
   3.583600377985003*^9, 3.583600402433042*^9}, {3.583600442218943*^9, 
   3.5836004601944103`*^9}, 3.5836306809894753`*^9}],

Cell[BoxData["0.44210112525862566`"], "Output",
 CellChangeTimes->{
  3.583592487413863*^9, 3.583592956526754*^9, 3.5835949349953213`*^9, 
   3.583594996263379*^9, 3.583596230926641*^9, 3.58359710966917*^9, {
   3.583600377985003*^9, 3.583600402433042*^9}, {3.583600442218943*^9, 
   3.5836004601944103`*^9}, 3.5836306809915733`*^9}],

Cell[BoxData["0.1501038309550448`"], "Output",
 CellChangeTimes->{
  3.583592487413863*^9, 3.583592956526754*^9, 3.5835949349953213`*^9, 
   3.583594996263379*^9, 3.583596230926641*^9, 3.58359710966917*^9, {
   3.583600377985003*^9, 3.583600402433042*^9}, {3.583600442218943*^9, 
   3.5836004601944103`*^9}, 3.583630680993581*^9}],

Cell[BoxData["0.009326201100903483`"], "Output",
 CellChangeTimes->{
  3.583592487413863*^9, 3.583592956526754*^9, 3.5835949349953213`*^9, 
   3.583594996263379*^9, 3.583596230926641*^9, 3.58359710966917*^9, {
   3.583600377985003*^9, 3.583600402433042*^9}, {3.583600442218943*^9, 
   3.5836004601944103`*^9}, 3.5836306809953413`*^9}],

Cell[BoxData["0.042478825364912265`"], "Output",
 CellChangeTimes->{
  3.583592487413863*^9, 3.583592956526754*^9, 3.5835949349953213`*^9, 
   3.583594996263379*^9, 3.583596230926641*^9, 3.58359710966917*^9, {
   3.583600377985003*^9, 3.583600402433042*^9}, {3.583600442218943*^9, 
   3.5836004601944103`*^9}, 3.583630680997292*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{"A", " ", "check"}], "*)"}], "Subtitle"], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Interest", " ", "rates"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"x", "=", 
     RowBox[{
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
       FractionBox[
        RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", "\[Alpha]", 
      "\[Times]", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{
          RowBox[{"p", "[", "asol", "]"}], "asol"}], 
         SuperscriptBox["w", 
          RowBox[{"1", "-", "\[Alpha]"}]]], ")"}], 
       RowBox[{"1", "/", "\[Alpha]"}]]}]}], " ", ";"}], " ", 
   RowBox[{"(*", 
    RowBox[{
    "definition", " ", "of", " ", "x", " ", "in", " ", "equation", " ", "6"}],
     "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"R", "=", 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Theta]"}], ")"}], "x"}], 
      RowBox[{"1", "-", 
       RowBox[{"\[Theta]", "\[Times]", "x", "\[Times]", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"1", "-", "\[Phi]"}], 
           RowBox[{"r", "[", "asol", "]"}]], "+", 
          FractionBox["\[Phi]", "rf"]}], ")"}]}]}]]}], " ", ";"}], " ", 
   RowBox[{"(*", " ", 
    RowBox[{
    "definition", " ", "of", " ", "R", " ", "in", " ", "equation", " ", 
     "19"}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{"check", "=", 
    RowBox[{"R", "-", 
     RowBox[{"r", "[", "asol", "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.576602504130031*^9, 3.576602510963142*^9}, {
  3.576602547742387*^9, 3.576602566293501*^9}, {3.576602609147439*^9, 
  3.576602610035338*^9}, {3.5766036076159363`*^9, 3.576603638084362*^9}, {
  3.576603764300395*^9, 3.576603822017618*^9}, {3.576867942685465*^9, 
  3.576867944628442*^9}, {3.576931318497242*^9, 3.576931318627068*^9}, {
  3.5769314009725323`*^9, 3.576931406629739*^9}, {3.576946382172192*^9, 
  3.5769463856096687`*^9}, {3.576952515717538*^9, 3.576952611282928*^9}, {
  3.5835901695389957`*^9, 3.5835901745366898`*^9}, {3.583590265118319*^9, 
  3.583590283012437*^9}, {3.583592465833444*^9, 3.5835924788248672`*^9}, {
  3.583597126941496*^9, 3.583597143723578*^9}}],

Cell[BoxData["2.7755575615628914`*^-16"], "Output",
 CellChangeTimes->{
  3.583592487491458*^9, 3.5835929566100397`*^9, 3.583594935081215*^9, 
   3.583594996336772*^9, 3.583596230980526*^9, {3.583597109736239*^9, 
   3.583597143993732*^9}, 3.583600378049055*^9, {3.583600442291153*^9, 
   3.583600460278948*^9}, 3.583630681052155*^9}]
}, Open  ]]
},
WindowSize->{1440, 852},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 7023, 206, 334, "Input"],
Cell[7583, 228, 259, 7, 39, "Input"],
Cell[CellGroupData[{
Cell[7867, 239, 3950, 72, 208, "Input"],
Cell[11820, 313, 308, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12165, 323, 3980, 96, 242, "Input"],
Cell[16148, 421, 303, 5, 27, "Output"],
Cell[16454, 428, 322, 6, 46, "Output"],
Cell[16779, 436, 539, 13, 57, "Output"]
}, Open  ]],
Cell[17333, 452, 9630, 238, 539, "Input"],
Cell[CellGroupData[{
Cell[26988, 694, 2038, 55, 142, "Input"],
Cell[29029, 751, 3034, 56, 242, "Output"],
Cell[32066, 809, 363, 7, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[32466, 821, 1812, 48, 198, "Input"],
Cell[34281, 871, 331, 5, 27, "Output"],
Cell[34615, 878, 332, 5, 27, "Output"],
Cell[34950, 885, 333, 5, 27, "Output"],
Cell[35286, 892, 330, 5, 27, "Output"],
Cell[35619, 899, 334, 5, 27, "Output"],
Cell[35956, 906, 332, 5, 27, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[36325, 916, 2332, 59, 164, "Input"],
Cell[38660, 977, 334, 5, 30, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
