(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     94582,       1965]
NotebookOptionsPosition[     92849,       1911]
NotebookOutlinePosition[     93203,       1927]
CellTagsIndexPosition[     93160,       1924]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 StyleBox[
  RowBox[{"(*", " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Replication", " ", 
     StyleBox["files", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      StyleBox[
       RowBox[{
        StyleBox[
         StyleBox["f", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "or"}]], ":", "\[IndentingNewLine]", 
      StyleBox[
       RowBox[{
        StyleBox[
         StyleBox[
          StyleBox["R", "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "ei", 
        StyleBox[
         StyleBox[
          StyleBox[
           StyleBox[
            StyleBox[
             StyleBox["s", "Title",
              FontColor->RGBColor[1, 0, 0]], "Title",
             FontColor->RGBColor[1, 0, 0]], "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]]}]]}]}], 
    StyleBox[
     StyleBox[
      StyleBox[
       StyleBox[
        StyleBox[
         StyleBox[",", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "Title",
       FontColor->RGBColor[1, 0, 0]], "Title",
      FontColor->RGBColor[1, 0, 0]], "Title",
     FontColor->RGBColor[1, 0, 0]], 
    StyleBox[" ", "Title",
     FontColor->RGBColor[1, 0, 0]], 
    RowBox[{
     StyleBox[
      RowBox[{
       StyleBox[
        StyleBox["R", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "icardo"}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     RowBox[{
      RowBox[{
       StyleBox[
        StyleBox[
         StyleBox["(", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], 
       StyleBox[
        RowBox[{
         StyleBox[
          StyleBox[
           StyleBox[
            StyleBox["f", "Title",
             FontColor->RGBColor[1, 0, 0]], "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "orthcoming"}]], 
       StyleBox[
        StyleBox[
         StyleBox[
          StyleBox[
           StyleBox[
            StyleBox[
             StyleBox[")", "Title",
              FontColor->RGBColor[1, 0, 0]], "Title",
             FontColor->RGBColor[1, 0, 0]], "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}], 
      StyleBox[
       StyleBox[
        StyleBox[".", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "Title",
       FontColor->RGBColor[1, 0, 0]], 
      StyleBox[" ", "Title",
       FontColor->RGBColor[1, 0, 0]], 
      StyleBox[
       RowBox[{"T", 
        StyleBox[
         StyleBox[
          StyleBox[
           StyleBox["h", "Title",
            FontColor->RGBColor[1, 0, 0]], "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "e"}]]}], " ", "Portuguese", " ", 
     StyleBox[
      RowBox[{"S", 
       StyleBox[
        StyleBox[
         StyleBox[
          StyleBox["l", "Title",
           FontColor->RGBColor[1, 0, 0]], "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ump"}]], " ", "and", " ", "Crash", 
     " ", "and", " ", "the", " ", "Euro", " ", "Crisis"}], 
    StyleBox[
     StyleBox[",", "Title",
      FontColor->RGBColor[1, 0, 0]], "Title",
     FontColor->RGBColor[1, 0, 0]], 
    StyleBox[" ", "Title",
     FontColor->RGBColor[1, 0, 0]], 
    RowBox[{
     StyleBox[
      RowBox[{
       StyleBox[
        StyleBox["B", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ro", 
       StyleBox[
        StyleBox["o", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ki", 
       StyleBox[
        StyleBox["n", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "gs"}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{
       StyleBox["Pa", "Title",
        FontColor->RGBColor[1, 0, 0]], "pe", 
       StyleBox[
        StyleBox["r", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], 
       StyleBox[
        StyleBox[
         StyleBox["s", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox["on", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{
       StyleBox["Ec", "Title",
        FontColor->RGBColor[1, 0, 0]], "on", 
       StyleBox[
        StyleBox["o", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "mi", 
       StyleBox[
        StyleBox["c", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}]], 
     StyleBox[" ", "Title",
      FontColor->RGBColor[1, 0, 0]], 
     StyleBox[
      RowBox[{
       StyleBox["Ac", "Title",
        FontColor->RGBColor[1, 0, 0]], "ti", 
       StyleBox[
        StyleBox["v", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "it", 
       StyleBox[
        StyleBox["y", "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]]}]], "\[IndentingNewLine]", "by", " ", 
     "Ricardo", " ", "Reis", "\[IndentingNewLine]", 
     StyleBox[
      RowBox[{
       StyleBox[
        StyleBox[
         StyleBox["J", "Title",
          FontColor->RGBColor[1, 0, 0]], "Title",
         FontColor->RGBColor[1, 0, 0]], "Title",
        FontColor->RGBColor[1, 0, 0]], "ul", 
       StyleBox["y", "Title",
        FontColor->RGBColor[1, 0, 0]]}]]}], ",", " ", "2013"}], 
   "\[IndentingNewLine]", " ", "*)"}], "Title",
  FontColor->RGBColor[1, 0, 0]]], "Input",
 CellChangeTimes->{{3.5768586463353033`*^9, 3.57685866096115*^9}, {
  3.576930877732305*^9, 3.57693090213638*^9}, {3.578503629704011*^9, 
  3.578503630127324*^9}, {3.578504323070333*^9, 3.5785043682483597`*^9}, {
  3.583630582179241*^9, 3.583630609446631*^9}},
 TextAlignment->Center],

Cell[BoxData[
 StyleBox[
  RowBox[{"(*", 
   RowBox[{"Three", " ", "shock", " ", "case"}], "*)"}], "Subtitle"]], "Input",\

 CellChangeTimes->{{3.578504418952533*^9, 3.57850442746059*^9}, {
  3.5785047340999813`*^9, 3.5785047700006037`*^9}, {3.583595940477027*^9, 
  3.583595940961279*^9}, {3.583601365147395*^9, 3.583601368062943*^9}},
 TextAlignment->Center],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{"Setting", " ", "parameters"}], "*)"}], "Subtitle"], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ClearAll", "[", 
    RowBox[{
    "\[Beta]", ",", "\[Alpha]", ",", "rf", ",", "\[Gamma]", ",", "\[Psi]", 
     ",", "abar", ",", "A", ",", "\[Tau]", ",", "\[Theta]", ",", "\[Phi]"}], 
    "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Beta]", "=", "0.84"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rf", "=", "1.12"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Alpha]", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Gamma]", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Psi]", "=", "1"}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"abar", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"A", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Tau]", "=", 
     RowBox[{"1", "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{"1", "-", "0.115"}], ")"}], "/", "1.118"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Theta]", "=", "0.25"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Phi]", "=", "0.0001"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.576568142463111*^9, 3.576568250815782*^9}, {
   3.57656828901313*^9, 3.5765684365491657`*^9}, {3.5765684678228083`*^9, 
   3.576568475827259*^9}, {3.576568926935154*^9, 3.57656894367924*^9}, 
   3.576594851669853*^9, {3.5765962848431664`*^9, 3.576596285042989*^9}, {
   3.576596641397138*^9, 3.576596645884503*^9}, 3.57659675410345*^9, {
   3.5765970164220743`*^9, 3.57659701674228*^9}, {3.576597297101964*^9, 
   3.576597297557336*^9}, {3.576597344411269*^9, 3.576597371943157*^9}, {
   3.576597467645091*^9, 3.5765974887279997`*^9}, {3.5765975341117163`*^9, 
   3.576597562571989*^9}, {3.57659765584583*^9, 3.576597678572938*^9}, {
   3.576597718986532*^9, 3.576597726545978*^9}, {3.576604261781291*^9, 
   3.576604277391655*^9}, {3.5768452591919317`*^9, 3.5768452688646183`*^9}, {
   3.5768580122918587`*^9, 3.576858029562742*^9}, {3.5768585549965763`*^9, 
   3.576858570769487*^9}, 3.576858744360077*^9, {3.576859220674953*^9, 
   3.576859220888139*^9}, {3.576867859219014*^9, 3.576867859337244*^9}, 
   3.576868057031089*^9, {3.576930917764817*^9, 3.5769309589300337`*^9}, {
   3.576931001641756*^9, 3.576931069318158*^9}, {3.576932441246785*^9, 
   3.5769324804574842`*^9}, {3.576946156073378*^9, 3.576946157708376*^9}, {
   3.576953694234235*^9, 3.5769537145289507`*^9}, {3.576953751174453*^9, 
   3.5769537636279087`*^9}, {3.576954334582453*^9, 3.576954334687639*^9}, {
   3.577747323228088*^9, 3.577747350983404*^9}, {3.5777474399205503`*^9, 
   3.5777474718168707`*^9}, {3.577748385824712*^9, 3.577748396650079*^9}, 
   3.577748725541854*^9, {3.577748958697901*^9, 3.5777489617703867`*^9}, {
   3.577749336466115*^9, 3.577749414486216*^9}, 3.5777503368578863`*^9, {
   3.577750694259536*^9, 3.577750862707471*^9}, {3.577751221076071*^9, 
   3.5777512596612787`*^9}, {3.577751290256172*^9, 3.5777513103171587`*^9}, {
   3.57775134852606*^9, 3.577751415975402*^9}, {3.577751596888599*^9, 
   3.577751611132166*^9}, 3.577752846396555*^9, {3.5777550849332533`*^9, 
   3.577755091303933*^9}, {3.577755744575688*^9, 3.5777557451491003`*^9}, {
   3.577763946430201*^9, 3.5777639465220833`*^9}, {3.57776449158388*^9, 
   3.577764508201206*^9}, {3.578503666675148*^9, 3.578503722305316*^9}, {
   3.5785041900078382`*^9, 3.5785042183500566`*^9}, {3.5785042697792797`*^9, 
   3.578504281377235*^9}, {3.578505290058704*^9, 3.578505296292351*^9}, {
   3.583591053989065*^9, 3.58359105443643*^9}, {3.583594329351725*^9, 
   3.583594332748045*^9}, {3.58359654565488*^9, 3.58359655688626*^9}, {
   3.583596648370268*^9, 3.58359664875212*^9}, {3.583596744122332*^9, 
   3.583596773944585*^9}, {3.5835969181595917`*^9, 3.583596978225218*^9}, 
   3.583597015218767*^9, {3.5835975643667707`*^9, 3.5835975648092537`*^9}, {
   3.583597644880289*^9, 3.583597647818804*^9}, {3.583597682977558*^9, 
   3.583597685046522*^9}, {3.583597886852125*^9, 3.583597887868251*^9}, {
   3.5835980174589243`*^9, 3.583598020465067*^9}, {3.583599689180192*^9, 
   3.583599689341773*^9}, {3.583599792013648*^9, 3.583599847308173*^9}, 
   3.583599880879863*^9, 3.583599914819771*^9, {3.583600065825382*^9, 
   3.5836000692547293`*^9}, {3.583600117371851*^9, 3.5836001270808973`*^9}, {
   3.583600488518379*^9, 3.58360055708657*^9}, {3.583601755422399*^9, 
   3.5836017953880653`*^9}, {3.583602152266684*^9, 3.583602152309894*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"The", " ", "initial", " ", "steady", " ", "state"}], ",", " ", 
     RowBox[{"see", " ", "BP_portugal60", " ", "for", " ", 
      RowBox[{"explanations", "."}]}]}], "*)"}], "Subtitle"], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"w", ",", "r", ",", "p"}], "]"}], ";", 
    RowBox[{"w", "=", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
          FractionBox[
           RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
         "\[Alpha]", "\[Times]", 
         SuperscriptBox["A", 
          RowBox[{"1", "/", "\[Alpha]"}]]}], "rf"], ")"}], 
      FractionBox["\[Alpha]", 
       RowBox[{"1", "-", "\[Alpha]"}]]]}], ";", 
    RowBox[{
     RowBox[{"r", "[", "a_", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       FractionBox[
        RowBox[{"\[Theta]", "\[Times]", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Phi]"}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}], "\[Times]", 
         "\[Beta]"}]], ")"}], "\[Times]", 
      FractionBox["abar", "a"]}]}], ";", " ", 
    RowBox[{
     RowBox[{"p", "[", "a_", "]"}], "=", 
     RowBox[{
      FractionBox[
       SuperscriptBox["w", 
        RowBox[{"1", "-", "\[Alpha]"}]], "a"], "\[Times]", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         FractionBox["1", 
          RowBox[{
           FractionBox[
            RowBox[{"1", "-", 
             RowBox[{"\[Theta]", " ", "\[Phi]"}]}], 
            RowBox[{"r", "[", "a", "]"}]], "+", 
           FractionBox[
            RowBox[{"\[Theta]", " ", "\[Phi]"}], "rf"]}]], 
         RowBox[{
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
           FractionBox[
            RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
          "\[Alpha]"}]], ")"}], "\[Alpha]"]}]}], " ", ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"temp1", ",", "temp2", ",", "M"}], "]"}], ";", " ", 
    RowBox[{
     RowBox[{"temp1", "[", "a_", "]"}], " ", "=", " ", 
     RowBox[{"\[Alpha]", 
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
       FractionBox[
        RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
      SuperscriptBox[
       RowBox[{"(", 
        FractionBox[
         RowBox[{"p", "[", "a", "]"}], 
         SuperscriptBox["w", 
          RowBox[{"1", "-", "\[Alpha]"}]]], ")"}], 
       RowBox[{"1", "/", "\[Alpha]"}]]}]}], ";", 
    RowBox[{
     RowBox[{"temp2", "[", "a_", "]"}], "=", 
     RowBox[{"\[Theta]", "\[Times]", 
      RowBox[{"temp1", "[", "a", "]"}], "\[Times]", 
      RowBox[{"(", 
       RowBox[{
        FractionBox[
         RowBox[{"1", "-", "\[Phi]"}], 
         RowBox[{"r", "[", "a", "]"}]], "+", 
        FractionBox["\[Phi]", "rf"]}], ")"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"M", "[", "a_", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       FractionBox[
        RowBox[{
         RowBox[{"temp1", "[", "a", "]"}], "\[Times]", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Theta]"}], ")"}]}], "abar"], ")"}], "\[Times]", 
      FractionBox[
       RowBox[{"a", "-", "abar", "-", 
        RowBox[{"a", "\[Times]", 
         RowBox[{"Hypergeometric2F1", "[", 
          RowBox[{"1", ",", "\[Alpha]", ",", 
           RowBox[{"1", "+", "\[Alpha]"}], ",", 
           RowBox[{
            SuperscriptBox["a", 
             FractionBox["1", "\[Alpha]"]], " ", 
            RowBox[{"temp2", "[", "a", "]"}]}]}], "]"}]}], "+", 
        RowBox[{"abar", "\[Times]", 
         RowBox[{"Hypergeometric2F1", "[", 
          RowBox[{"1", ",", "\[Alpha]", ",", 
           RowBox[{"1", "+", "\[Alpha]"}], ",", 
           RowBox[{
            SuperscriptBox["abar", 
             FractionBox["1", "\[Alpha]"]], " ", 
            RowBox[{"temp2", "[", "a", "]"}]}]}], "]"}]}]}], 
       RowBox[{"temp2", "[", "a", "]"}]]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ClearAll", "[", 
    RowBox[{"temp1", ",", "temp2"}], "]"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"EQ", "[", "a_", "]"}], "=", 
     RowBox[{
      RowBox[{"(", 
       FractionBox[
        RowBox[{"1", "-", "\[Theta]"}], 
        RowBox[{"\[Beta]", "\[Times]", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}]}]], ")"}], "-", 
      RowBox[{"M", "[", "a", "]"}]}]}], ";", "  ", 
    RowBox[{"asol", "=", 
     RowBox[{"Extract", "[", 
      RowBox[{
       RowBox[{"Extract", "[", 
        RowBox[{
         RowBox[{"FindRoot", "[", 
          RowBox[{
           RowBox[{"Re", "[", 
            RowBox[{"EQ", "[", "j", "]"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"j", ",", "0.5", ",", "0", ",", "0.99999"}], "}"}]}], 
          "]"}], ",", 
         RowBox[{"{", "1", "}"}]}], "]"}], ",", 
       RowBox[{"{", "2", "}"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"With", " ", "it", " ", "calculated"}], ",", " ", 
     RowBox[{
      RowBox[{
      "now", " ", "write", " ", "down", " ", "the", " ", "initial", " ", 
       "conditions", " ", "at", " ", "that", " ", "steady", " ", "state", " ",
        "for", " ", "reduced"}], "-", 
      RowBox[{"form", " ", "equilibrium"}]}]}], "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"a0", "=", "asol"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"w0", "=", "w"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"p0", "=", 
     RowBox[{"p", "[", "asol", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"r0", "=", 
     RowBox[{"r", "[", "asol", "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"L0", "=", 
     SuperscriptBox[
      RowBox[{"(", 
       FractionBox[
        RowBox[{"w", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Tau]"}], ")"}]}], 
        RowBox[{
         SuperscriptBox["\[Gamma]", 
          RowBox[{"-", "\[Gamma]"}]], 
         SuperscriptBox[
          RowBox[{"(", 
           RowBox[{"1", "-", "\[Gamma]"}], ")"}], 
          RowBox[{"\[Gamma]", "-", "1"}]], 
         RowBox[{
          RowBox[{"p", "[", "asol", "]"}], "^", "\[Gamma]"}]}]], ")"}], 
      RowBox[{"1", "/", "\[Psi]"}]]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Z0", "=", 
     FractionBox[
      RowBox[{"w", " ", "L0"}], 
      RowBox[{"\[Beta]", "-", "1", "+", 
       FractionBox["1", 
        RowBox[{"\[Gamma]", " ", "\[Alpha]", " ", 
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}]}]]}]]}], " ", ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "Same", " ", "but", " ", "for", " ", "the", " ", "other", " ", 
     "variables", " ", "that", " ", "I", " ", "use", " ", "to", " ", 
     "calculate", " ", "GDP", " ", "and", " ", "TFP"}], "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Y0", " ", "=", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "\[Alpha]"}], ")"}], "\[Times]", "w0", "\[Times]", 
      "L0"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"tfp0", "=", 
     RowBox[{"0.5", "\[Times]", 
      RowBox[{"(", 
       RowBox[{"abar", "+", "a0"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Print", "[", 
     RowBox[{"{", 
      RowBox[{
      "a0", ",", "w0", ",", "p0", ",", "r0", ",", "L0", ",", "Z0", ",", "Y0", 
       ",", "tfp0"}], "}"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"ClearAll", "[", 
    RowBox[{"w", ",", "r", ",", "p", ",", "M", ",", "EQ", ",", "asol"}], 
    "]"}], 
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Getting", " ", "rid", " ", "of", " ", "steady"}], "-", 
     RowBox[{"state", " ", "system"}]}], "*)"}], " "}]}]], "Input",
 CellChangeTimes->{{3.583594345544524*^9, 3.583594345689232*^9}, {
   3.5835961368259153`*^9, 3.5835961369849033`*^9}, {3.5835961920455*^9, 
   3.583596192207542*^9}, {3.58359627969636*^9, 3.583596280042178*^9}, {
   3.583596379658931*^9, 3.583596438018715*^9}, {3.5835965397291822`*^9, 
   3.583596558807066*^9}, {3.583596650445937*^9, 3.583596666729698*^9}, {
   3.5835970425771523`*^9, 3.583597053684436*^9}, 3.583598074276205*^9, {
   3.58359822396348*^9, 3.58359822588536*^9}, {3.583599685990554*^9, 
   3.583599692695265*^9}, {3.5835998630772457`*^9, 3.583599863174127*^9}, {
   3.5835999257927113`*^9, 3.583599955458935*^9}, 3.583600085903513*^9, 
   3.583600141916572*^9, {3.583601761365532*^9, 3.583601798011156*^9}, {
   3.583602078292173*^9, 3.583602080323785*^9}, {3.5836023219725323`*^9, 
   3.583602322274798*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0.6731415893758512`", ",", "0.3980280792885715`", ",", 
   "1.1240526614813982`", ",", "0.44210123149330804`", ",", 
   "0.14859077684896804`", ",", "0.009089413919415689`", ",", 
   "0.04140031105643403`", ",", "0.8365707946879256`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.583594364968026*^9, 3.583595001855123*^9, 3.583595159095558*^9, 
   3.583595829613806*^9, {3.583595895712379*^9, 3.5835959130426598`*^9}, 
   3.583596157799165*^9, 3.5835962003814793`*^9, 3.583596289152198*^9, 
   3.5835963385213118`*^9, {3.583596380686817*^9, 3.5835964392651787`*^9}, {
   3.5835965597746696`*^9, 3.583596563661963*^9}, 3.583596697431628*^9, {
   3.583596731292153*^9, 3.583596775139656*^9}, 3.583596848329535*^9, {
   3.583596919217114*^9, 3.583596966202979*^9}, {3.5835970227316113`*^9, 
   3.583597055072085*^9}, 3.583597458619046*^9, 3.583597587388897*^9, 
   3.583597649949978*^9, {3.583597860789566*^9, 3.583597889516745*^9}, 
   3.5835980757216253`*^9, {3.5835981914692574`*^9, 3.583598214526432*^9}, 
   3.583599505324377*^9, {3.583599705115237*^9, 3.5835997211847057`*^9}, {
   3.583599776529621*^9, 3.583599882243247*^9}, {3.583599932318087*^9, 
   3.583599957214499*^9}, 3.58360000798367*^9, {3.583600070803931*^9, 
   3.583600086848497*^9}, {3.583600119256675*^9, 3.583600143131771*^9}, {
   3.583600257119203*^9, 3.583600329239415*^9}, {3.5836004899800577`*^9, 
   3.58360055908121*^9}, 3.583602273226137*^9, 3.5836023245896683`*^9, {
   3.583602470937582*^9, 3.583602493858839*^9}, 3.58360254103724*^9, 
   3.583630827357538*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{"Initial", " ", "condition"}], " ", "*)"}], "Subtitle"], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"\[Phi]0", "=", "\[Phi]"}], ";", " ", 
   RowBox[{"\[Tau]0", "=", "\[Tau]"}], ";", 
   RowBox[{"rf0", "=", "rf"}], ";"}]}]], "Input",
 CellChangeTimes->{{3.576568142463111*^9, 3.576568250815782*^9}, {
   3.57656828901313*^9, 3.5765684365491657`*^9}, {3.5765684678228083`*^9, 
   3.576568475827259*^9}, {3.576568926935154*^9, 3.57656894367924*^9}, 
   3.576594851669853*^9, {3.5765962848431664`*^9, 3.576596285042989*^9}, {
   3.576596641397138*^9, 3.576596645884503*^9}, 3.57659675410345*^9, {
   3.5765970164220743`*^9, 3.57659701674228*^9}, {3.576597297101964*^9, 
   3.576597297557336*^9}, {3.576597344411269*^9, 3.576597371943157*^9}, {
   3.576597467645091*^9, 3.5765974887279997`*^9}, {3.5765975341117163`*^9, 
   3.576597562571989*^9}, {3.57659765584583*^9, 3.576597678572938*^9}, {
   3.576597718986532*^9, 3.576597726545978*^9}, {3.576604261781291*^9, 
   3.576604277391655*^9}, {3.5768452591919317`*^9, 3.5768452688646183`*^9}, {
   3.5768580122918587`*^9, 3.576858029562742*^9}, {3.5768585549965763`*^9, 
   3.576858570769487*^9}, 3.576858744360077*^9, {3.576859220674953*^9, 
   3.576859220888139*^9}, {3.576867859219014*^9, 3.576867859337244*^9}, 
   3.576868057031089*^9, {3.576930917764817*^9, 3.5769309589300337`*^9}, {
   3.576931001641756*^9, 3.576931069318158*^9}, {3.576932441246785*^9, 
   3.5769324804574842`*^9}, {3.576946156073378*^9, 3.576946157708376*^9}, {
   3.576953694234235*^9, 3.5769537145289507`*^9}, {3.576953751174453*^9, 
   3.5769537636279087`*^9}, {3.576954334582453*^9, 3.576954334687639*^9}, {
   3.576954377324704*^9, 3.576954448171402*^9}, {3.577009759973589*^9, 
   3.577009760877378*^9}, {3.577009807351359*^9, 3.5770098103625507`*^9}, {
   3.5770177665933743`*^9, 3.577017797100525*^9}, {3.5770182393313217`*^9, 
   3.577018249360651*^9}, {3.5770182802782087`*^9, 3.577018290710071*^9}, 
   3.577021071404306*^9, {3.57702721836016*^9, 3.577027230980986*^9}, {
   3.577027494836749*^9, 3.5770275010197477`*^9}, 3.577029959422717*^9, {
   3.577030379658023*^9, 3.57703040421618*^9}, {3.577030556175338*^9, 
   3.5770305563332987`*^9}, {3.5770309132475*^9, 3.577030915913233*^9}, {
   3.5777524573469067`*^9, 3.5777524575441847`*^9}, 3.577752627222561*^9, {
   3.577752671406*^9, 3.577752714496785*^9}, {3.57775276645535*^9, 
   3.5777527697010307`*^9}, {3.57775280926698*^9, 3.577752819953932*^9}, {
   3.577752877929471*^9, 3.577752879942328*^9}, {3.5777554023734713`*^9, 
   3.577755406003168*^9}, {3.577755760381462*^9, 3.5777557606054277`*^9}, {
   3.577755805826351*^9, 3.577755833288972*^9}, {3.577756431976489*^9, 
   3.5777564325396967`*^9}, {3.577756565260528*^9, 3.57775656543491*^9}, {
   3.577756721386959*^9, 3.577756721865856*^9}, {3.577764826008483*^9, 
   3.5777648262241163`*^9}, 3.5777665743315973`*^9, {3.577766664462385*^9, 
   3.577766740274211*^9}, 3.577767449751445*^9, {3.577768098905307*^9, 
   3.577768101094222*^9}, {3.5777681881779003`*^9, 3.5777682096551228`*^9}, {
   3.5777683372647543`*^9, 3.577768339287616*^9}, {3.57776840774852*^9, 
   3.577768411466818*^9}, {3.577768755647347*^9, 3.577768756806068*^9}, {
   3.5777688259390583`*^9, 3.577768829057131*^9}, {3.577768918630642*^9, 
   3.57776896168237*^9}, 3.577768993360383*^9, 3.577769031486478*^9, 
   3.577769067115802*^9, 3.577769116296884*^9, {3.5777691576223516`*^9, 
   3.577769183123699*^9}, 3.577769331307075*^9, 3.57776952852348*^9, {
   3.577770604228904*^9, 3.577770606132168*^9}, {3.577771511441264*^9, 
   3.577771514459856*^9}, {3.577771592454712*^9, 3.5777715942190723`*^9}, {
   3.577771719986549*^9, 3.577771847480386*^9}, {3.5777718998953323`*^9, 
   3.577771924651072*^9}, {3.577772120841693*^9, 3.5777721597159977`*^9}, {
   3.577782321481996*^9, 3.577782323794705*^9}, {3.577782407985108*^9, 
   3.577782409620945*^9}, {3.577782527494239*^9, 3.577782582006694*^9}, {
   3.577782614692233*^9, 3.57778263075247*^9}, 3.577782678460883*^9, {
   3.577782728021605*^9, 3.5777827530000477`*^9}, {3.577782940822111*^9, 
   3.57778297170745*^9}, {3.5777830021231937`*^9, 3.5777830951397038`*^9}, {
   3.577783251836049*^9, 3.577783253539332*^9}, {3.5779942731912518`*^9, 
   3.577994313725197*^9}, {3.577994457367481*^9, 3.577994465807864*^9}, {
   3.578505201552644*^9, 3.578505258355994*^9}, 3.578507278660129*^9, {
   3.5785073099542437`*^9, 3.5785073521899033`*^9}, {3.5785073848606997`*^9, 
   3.578507410049756*^9}, {3.5785074448097897`*^9, 3.578507454605893*^9}, {
   3.578507548977249*^9, 3.578507549240138*^9}, {3.5785092185701733`*^9, 
   3.578509220384676*^9}, {3.5835918154092484`*^9, 3.583591823645336*^9}, {
   3.583591864777338*^9, 3.583591887480379*^9}, {3.5835919932501173`*^9, 
   3.5835920768680067`*^9}, {3.583596146584201*^9, 3.583596150319202*^9}, 
   3.583596198957691*^9, {3.583596285496002*^9, 3.5835962869106407`*^9}, {
   3.5835963371492977`*^9, 3.583596337315585*^9}, {3.583596376339649*^9, 
   3.583596376435616*^9}, {3.58359663216953*^9, 3.5835966323112593`*^9}, {
   3.583596673817319*^9, 3.5835967212660713`*^9}, {3.583597574106468*^9, 
   3.5835975814138613`*^9}, {3.583597638638698*^9, 3.583597641273741*^9}, {
   3.58359769500205*^9, 3.583597728795807*^9}, {3.5835978072989388`*^9, 
   3.583597858925272*^9}, {3.583598027766646*^9, 3.5835980306590767`*^9}, {
   3.5835996960456*^9, 3.583599718580723*^9}, {3.583600001197269*^9, 
   3.583600029806177*^9}, {3.5836002560944357`*^9, 3.5836003276731997`*^9}, 
   3.58360047165514*^9, {3.583601822836635*^9, 3.583601833002717*^9}, {
   3.583602027785774*^9, 3.583602090095536*^9}, 3.583602435569466*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{
    "Definining", " ", "the", " ", "equations", " ", "of", " ", "the", " ", 
     "model", " ", "as", " ", "a", " ", "function", " ", "of", " ", "the", 
     " ", "guess", " ", "a"}], "*)"}], "Subtitle"], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"Initial", " ", "conditions"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{"loop", ",", "Beginloop", ",", "maxloop"}], "]"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"ClearAll", "[", 
     RowBox[{
     "wpath", ",", "Lpath", ",", "apath", ",", "ppath", ",", "Zpath", ",", 
      "Yindex", ",", "tfpindex"}], "]"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"apath", "[", "0", "]"}], "=", "a0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"ppath", "[", "0", "]"}], "=", "p0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Zpath", "[", "0", "]"}], "=", "Z0"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Yindex", "[", "0", "]"}], "=", "1"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"tfpindex", "[", "0", "]"}], "=", "1"}], ";"}]}]}]], "Input",
 CellChangeTimes->{
  3.5770196325059767`*^9, {3.5770200974037533`*^9, 3.577020113813343*^9}, {
   3.577020316701213*^9, 3.577020317418762*^9}, {3.577027235913951*^9, 
   3.5770272623467693`*^9}, {3.57775238687857*^9, 3.577752396433614*^9}, {
   3.5777561330063887`*^9, 3.577756151988963*^9}, {3.57775631054602*^9, 
   3.577756322760045*^9}, {3.577756379267497*^9, 3.5777563798406487`*^9}, {
   3.578509236643421*^9, 3.5785092424991913`*^9}, {3.578509376420991*^9, 
   3.578509566218018*^9}, {3.583591625751354*^9, 3.5835916303284283`*^9}, {
   3.5835919194808073`*^9, 3.583591923565205*^9}, {3.5835935709401007`*^9, 
   3.5835935715953493`*^9}, {3.583595167894635*^9, 3.5835951685800743`*^9}, {
   3.583595342759144*^9, 3.583595346584428*^9}, {3.583595833864387*^9, 
   3.583595928077612*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{
     RowBox[{"Solving", " ", "the", " ", "model"}], ",", " ", 
     RowBox[{"see", " ", "BP_portugal61", " ", "for", " ", "explanations"}]}],
     "*)"}], "Subtitle"], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"loop", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"maxloop", "=", "5"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"Label", "[", "BeginLoop", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"ClearAll", "[", 
       RowBox[{
       "w", ",", "L", ",", "x", ",", "r", ",", "EQ1", ",", "temp1", ",", 
        "temp2", ",", "M", ",", "EQ2"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", "loop", "]"}], ";", 
      RowBox[{"Print", "[", "\"\<One more loop with parameters:\>\"", "]"}], 
      ";", 
      RowBox[{"Print", "[", 
       RowBox[{"{", 
        RowBox[{"rf", ",", "\[Phi]", ",", "\[Tau]"}], "}"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"loop", "\[Equal]", "1"}], ",", 
        RowBox[{"rf", "=", "1.08"}]}], "]"}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{
       "First", " ", "interest", " ", "rate", " ", "falls", " ", "to", " ", 
        "0.08"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", " ", "[", 
       RowBox[{
        RowBox[{"loop", "\[Equal]", "2"}], ",", " ", 
        RowBox[{"\[Phi]", "=", "0.35"}]}], "]"}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"Then", " ", "get", " ", "the", " ", "new", " ", "phi"}], 
       "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"loop", "==", "2"}], ",", 
        RowBox[{"\[Tau]", "=", 
         RowBox[{"1", "-", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "0.124"}], ")"}], "/", "1.126"}]}]}]}], "]"}], 
      ";", " ", 
      RowBox[{"(*", 
       RowBox[{
       "also", " ", "at", " ", "that", " ", "time", " ", "get", " ", "the", 
        " ", "tax", " ", "increase"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"loop", "\[Equal]", "4"}], ",", 
        RowBox[{"rf", "=", "1.16"}]}], "]"}], ";", " ", 
      RowBox[{"(*", 
       RowBox[{
       "But", " ", "then", " ", "2008", " ", "hits", " ", "and", " ", "we", 
        " ", "get", " ", "jump", " ", "in", " ", "interest", " ", "rate"}], 
       "*)"}], " ", "\[IndentingNewLine]", 
      RowBox[{"w", "=", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
            FractionBox[
             RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
           "\[Alpha]", "\[Times]", 
           SuperscriptBox["A", 
            RowBox[{"1", "/", "\[Alpha]"}]]}], "rf"], ")"}], 
        FractionBox["\[Alpha]", 
         RowBox[{"1", "-", "\[Alpha]"}]]]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"eq", " ", "29"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"L", " ", "[", "p_", "]"}], "=", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         FractionBox[
          RowBox[{"w", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Tau]"}], ")"}]}], 
          RowBox[{
           SuperscriptBox["\[Gamma]", 
            RowBox[{"-", "\[Gamma]"}]], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"1", "-", "\[Gamma]"}], ")"}], 
            RowBox[{"\[Gamma]", "-", "1"}]], 
           SuperscriptBox["p", "\[Gamma]"]}]], ")"}], 
        RowBox[{"1", "/", "\[Psi]"}]]}], ";", " ", 
      RowBox[{"(*", 
       RowBox[{"eq", " ", "37"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"x", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
        "\[Alpha]", "\[Times]", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox[
           RowBox[{"p", " ", "a"}], 
           SuperscriptBox["w", 
            RowBox[{"1", "-", "\[Alpha]"}]]], ")"}], 
         RowBox[{"1", "/", "\[Alpha]"}]]}]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"eq", " ", "6"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"r", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       FractionBox[
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "-", 
           RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}], 
         RowBox[{"x", "[", 
          RowBox[{"p", ",", "a"}], "]"}]}], 
        RowBox[{"1", "-", 
         FractionBox[
          RowBox[{"\[Theta]", " ", "\[Phi]", " ", 
           RowBox[{"x", "[", 
            RowBox[{"p", ",", "a"}], "]"}]}], "rf"]}]]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"eqs", " ", "19", " ", "and", " ", "40"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"EQ1", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"\[Beta]", "-", "1", "+", 
           FractionBox["1", 
            RowBox[{"\[Gamma]", " ", "\[Alpha]", " ", 
             RowBox[{"(", 
              RowBox[{"1", "-", 
               RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}]}]]}], ")"}], 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}], "\[Beta]"}], 
          RowBox[{"\[Theta]", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Phi]"}], ")"}]}]], 
         FractionBox["a", "abar"], 
         RowBox[{"r", "[", 
          RowBox[{"p", ",", "a"}], "]"}], 
         RowBox[{"Zpath", "[", 
          RowBox[{"loop", "-", "1"}], "]"}]}], "-", 
        RowBox[{"w", "*", 
         RowBox[{"L", "[", "p", "]"}]}]}]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"eqs", " ", "38", " ", "and", " ", "39"}], "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"temp1", "[", "p_", "]"}], " ", "=", " ", 
       RowBox[{"\[Alpha]", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"1", "-", "\[Alpha]"}], ")"}], 
         FractionBox[
          RowBox[{"1", "-", "\[Alpha]"}], "\[Alpha]"]], "\[Times]", 
        SuperscriptBox[
         RowBox[{"(", 
          FractionBox["p", 
           SuperscriptBox["w", 
            RowBox[{"1", "-", "\[Alpha]"}]]], ")"}], 
         RowBox[{"1", "/", "\[Alpha]"}]]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"temp2", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       RowBox[{"\[Theta]", "\[Times]", 
        RowBox[{"temp1", "[", "p", "]"}], "\[Times]", 
        RowBox[{"(", 
         RowBox[{
          FractionBox[
           RowBox[{"1", "-", "\[Phi]"}], 
           RowBox[{"r", "[", 
            RowBox[{"p", ",", "a"}], "]"}]], "+", 
          FractionBox["\[Phi]", "rf"]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"M", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         FractionBox[
          RowBox[{
           RowBox[{"temp1", "[", "p", "]"}], "\[Times]", 
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Theta]"}], ")"}]}], "abar"], ")"}], 
        "\[Times]", 
        FractionBox[
         RowBox[{"a", "-", "abar", "-", 
          RowBox[{"a", "\[Times]", 
           RowBox[{"Hypergeometric2F1", "[", 
            RowBox[{"1", ",", "\[Alpha]", ",", 
             RowBox[{"1", "+", "\[Alpha]"}], ",", 
             RowBox[{
              SuperscriptBox["a", 
               FractionBox["1", "\[Alpha]"]], " ", 
              RowBox[{"temp2", "[", 
               RowBox[{"p", ",", "a"}], "]"}]}]}], "]"}]}], "+", 
          RowBox[{"abar", "\[Times]", 
           RowBox[{"Hypergeometric2F1", "[", 
            RowBox[{"1", ",", "\[Alpha]", ",", 
             RowBox[{"1", "+", "\[Alpha]"}], ",", 
             RowBox[{
              SuperscriptBox["abar", 
               FractionBox["1", "\[Alpha]"]], " ", 
              RowBox[{"temp2", "[", 
               RowBox[{"p", ",", "a"}], "]"}]}]}], "]"}]}]}], 
         RowBox[{"temp2", "[", 
          RowBox[{"p", ",", "a"}], "]"}]]}]}], ";", "\[IndentingNewLine]", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"EQ2", "[", 
        RowBox[{"p_", ",", "a_"}], "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"1", "-", "\[Theta]"}], ")"}], "\[Times]", 
           RowBox[{"r", "[", 
            RowBox[{"p", ",", "a"}], "]"}], "\[Times]", "a"}], 
          RowBox[{"\[Theta]", "\[Times]", 
           RowBox[{"(", 
            RowBox[{"1", "-", " ", "\[Phi]"}], ")"}], "\[Times]", "abar"}]], 
         ")"}], "-", 
        RowBox[{"M", "[", 
         RowBox[{"p", ",", "a"}], "]"}]}]}], ";", "  ", 
      RowBox[{"(*", 
       RowBox[{"eq", " ", "41"}], "*)"}], "\[IndentingNewLine]", 
      RowBox[{"ClearAll", "[", 
       RowBox[{
       "temp1", ",", "temp2", ",", "temp3", ",", "temp4", ",", "temp5", ",", 
        "temp6"}], "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{"temp1", "=", 
       RowBox[{"ppath", "[", 
        RowBox[{"loop", "-", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"temp2", "=", 
       RowBox[{"apath", "[", 
        RowBox[{"loop", "-", "1"}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"temp3", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", 
            RowBox[{"EQ2", "[", 
             RowBox[{"ps", ",", "as"}], "]"}], "]"}], ",", 
           RowBox[{"EQ1", "[", 
            RowBox[{"ps", ",", "as"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"ps", ",", "temp1"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"as", ",", "temp2"}], "}"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp4", "=", 
       RowBox[{"Extract", "[", 
        RowBox[{"temp3", ",", 
         RowBox[{"{", "1", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"psol", "=", 
       RowBox[{"Extract", "[", 
        RowBox[{"temp4", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"temp5", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{"Re", "[", 
            RowBox[{"EQ2", "[", 
             RowBox[{"ps", ",", "as"}], "]"}], "]"}], ",", 
           RowBox[{"EQ1", "[", 
            RowBox[{"ps", ",", "as"}], "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"ps", ",", "psol"}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"as", ",", "temp2"}], "}"}]}], "}"}]}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"temp6", "=", 
       RowBox[{"Extract", "[", 
        RowBox[{"temp5", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"asol", "=", 
       RowBox[{"Extract", "[", 
        RowBox[{"temp6", ",", 
         RowBox[{"{", "2", "}"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Print", "[", "asol", "]"}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"wpath", "[", "loop", "]"}], "=", "w"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Lpath", "[", "loop", "]"}], "=", 
       RowBox[{"L", "[", "psol", "]"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"apath", "[", "loop", "]"}], "=", "asol"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"ppath", "[", "loop", "]"}], "=", "psol"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Zpath", "[", "loop", "]"}], "=", 
       FractionBox[
        RowBox[{
         RowBox[{"wpath", "[", "loop", "]"}], " ", 
         RowBox[{"Lpath", "[", "loop", "]"}]}], 
        RowBox[{"\[Beta]", "-", "1", "+", 
         FractionBox["1", 
          RowBox[{"\[Gamma]", " ", "\[Alpha]", " ", 
           RowBox[{"(", 
            RowBox[{"1", "-", 
             RowBox[{"\[Theta]", " ", "\[Phi]"}]}], ")"}]}]]}]]}], " ", ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Ypath", "[", "loop", "]"}], "=", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "-", "\[Alpha]"}], ")"}], "\[Times]", 
        RowBox[{"wpath", "[", "loop", "]"}], "\[Times]", 
        RowBox[{"Lpath", "[", "loop", "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tfp", "[", "loop", "]"}], "=", 
       RowBox[{"0.5", "\[Times]", 
        RowBox[{"(", 
         RowBox[{"abar", "+", 
          RowBox[{"apath", "[", "loop", "]"}]}], ")"}]}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Yindex", "[", "loop", "]"}], "=", 
       RowBox[{
        RowBox[{"Ypath", "[", "loop", "]"}], "/", "Y0"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"tfpindex", "[", "loop", "]"}], "=", 
       RowBox[{
        RowBox[{"tfp", "[", "loop", "]"}], "/", "tfp0"}]}], ";", 
      "\[IndentingNewLine]", "\[IndentingNewLine]", 
      RowBox[{"ClearAll", "[", 
       RowBox[{"psol", ",", "asol", ",", "ps", ",", "as"}], "]"}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"loop", "=", 
       RowBox[{"loop", "+", "1"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"If", "[", 
       RowBox[{
        RowBox[{"loop", "\[LessEqual]", "maxloop"}], ",", " ", 
        RowBox[{"Goto", "[", "BeginLoop", "]"}]}], "]"}]}], ")"}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.576568848259672*^9, 3.576568924112115*^9}, {
   3.5765689635497217`*^9, 3.576569010667634*^9}, {3.576593960663879*^9, 
   3.576593962844702*^9}, 3.576594801516539*^9, {3.5765971483308687`*^9, 
   3.576597168756711*^9}, 3.576845379735968*^9, {3.576845618110015*^9, 
   3.57684570685353*^9}, {3.57684574910823*^9, 3.5768457537743*^9}, 
   3.5768458642009907`*^9, {3.576845906347534*^9, 3.576845944895134*^9}, {
   3.5768460925105267`*^9, 3.576846092861925*^9}, {3.576846435818573*^9, 
   3.576846505355893*^9}, {3.576846536647139*^9, 3.576846578734788*^9}, 
   3.576846642096393*^9, {3.576846674427297*^9, 3.576846706915126*^9}, 
   3.576857564279457*^9, 3.5768586851800537`*^9, {3.576931103232319*^9, 
   3.576931118525176*^9}, {3.576931169410565*^9, 3.5769312767352*^9}, {
   3.5769313139086437`*^9, 3.576931339234105*^9}, {3.576931379326527*^9, 
   3.576931425708765*^9}, 3.57693161309846*^9, {3.57693248583175*^9, 
   3.576932496488472*^9}, {3.577008922508029*^9, 3.577009193647162*^9}, {
   3.57700926013571*^9, 3.577009339066244*^9}, {3.577009386273306*^9, 
   3.5770094275666447`*^9}, {3.577009540207925*^9, 3.577009642488489*^9}, {
   3.577010251147545*^9, 3.577010262463252*^9}, {3.57701780960213*^9, 
   3.577017810026084*^9}, {3.5770183095403547`*^9, 3.5770183670459347`*^9}, {
   3.577018415817087*^9, 3.577018490042233*^9}, {3.577018625115223*^9, 
   3.57701886189013*^9}, {3.5770190362448387`*^9, 3.5770194288151503`*^9}, {
   3.57701946329136*^9, 3.577019466948351*^9}, {3.577019501991807*^9, 
   3.577019528977051*^9}, {3.577019561856369*^9, 3.577019605949305*^9}, {
   3.577019647337861*^9, 3.577019701701527*^9}, {3.57701981122571*^9, 
   3.5770198849868727`*^9}, {3.57702005512297*^9, 3.577020073897745*^9}, {
   3.5770201479334517`*^9, 3.577020350128683*^9}, {3.5770204045011377`*^9, 
   3.577020413788368*^9}, {3.5770204488837214`*^9, 3.5770205981502857`*^9}, {
   3.577021089563033*^9, 3.5770210897654552`*^9}, {3.577021159842229*^9, 
   3.577021182274872*^9}, {3.577021231920166*^9, 3.577021279705537*^9}, {
   3.577027843719658*^9, 3.577027889277466*^9}, {3.57702814553866*^9, 
   3.5770281868879147`*^9}, 3.577030295981948*^9, {3.5777524020072107`*^9, 
   3.5777524143380527`*^9}, {3.577755678636342*^9, 3.577755681695964*^9}, {
   3.577756160968165*^9, 3.577756173169348*^9}, {3.577756254838807*^9, 
   3.577756264416573*^9}, {3.577756330564275*^9, 3.577756332650766*^9}, {
   3.577768110321865*^9, 3.5777681104561462`*^9}, {3.578505392885482*^9, 
   3.5785054340344543`*^9}, {3.578505814808563*^9, 3.578505826962782*^9}, {
   3.5785077162836733`*^9, 3.5785077164528217`*^9}, {3.5835920840643177`*^9, 
   3.5835920944759502`*^9}, {3.58359221753226*^9, 3.583592240402791*^9}, {
   3.583592281350213*^9, 3.583592287511373*^9}, {3.583592655801856*^9, 
   3.58359269526478*^9}, {3.583592747485918*^9, 3.583592799648731*^9}, {
   3.583592863330517*^9, 3.583592944484764*^9}, {3.5835930166630297`*^9, 
   3.583593121832058*^9}, {3.583593214211474*^9, 3.583593417331991*^9}, {
   3.58359346316883*^9, 3.583593636979582*^9}, {3.583594415193169*^9, 
   3.5835944625697412`*^9}, {3.5835945123935432`*^9, 3.583594512955429*^9}, {
   3.5835949654756203`*^9, 3.583594970825944*^9}, {3.5835950108761177`*^9, 
   3.58359503746485*^9}, {3.58359518232732*^9, 3.583595253889654*^9}, {
   3.583595314375044*^9, 3.5835953354054813`*^9}, {3.5835954283798847`*^9, 
   3.583595669400648*^9}, {3.5835957043191147`*^9, 3.5835957831969957`*^9}, {
   3.583602106881662*^9, 3.583602115135027*^9}, {3.583602158894648*^9, 
   3.5836022562152777`*^9}, {3.5836023353102903`*^9, 3.583602539042213*^9}, {
   3.5836308001029377`*^9, 3.583630820849966*^9}}],

Cell[CellGroupData[{

Cell[BoxData["1"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827465878*^9}],

Cell[BoxData["\<\"One more loop with parameters:\"\>"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.58363082746791*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.12`", ",", "0.0001`", ",", "0.20840787119856896`"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.5836308274711523`*^9}],

Cell[BoxData["0.673141853552977`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827474453*^9}],

Cell[BoxData["2"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827478664*^9}],

Cell[BoxData["\<\"One more loop with parameters:\"\>"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827481785*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.08`", ",", "0.0001`", ",", "0.20840787119856896`"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.58363082748493*^9}],

Cell[BoxData["0.6074154300565187`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827490219*^9}],

Cell[BoxData["3"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827493252*^9}],

Cell[BoxData["\<\"One more loop with parameters:\"\>"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827496409*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.08`", ",", "0.35`", ",", "0.22202486678507982`"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827499542*^9}],

Cell[BoxData["0.6098391863173281`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827502632*^9}],

Cell[BoxData["4"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827505658*^9}],

Cell[BoxData["\<\"One more loop with parameters:\"\>"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.5836308275087547`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.08`", ",", "0.35`", ",", "0.22202486678507982`"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827512807*^9}],

Cell[BoxData["0.6073284071403933`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827515936*^9}],

Cell[BoxData["5"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.5836308275190983`*^9}],

Cell[BoxData["\<\"One more loop with parameters:\"\>"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.5836308275222054`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1.16`", ",", "0.35`", ",", "0.22202486678507982`"}], 
  "}"}]], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827525366*^9}],

Cell[BoxData["0.6083110852518836`"], "Print",
 CellChangeTimes->{
  3.583594388696889*^9, 3.583594435262163*^9, 3.5835944663168507`*^9, 
   3.583594517518454*^9, 3.583595002057741*^9, 3.583595039436788*^9, {
   3.583595204081061*^9, 3.583595221293898*^9}, {3.583595315416131*^9, 
   3.5835953263595257`*^9}, {3.583595438511649*^9, 3.583595455675788*^9}, {
   3.583595496638554*^9, 3.583595526716812*^9}, 3.58359557465352*^9, 
   3.583595606203343*^9, {3.583595650021867*^9, 3.5835957840446*^9}, 
   3.5835958369018803`*^9, {3.583595895911438*^9, 3.5835959132429256`*^9}, 
   3.5835961580137653`*^9, 3.58359620057971*^9, 3.583596289353142*^9, 
   3.5835963387366943`*^9, {3.583596380851996*^9, 3.583596439414091*^9}, 
   3.583596563943672*^9, 3.583596697648623*^9, {3.583596731527424*^9, 
   3.5835967753389273`*^9}, 3.583596848528097*^9, {3.5835969194496326`*^9, 
   3.583596966419764*^9}, {3.583597022929723*^9, 3.5835970552706003`*^9}, 
   3.583597458843581*^9, 3.583597587576621*^9, 3.583597650132406*^9, {
   3.583597861104342*^9, 3.583597889750112*^9}, 3.5835980758658943`*^9, {
   3.583598191607032*^9, 3.5835982148588448`*^9}, 3.583599505460855*^9, {
   3.5835997059067717`*^9, 3.5835997214296417`*^9}, {3.583599776673291*^9, 
   3.583599882461485*^9}, {3.583599932459607*^9, 3.583599957392242*^9}, 
   3.583600008223879*^9, {3.5836000709977207`*^9, 3.583600087085836*^9}, {
   3.583600119450653*^9, 3.583600143394418*^9}, {3.583600257458034*^9, 
   3.583600329437546*^9}, {3.58360049018752*^9, 3.5836005593052073`*^9}, 
   3.583602273446213*^9, {3.5836024711819344`*^9, 3.583602494097541*^9}, 
   3.583602541291328*^9, 3.583630827530097*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"(*", 
    RowBox[{"Display", " ", "solution"}], "*)"}], "Subtitle"], 
  StyleBox["\[IndentingNewLine]", "Subtitle"], 
  RowBox[{
   RowBox[{
    RowBox[{"figure1", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"tfpindex", "[", "j", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{"1", ",", 
             RowBox[{"tfpindex", "[", "maxloop", "]"}]}], "]"}], "-", 
           "0.05"}], ",", 
          RowBox[{
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"tfpindex", "[", "0", "]"}], ",", 
             RowBox[{"tfpindex", "[", "maxloop", "]"}]}], "]"}], "+", 
           "0.05"}]}], "}"}]}], ",", 
       RowBox[{"PlotJoined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Hue", "[", ".6", "]"}]}], ",", 
       RowBox[{"PlotLabel", "\[Rule]", "\"\<Threshold\>\""}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"figure1", ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", "\"\<Figure 1. Impulse response for TFP\>\""}], 
     ",", 
     StyleBox[
      RowBox[{"ImageSize", "->", "700"}], "MR"]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"tfpindex", "[", "0", "]"}], ",", 
      RowBox[{"tfpindex", "[", "1", "]"}], ",", 
      RowBox[{"tfpindex", "[", "2", "]"}], ",", 
      RowBox[{"tfpindex", "[", "3", "]"}], ",", 
      RowBox[{"tfpindex", "[", "4", "]"}], ",", 
      RowBox[{"tfpindex", "[", "5", "]"}], ",", 
      RowBox[{"tfpindex", "[", "maxloop", "]"}]}], "}"}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"figure2", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"j", ",", 
           RowBox[{"Yindex", "[", "j", "]"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"j", ",", "0", ",", "5"}], "}"}]}], "]"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{"Min", "[", 
            RowBox[{
             RowBox[{"Yindex", "[", "0", "]"}], ",", 
             RowBox[{"Yindex", "[", "maxloop", "]"}]}], "]"}], "-", "0.05"}], 
          ",", 
          RowBox[{
           RowBox[{"Max", "[", 
            RowBox[{
             RowBox[{"Yindex", "[", "0", "]"}], ",", 
             RowBox[{"Yindex", "[", "maxloop", "]"}]}], "]"}], "+", 
           "0.05"}]}], "}"}]}], ",", 
       RowBox[{"PlotJoined", "\[Rule]", "True"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"Hue", "[", ".6", "]"}]}], ",", 
       RowBox[{"PlotLabel", "\[Rule]", "\"\<Threshold\>\""}], ",", 
       RowBox[{"DisplayFunction", "\[Rule]", "Identity"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Show", "[", 
    RowBox[{"figure2", ",", 
     RowBox[{
     "PlotLabel", "\[Rule]", 
      "\"\<Figure 2. Impulse response for output index\>\""}], ",", 
     StyleBox[
      RowBox[{"ImageSize", "->", "700"}], "MR"]}], "]"}], 
   "\[IndentingNewLine]", 
   RowBox[{"Print", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Yindex", "[", "0", "]"}], ",", 
      RowBox[{"Yindex", "[", "1", "]"}], ",", 
      RowBox[{"Yindex", "[", "2", "]"}], ",", 
      RowBox[{"Yindex", "[", "3", "]"}], ",", 
      RowBox[{"Yindex", "[", "4", "]"}], ",", 
      RowBox[{"Yindex", "[", "5", "]"}], ",", 
      RowBox[{"Yindex", "[", "maxloop", "]"}]}], "}"}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.577756599981761*^9, 3.577756600179932*^9}, {
  3.5777566887781477`*^9, 3.577756706428228*^9}, {3.5777681321903477`*^9, 
  3.5777681342622747`*^9}, {3.5785057065812263`*^9, 3.578505795164377*^9}, {
  3.578505853706347*^9, 3.578505878271718*^9}, {3.578507723314719*^9, 
  3.578507735801302*^9}, {3.5835936712339497`*^9, 3.5835936967880507`*^9}, {
  3.583596880180995*^9, 3.5835968906931*^9}}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.6], 
    LineBox[{{0., 1.}, {1., 1.000000157892869}, {2., 0.9607169173627134}, {3.,
      0.9621655432747104}, {4., 0.9606649056760289}, {5., 
     0.9612522308120067}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.915},
  DisplayFunction:>Identity,
  ImageSize->700,
  PlotLabel->FormBox[
   "\"Figure 1. Impulse response for TFP\"", TraditionalForm],
  PlotRange->{{0., 5.}, {0.9112522308120067, 1.05}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{
  3.5835950023408537`*^9, 3.5835957864828*^9, 3.583595840056633*^9, {
   3.583595896133157*^9, 3.583595913445622*^9}, 3.5835961582174053`*^9, 
   3.583596200884206*^9, 3.583596289652239*^9, 3.58359633895683*^9, {
   3.5835963810898943`*^9, 3.583596439634482*^9}, 3.583596564231386*^9, 
   3.583596697867814*^9, {3.5835967317760067`*^9, 3.583596775563979*^9}, 
   3.583596848720254*^9, {3.583596882206583*^9, 3.583596966714993*^9}, {
   3.583597023149411*^9, 3.583597055476192*^9}, 3.583597459223629*^9, 
   3.583597588104414*^9, 3.583597650659893*^9, {3.583597861936143*^9, 
   3.5835978914083548`*^9}, 3.583598076401626*^9, {3.583598191946891*^9, 
   3.5835982155881157`*^9}, 3.583599505730214*^9, {3.583599706439136*^9, 
   3.583599721827949*^9}, {3.5835997769642467`*^9, 3.5835998832049*^9}, {
   3.5835999327312803`*^9, 3.583599958385301*^9}, 3.5836000091245117`*^9, {
   3.583600071675687*^9, 3.583600088521326*^9}, {3.583600120142138*^9, 
   3.5836001439310904`*^9}, {3.583600258408346*^9, 3.583600329996324*^9}, {
   3.583600490681291*^9, 3.583600560352099*^9}, 3.5836022738039827`*^9, {
   3.5836024714232407`*^9, 3.583602494450898*^9}, 3.583602541663617*^9, 
   3.583630827628724*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1.000000157892869`", ",", "0.9607169173627134`", ",", 
   "0.9621655432747104`", ",", "0.9606649056760289`", ",", 
   "0.9612522308120067`", ",", "0.9612522308120067`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.583595002361383*^9, 3.583595786491796*^9, 3.583595840065131*^9, {
   3.583595896144064*^9, 3.583595913455843*^9}, 3.583596158227809*^9, 
   3.5835962008947287`*^9, 3.58359628966467*^9, 3.583596338966763*^9, {
   3.5835963810998383`*^9, 3.5835964396439543`*^9}, 3.583596564242362*^9, 
   3.583596697880211*^9, {3.583596731785967*^9, 3.583596775573778*^9}, 
   3.583596848730063*^9, {3.583596882216522*^9, 3.583596966726304*^9}, {
   3.583597023158935*^9, 3.583597055486087*^9}, 3.583597459235964*^9, 
   3.583597588126069*^9, 3.583597650674486*^9, {3.583597861947753*^9, 
   3.583597891425364*^9}, 3.583598076448709*^9, {3.583598191968089*^9, 
   3.583598215603484*^9}, 3.5835995057443953`*^9, {3.583599706451846*^9, 
   3.5835997218380003`*^9}, {3.5835997769757833`*^9, 3.583599883223296*^9}, {
   3.583599932741374*^9, 3.583599958398704*^9}, 3.583600009142083*^9, {
   3.5836000716957407`*^9, 3.583600088540098*^9}, {3.583600120155601*^9, 
   3.583600143947174*^9}, {3.583600258418989*^9, 3.5836003300157633`*^9}, {
   3.583600490696726*^9, 3.583600560367423*^9}, 3.583602273815645*^9, {
   3.583602471463871*^9, 3.5836024944758863`*^9}, 3.5836025417041283`*^9, 
   3.5836308276416073`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {Hue[0.6], 
    LineBox[{{0., 1.}, {1., 1.0226149391646233`}, {2., 1.0001849715089952`}, {
     3., 0.9877635317382346}, {4., 0.9412061918649464}, {5., 
     0.9362907510833034}}]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0.89},
  DisplayFunction:>Identity,
  ImageSize->700,
  PlotLabel->FormBox[
   "\"Figure 2. Impulse response for output index\"", TraditionalForm],
  PlotRange->{{0., 5.}, {0.8862907510833034, 1.05}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], Automatic}]], "Output",
 CellChangeTimes->{
  3.5835950023408537`*^9, 3.5835957864828*^9, 3.583595840056633*^9, {
   3.583595896133157*^9, 3.583595913445622*^9}, 3.5835961582174053`*^9, 
   3.583596200884206*^9, 3.583596289652239*^9, 3.58359633895683*^9, {
   3.5835963810898943`*^9, 3.583596439634482*^9}, 3.583596564231386*^9, 
   3.583596697867814*^9, {3.5835967317760067`*^9, 3.583596775563979*^9}, 
   3.583596848720254*^9, {3.583596882206583*^9, 3.583596966714993*^9}, {
   3.583597023149411*^9, 3.583597055476192*^9}, 3.583597459223629*^9, 
   3.583597588104414*^9, 3.583597650659893*^9, {3.583597861936143*^9, 
   3.5835978914083548`*^9}, 3.583598076401626*^9, {3.583598191946891*^9, 
   3.5835982155881157`*^9}, 3.583599505730214*^9, {3.583599706439136*^9, 
   3.583599721827949*^9}, {3.5835997769642467`*^9, 3.5835998832049*^9}, {
   3.5835999327312803`*^9, 3.583599958385301*^9}, 3.5836000091245117`*^9, {
   3.583600071675687*^9, 3.583600088521326*^9}, {3.583600120142138*^9, 
   3.5836001439310904`*^9}, {3.583600258408346*^9, 3.583600329996324*^9}, {
   3.583600490681291*^9, 3.583600560352099*^9}, 3.5836022738039827`*^9, {
   3.5836024714232407`*^9, 3.583602494450898*^9}, 3.583602541663617*^9, 
   3.583630827649047*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1.0226149391646233`", ",", "1.0001849715089952`", ",", 
   "0.9877635317382346`", ",", "0.9412061918649464`", ",", 
   "0.9362907510833034`", ",", "0.9362907510833034`"}], "}"}]], "Print",
 CellChangeTimes->{
  3.583595002361383*^9, 3.583595786491796*^9, 3.583595840065131*^9, {
   3.583595896144064*^9, 3.583595913455843*^9}, 3.583596158227809*^9, 
   3.5835962008947287`*^9, 3.58359628966467*^9, 3.583596338966763*^9, {
   3.5835963810998383`*^9, 3.5835964396439543`*^9}, 3.583596564242362*^9, 
   3.583596697880211*^9, {3.583596731785967*^9, 3.583596775573778*^9}, 
   3.583596848730063*^9, {3.583596882216522*^9, 3.583596966726304*^9}, {
   3.583597023158935*^9, 3.583597055486087*^9}, 3.583597459235964*^9, 
   3.583597588126069*^9, 3.583597650674486*^9, {3.583597861947753*^9, 
   3.583597891425364*^9}, 3.583598076448709*^9, {3.583598191968089*^9, 
   3.583598215603484*^9}, 3.5835995057443953`*^9, {3.583599706451846*^9, 
   3.5835997218380003`*^9}, {3.5835997769757833`*^9, 3.583599883223296*^9}, {
   3.583599932741374*^9, 3.583599958398704*^9}, 3.583600009142083*^9, {
   3.5836000716957407`*^9, 3.583600088540098*^9}, {3.583600120155601*^9, 
   3.583600143947174*^9}, {3.583600258418989*^9, 3.5836003300157633`*^9}, {
   3.583600490696726*^9, 3.583600560367423*^9}, 3.583602273815645*^9, {
   3.583602471463871*^9, 3.5836024944758863`*^9}, 3.5836025417041283`*^9, 
   3.5836308276594963`*^9}]
}, Open  ]]
},
WindowSize->{1440, 852},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 5, \
2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 7023, 206, 334, "Input"],
Cell[7583, 228, 360, 8, 39, "Input"],
Cell[7946, 238, 4610, 81, 208, "Input"],
Cell[CellGroupData[{
Cell[12581, 323, 8953, 242, 543, "Input"],
Cell[21537, 567, 1582, 25, 20, "Print"]
}, Open  ]],
Cell[23134, 595, 5696, 82, 56, "Input"],
Cell[28833, 679, 2087, 50, 163, "Input"],
Cell[CellGroupData[{
Cell[30945, 733, 17525, 417, 1111, "Input"],
Cell[CellGroupData[{
Cell[48495, 1154, 1631, 23, 20, "Print"],
Cell[50129, 1179, 1667, 23, 20, "Print"],
Cell[51799, 1204, 1720, 26, 20, "Print"],
Cell[53522, 1232, 1648, 23, 20, "Print"],
Cell[55173, 1257, 1631, 23, 20, "Print"],
Cell[56807, 1282, 1668, 23, 20, "Print"],
Cell[58478, 1307, 1717, 26, 20, "Print"],
Cell[60198, 1335, 1649, 23, 20, "Print"],
Cell[61850, 1360, 1631, 23, 20, "Print"],
Cell[63484, 1385, 1668, 23, 20, "Print"],
Cell[65155, 1410, 1716, 26, 20, "Print"],
Cell[66874, 1438, 1649, 23, 20, "Print"],
Cell[68526, 1463, 1631, 23, 20, "Print"],
Cell[70160, 1488, 1670, 23, 20, "Print"],
Cell[71833, 1513, 1716, 26, 20, "Print"],
Cell[73552, 1541, 1649, 23, 20, "Print"],
Cell[75204, 1566, 1633, 23, 20, "Print"],
Cell[76840, 1591, 1670, 23, 20, "Print"],
Cell[78513, 1616, 1716, 26, 20, "Print"],
Cell[80232, 1644, 1649, 23, 20, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[81930, 1673, 4347, 113, 178, "Input"],
Cell[86280, 1788, 1810, 34, 458, "Output"],
Cell[88093, 1824, 1456, 23, 20, "Print"],
Cell[89552, 1849, 1821, 34, 465, "Output"],
Cell[91376, 1885, 1457, 23, 20, "Print"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
