function [EEAgg, EEimpatient, LSE, Xtrack] = EulerError_G1(Xstst, G1, impact, Env,nerr,nSimBetweenError,testGrid)
%EULERERROR Simulates the economy and computes Euler equation errors at
%randomly generated state vectors

global Params;

EEAgg = NaN(5,nerr);
LSE = NaN(3,nerr);

EEimpatient = NaN(length(testGrid)*Params.npp,nerr);
Xtrack = NaN(length(Xstst),nerr);

%simulate for nerr * nSimBetweenError periods
T = nerr * nSimBetweenError;

Sigma = Params.Sigma;
nshock = size(impact,2);
shocks = randn(T,nshock)';  %the RNG populates the matrix column by column so forming the matrix this way and then transposing it means that we get the same shocks even if we leave off some columns.
state = zeros(size(impact,1),1);
for t = 1:T
    state_L = state;
    state = G1*state + impact*Sigma*shocks(:,t);
    if mod(t,nSimBetweenError) == 0
        ierr = t/nSimBetweenError;
        X2 = [Xstst; Xstst] + [state; state_L];
        [ EEAgg(:,ierr), EEimpatient(:,ierr), LSE(:,ierr), Xtrack(:,ierr)] = EulerError_at_a_state( X2, Xstst , G1, impact, Env, testGrid);
    end
end


end

function [ EEAgg, EEimpatient, LSE, Xtil ] = EulerError_at_a_state( X2, Xstst , G1, impact, Env, testGrid)

global Params;

EXXpp = Xstst + G1*(X2(Env.varix.x) - Xstst);
[ce_L, ne_L, ~, wage_L, K_L, Klag_L, margtaxe_L, ii_L, iitrack1_L, laborMarketStatus_L, ~, par_L, Xtil ]  = EulerError_nonlinear( X2, EXXpp,  Env);

par_L = par2wide(par_L);

%labor supply errors 
%of patient households
nehat = (ce_L.^(-Params.sigma).*Params.skille*wage_L*(1-margtaxe_L)/(1+Params.tauC)/Params.psi1).^(1/Params.psi2); %entrepreneur labor supply
labor_supply_error_patient = nehat/ne_L - 1;

%of impatient households
nhat = zeros(length(testGrid),Params.npp);
nthis = nhat;
for ip = 1:Params.npp
    S = savingspline(par_L(Params.par_sind,ip));
    N = nspline(par_L(Params.par_nind,ip));
    sthis = interp_savspline(S,testGrid);
    [cthis, nthis(:,ip), margTaxthis] = get_cnt(testGrid,sthis,N,1+iitrack1_L,wage_L,ip);
    nhat(:,ip) = ((cthis.^(-Params.sigma).*Params.skill(ip)*wage_L.*(1-margTaxthis))/(1+Params.tauC)/Params.psi1).^(1./Params.psi2);
end
%aggregate nhat 
Dsim = x2par(Xtil,Env);
nhat = nhat(:);
nthis = nthis(:);
nhat =  Params.nu * (Dsim' * nhat);
nthis =  Params.nu * (Dsim' * nthis);
labor_supply_error_impatient = nhat/nthis -1;

labor_supply_error_total = (nehat+nhat)/(nthis+ne_L) -1;
LSE = [labor_supply_error_patient; labor_supply_error_impatient; labor_supply_error_total];


%clean up 
clear ne_L nehat nhat nthis cthis sthis S N labor_supply_error_patient labor_supply_error_impatient labor_supply_error_total ip;


%prepare for numerical integration over the aggregate shocks to compute
%Euler errors
n = [11 11 11];
mu = zeros(1,3);
var = diag([Params.SigmaEpsz Params.SigmaEpsmp Params.Sigmamarkup])^2;
[x, w] = qnwnorm(n,mu,var);
x = [x(:,1) zeros(prod(n),2) x(:,2:3)];  %add zero for govt spending and tax shocks.


netI_L = K_L - Klag_L;
EEAgg_LHS_coefs = [(1+Params.Psi*(netI_L/Klag_L))*(1-margtaxe_L)
    1];

%Loop over the quadrature grid
EEAgg = [0;0];  %this will store two euler equations [investment; bond] for patient households
EEimpatient = zeros(size(testGrid,1)*Params.npp,1);

EXXpp = Xtil;  %this is just for speed b/c we do not need to calculate ii in the inner loop
for i = 1:prod(n)
    
    %find the decisions given a shock realization
    tmp = (Xtil-Xstst);
    XXp = zeros(size(Xstst));
    XXp = Xstst + G1*tmp + impact *  x(i,:)';  %does this line affect anything? yes, b/c of the static equations.
    clear tmp;
    
    
    [ce, ~, r, wage, K, ~, margtaxe,~,~,~,ppi, par] = EulerError_nonlinear( [XXp; Xtil], EXXpp , Env);
    
    %compute the integrand inside the expectation
    netI = K - K_L;
    eeAgg = Params.betae / ce *[1/(1+Params.tauP)*(1-margtaxe)*(1 + r  - (Params.Psi/2)*(netI/K_L).^2 + Params.Psi*(netI/K_L)*(K/K_L))
        (1 + ii_L*(1-margtaxe))/ppi];
    

    
    % impatient household error
    [~, cthis, MUexp, sthis] = eulerres(par_L,par,1+iitrack1_L,1+ii_L,wage_L,wage,laborMarketStatus_L,ppi,0,0,0,0,false,testGrid);
    
    %integrate using quadrature weights
    EEAgg = EEAgg + w(i) * eeAgg;
    EEimpatient = EEimpatient + w(i)*MUexp;
    
end

EEAgg = EEAgg./EEAgg_LHS_coefs;
EEAgg = [1./EEAgg  repmat(ce_L,2,1)];
EEimpatient = [invmargutilC(Params.betah*EEimpatient)  cthis];
Iconstrained = sthis < 1e-7;
EEimpatient(Iconstrained,1) = EEimpatient(Iconstrained,2);


EE_int = Params.nu * (Dsim' * EEimpatient);

EEAgg = [EEAgg; EE_int; EEAgg+repmat(EE_int,2,1)];


%express in percentage terms
EEAgg = EEAgg(:,1)./EEAgg(:,2) -1;
EEimpatient = EEimpatient(:,1)./EEimpatient(:,2) -1;




end
function [ce, ne, r, wage, K, Klag, margtaxe, ii, iitrack1, laborMarketStatus, ppi, par, Xtilde ] = EulerError_nonlinear( X2, EXXp, Env)

global Params modelOptions;


ne = NaN;  %suppress a warning.

%unpack
xcurr = X2(Env.varix.x);
xlag = X2(Env.varix.xlag);

%where do we add stst values?  they are part of X except for D.  For D the
%steady state is added in x2par.

[~,par,~,xagg,Env] = x2par(xcurr,Env); %#ok
[Dlag,~,~,xagglag] = x2par(xlag,Env); %#ok
[~,~,~,Exp] = x2par(EXXp,Env); %#ok



%1) read out some state and forward-looking variables from x
nms = {'z', 'Gshock', 'mpshock', 'markupshock',...
    'M','ce_track', 'N','ppi', 'taxes_prop', 'Klag', 'iitrack1','ne', ...
    'pbarA', 'pbarB'};
for i = 1:length(nms)
    inm = find(strcmp(Params.aggnames,nms{i})); %#ok
    eval([nms{i} ' = xagg(inm);']);
end
ce = ce_track; 
clear ce_track;

%2) read out some state variables from xlag
nms = {'U', 'NLF', 'K','B','ii','be','S'};
for i = 1:length(nms)
    inm = find(strcmp(Params.aggnames,nms{i})); %#ok
    eval([nms{i} '_L = xagglag(inm);']);
end



%3) read out some variable from steady state
nms = {'ii','Y','G','B','LumpSumTax','margtaxe_track'};
for i = 1:length(nms)
    inm = find(strcmp(Params.aggnames,nms{i})); %#ok
    eval([nms{i} '_stst = Env.aggstst(inm);']);
end

%3.5) read out some variable from E(x')
nms = {'margtaxe_track'};
for i = 1:length(nms)
    inm = find(strcmp(Params.aggnames,nms{i})); %#ok
    eval([nms{i} '_E = Exp(inm);']);
end


Dlagscaled = scaleassets(Dlag,(1/ppi));

%4) calculate some variables from exact equations

%a) inflation
pstar =  pbarA/pbarB;
ppi = ((1-Params.theta)...
       /(1-Params.theta*pstar.^(1/(1-Params.mu)))).^(1-Params.mu);

%b) price dispersion
S = (1-Params.theta)*S_L*ppi.^(-Params.mu/(1-Params.mu))...
        +Params.theta*pstar.^(Params.mu/(1-Params.mu));


%c) output from production function
Y = z * K_L.^Params.alpha * N.^(1-Params.alpha) / S;

%d) prices from firm FOCs
KL = K_L / N;
wage =  M*(1-Params.alpha)*z* KL.^Params.alpha;
rhat =  -Params.delta + M*Params.alpha*z* KL.^(Params.alpha-1);
r = (1-Params.tauK)/(1-Params.tauK*Params.upsilon) * rhat;

%e) government policies

ii = ((1-margtaxe_track_stst)*ii_stst + Params.phiP*(ppi-1) + Params.phiY*log(Y/Y_stst) +  mpshock)/(1-margtaxe_track_E);


assert( modelOptions.FiscalAdj == 4)
LumpSumTax = log((B_stst./B_L).^Params.phiLST) + LumpSumTax_stst;
G = exp(log(G_stst) + (-Params.phiG/Params.phiLST)...
    * (LumpSumTax - LumpSumTax_stst));  

%f) hhld consumption, personal income tax revenue, and dist'n of wealth
taxshock =0;
[ch, ~, taxpaidh] = expect_C(Dlagscaled,par,1+iitrack1,wage,[],taxshock);
C = ce + ch*Params.nu;
if modelOptions.stickyPrices
    laborMarketStatus = Params.shockWeight(1) * log(z) - Params.shockWeight(2)*mpshock - (1-sum(Params.shockWeight))*markupshock;
else
    laborMarketStatus = Params.shockWeight * log(z);
end
Pi = forwardmat(1,par,laborMarketStatus);
D = forward(Dlagscaled,Pi);

% f) agg res constraint--> solve for K
tmp_a = Params.Psi/2 /K_L;
tmp_b = 1 - Params.Psi;
tmp_c = -(Y + (1-Params.delta)*K_L - FixedCost((Y-Y_stst)/Y_stst) ...
    -Params.Psi/2 * K_L - G - C);

K = (-tmp_b + sqrt(tmp_b^2-4*tmp_a*tmp_c))/(2*tmp_a);

Kalt = (-tmp_b - sqrt(tmp_b^2-4*tmp_a*tmp_c))/(2*tmp_a);
assert(K > Kalt,['Y G C K_L = ' num2str([Y G C K_L])])

assert(abs((K + C + G) - (Y + (1-Params.delta)*K_L - FixedCost((Y-Y_stst)/Y_stst) -  Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L))<1e-7)


% g) government debt from budget
after_tax_div_intermed = (1-Params.tauK)*(Y - M * z * K_L.^Params.alpha * N.^(1-Params.alpha) - FixedCost((Y-Y_stst)/Y_stst));

div_cap =  r *K_L - K + K_L - Params.Psi/2 * ((K-K_L)/K_L).^2 * K_L;
dividend =  after_tax_div_intermed + div_cap - taxes_prop;

xe = be_L/ppi*iitrack1 + Params.skille*ne*wage + dividend;

[margtaxe, taxpaide] = interp_tax(xe,Params.incometax);


%if nargout < 8, return; end

discDistlag = zeros(Params.npp,1);
for ip = 1:Params.npp
    discDistlag(ip) = expect_1(Dlag,ip);
end

tmp = Params.Tu + Params.To;

transferspending = (Params.nu*discDistlag)' * tmp;

taxes_corp = Params.tauK*(Y - M * z * K_L.^Params.alpha * N.^(1-Params.alpha) - FixedCost((Y-Y_stst)/Y_stst)) ...
    + Params.tauK*(1-Params.upsilon)/(1-Params.upsilon*Params.tauK)*rhat*K_L;


taxes_income = Params.nu*taxpaidh + taxpaide + LumpSumTax;

taxRevenue = taxes_income + Params.tauC*C + taxes_prop + taxes_corp;

B = B_L*(1 + iitrack1)/ppi + G + transferspending - taxRevenue;


%h) patient hhld bond holdings due to bond market clearing
assetsh = expect_k(D)*Params.nu;
be = B-assetsh;

% i) labor market
U = dot(1*(Params.estatus == 2),discDistlag);
NLF = dot(1*(Params.estatus == 3),discDistlag);
jobfind = expect_jobfind(Dlagscaled,par,laborMarketStatus);
Hrs = ne + expect_L(Dlagscaled,par,false)*Params.nu; % raw hours worked


% 5) package results back into x
nms = { 'be', 'K', 'B', 'KL', 'Y', 'iitrack1', 'assetsh',  'G', ...
    'xe', 'C', 'Hrs', 'U', 'NLF', 'jobfind', 'taxes_income',...
    'taxes_corp', 'LumpSumTax', 'ii', 'div_cap'};

for i = 1:length(nms)
    inm = find(strcmp(Params.aggnames,nms{i})); %#ok
    eval(['xagg(inm) = ' nms{i}  ';']);
end

par = xcurr(Params.nStatesDistr + Params.nagg:end);
Xtilde = [distr2par(D,Env);xagg;par];







end