%Run this after FullModel.m in order to compute Euler equation Errors.

if modelOptions.GHH
    error('Euler equation errors not yet coded for GHH preferences')
end

nEEE = 50;
nSimBetweenError = 1000;

% the grid for impatient household assets
testGrid = Params.knotDistrK;


%[EEAgg, EEimpatient, Xtrack] = EulerError(X, A_MPA, B_MPA, H_MPA, A_Dis, ADec_Dis, B_Dis, BDec_Dis, Env,nEEE,nSimBetweenError,testGrid);
[EEAgg, EEimpatient, LSE, Xtrack] = EulerError_G1(X, G1, impact, Env,nEEE,nSimBetweenError,testGrid);


Linf = log10(max(abs(EEAgg)'));
L1 = log10(mean(abs(EEAgg)'));
disp(' ')
disp('Aggregate Euler equation errors in log10')
disp('          capital    bond      imp. hhld   aggr.-cap.   aggr.-bond')
disp(['largest  ' num2str(Linf)])
disp(['mean     ' num2str(L1)])

Linf = log10(max(abs(LSE)'));
L1 = log10(mean(abs(LSE)'));
disp(' ')
disp('Labor supply errors in log10')
disp('          patient   impat.   total')
disp(['largest  ' num2str(Linf)])
disp(['mean     ' num2str(L1)])