clear all;
close all;
clc;

tauC = 0.053544485989;

load FullModel/results/experiment_0_FiscalAdj_4_search_0_sticky_1_robustness_0.mat;
%load FullModel/results/experiment_0_FiscalAdj_4_search_0_sticky_1_robustness_11.mat;
simaggdat = exact_soln.simaggdat;
names = exact_soln.names;
ststY = stst_soln.Y;






selectnames = {'Y', 'C', 'G', 'U',  'taxes_income', 'taxes_corp', 'taxes_prop', 'LumpSumTax', 'UI', 'ii', 'B'};

for i = 1:length(selectnames)
    eval(['i' selectnames{i} '= find(strcmp(names,''' selectnames{i} '''));']);
end

Y = simaggdat(iY,2:end);
U = max(simaggdat(iU,1:end-1),0.005);  %note UI spending is proportional to U
NetInterest = max(simaggdat(iii,1:end-1),0.005).*simaggdat(iB,1:end-1);
G = simaggdat(iG,2:end);
taxes_corp = max(simaggdat(itaxes_corp,2:end),0.05);
%taxes_corp = simaggdat(itaxes_corp,2:end);
taxes_income = simaggdat(itaxes_income,2:end) - simaggdat(iLumpSumTax,2:end); %note taxes_income includes LumpSumTax in model output
taxes_prop = simaggdat(itaxes_prop,2:end);
C = simaggdat(iC,2:end);
LumpSumTax = simaggdat(iLumpSumTax,2:end);
UI = simaggdat(iUI,2:end);
B = simaggdat(iB,1:end-1);

taxes_total = taxes_income  ...
    + tauC*C + taxes_prop + taxes_corp;

taxes_less_corp = taxes_income  ...
    + tauC*C + taxes_prop;


our_saving = taxes_total + LumpSumTax - G - 4*UI - NetInterest;



X = log([Y'   G' NetInterest' UI' taxes_corp' taxes_income' taxes_prop' C' taxes_total']);
names = {'GDP    G      NetInterest     UI    tax_corp   tax_inc    tax_prop    tax_sales  tax_total'};


disp('standard deviations')
disp(names)
disp(std(X))

disp('correlation with output')
V0 = corrcoef(X);
disp(names)
disp(V0(1,:))

disp('covariance with output')
V0 = cov(X);
disp(names)
disp(V0(1,:))


disp('------------------------------------------------------')

disp(' in levels ')

NetInterest = simaggdat(iii,1:end-1).*simaggdat(iB,1:end-1);

our_saving = taxes_total + LumpSumTax - G - 4*UI - NetInterest;


X = [Y' our_saving' G' NetInterest' UI' taxes_corp' taxes_income' taxes_prop' tauC*C'  taxes_total' taxes_less_corp' LumpSumTax' B']...
    /ststY;

%burn in
X = X(1001:end,:);

names = {'GDP  OurSaving     G      NetInterest     UI    tax_corp   tax_inc    tax_prop    tax_sales  tax_total tax_less_corp LumpSum  B'};


disp('standard deviations')
disp(names)
disp(std(X))

disp('correlation with output')
V0 = corrcoef(X);
disp(names)
disp(V0(1,:))

disp('covariance with output')
V0 = cov(X);
disp(names)
disp(V0(1,:))