%% solve the model

disp('Solving the model exactly')
[G1,impact,eu,abseig] = solveexact(Env);
if(~all(eu==1))  %signal failure:
    G1 = [];
    warning('sims:fails','sims failed');
end
    

%% Create observation matrix for all aggregate variables 

iA = Env.iVarAggr;  %might need to switch to iVarAggrBWS when we do do_mpa
niA = length(iA);

Hagg = sparse(1:niA,iA,ones(1,niA),niA,Params.ntotal)';
   


%% Compute IRFs

Sigma = Params.Sigma;
Sigma(2,2) = 1;
Sigma(3,3) = 1;



irf_agg = ir_sims(G1,impact,modelOptions.IRF_Length-1,Hagg',Sigma); 
clear Sigma;

%% conduct redistribution experiment
redistribution_IRF;
     

%% compute variances through simulation
disp('compute variances through simulation')


Sigma = Params.Sigma;
[ser, shocks] = simulateSystem(G1,impact,Hagg',modelOptions.sim_T,Sigma,Params.seed);
ser = ser +  Env.aggstst * ones(1,modelOptions.sim_T);
V0 = cov(ser');
simul_avg = mean(ser,2);



%% compute value functions using monte carlo integration
dowelf = modelOptions.robustness == 0;
%dowelf = false;
if dowelf
    disp('computing welfare....')
    [ststvpar, ststve, Evpar, Eve ] = welfare(G1,impact,[],[], par, xaggstst, Env);
    disp('done')
end

%% store results 


exact_soln.irf_agg = irf_agg;
exact_soln.names = Params.aggnames;
exact_soln.V0 = V0;
exact_soln.simul_avg = simul_avg;


%store welfare results
if dowelf
    exact_soln.ststvpar = ststvpar;
    exact_soln.ststve = ststve;
    exact_soln.Evpar = Evpar;
    exact_soln.Eve = Eve;
end


exact_soln.simaggdat = ser;
exact_soln.simshocks = shocks;

exact_soln.redisIRF = redisIRF;

