function xaggstst= agg_stst(margtaxe, taxpaide,D,par)

    x = broyden(@check_stst,[0;0.3],margtaxe, taxpaide,D,par);
    [~,~, xaggstst]=inner_calculation(x(1),x(2),margtaxe, taxpaide,D,par);
    

end


function resid = check_stst(x,margtaxe, taxpaide,D,par)

    lst = x(1);
    ne = x(2);

    [LumpSumTax, lr] =inner_calculation(lst,ne,margtaxe, taxpaide,D,par); 

    resid = [LumpSumTax-lst; lr];

end



function [LumpSumTax, laborResid, xaggstst]=inner_calculation(LumpSumTax, ne ,margtaxe, taxpaide,D,par)

    global Params modelOptions;
    
    
    %solve for steady state

    mpshock = 0; %#ok
    Gshock = 0; %#ok
    taxshock = 0; %#ok
    markupshock = 0; %#ok
    S = 1; %#ok
    ppi = 1; %#ok
    pstar = 1;%#ok

    
    [ z, M, wage, ii, r, rhat, KL] = SteadyStatePrices( margtaxe );
    YonN = KL^Params.alpha;



    %hhld variables:

    %total income of households:
    bh = expect_k(D) * Params.nu;  %this is end of period assets
    assetsh = bh;
    nh = expect_L(D,par) * Params.nu;
    Hrs = expect_L(D,par,false) * Params.nu + ne;   
    
    [ch, ~, taxpaidh] = expect_C(D,par,1+ii,wage); 
    
    
    %other

    skille = Params.skille; 

    A = zeros(9);
    C = zeros(9,1);
    iC = 1; ibe = 2; ice = 3; iN = 4; iK = 5; idiv = 6; ix = 7; iGDP = 8; ifirmValue = 9;


    % 1) C + G = Y - delta*K - fixedCost;  
    A(1,iC) = 1;
    A(1,iN) =  (Params.GonY -1) * YonN;
    A(1,iK) = Params.delta;
    C(1) = FixedCost(0);

    % 2)ce = C - ch*Params.nu;
    A(2,ice) = -1;
    A(2,iC) = 1;
    C(2) =  -Params.nu*ch;
    
    
    % 3) N = se * ne + nh
    A(3,iN) = -1;
    C(3) = nh + skille*ne;

    % 4) K = KL * N
    A(4,iK) = -1;
    A(4,iN) = KL;

    % 5) be + assetsh = debt2GDP * GDP
    A(5,ibe) = 1;
    A(5,iGDP) = -Params.debt2GDP;
    C(5) = assetsh;
    
    

    % 6)
    %div_intermed = (1-tauK)*(Y*(1 - M) - fixedCosts);
    %dividend =  div_intermed + div_cap - Params.tauP*firmValue;
    A(6,idiv) = -1;
    A(6,iK) = r;
    A(6,iN) = (1-Params.tauK)*YonN *(1- M);
    A(6,ifirmValue) = -Params.tauP;
    C(6) = -(1-Params.tauK)*FixedCost(0);
    

    % 7) xe = be*ii + Params.skille*ne*wage + dividend;
    A(7,ix) = -1;
    A(7,ibe) = ii;
    A(7,idiv) = 1;
    C(7) = skille*wage*ne;

    
    % 8) GDP = Y - fixedcosts
    A(8,iGDP) = -1;
    A(8,iN) =  YonN;
    C(8) = -FixedCost(0);
    

    % 9) 
    %div_cap = r*K;
    %firmValue = div_cap/(1+Params.tauP-Params.beta);
    A(9,ifirmValue) = -1;
    A(9,iK) = r/(1+Params.tauP-Params.betae);
    
    
    %A * x + C = 0
    x = -A\C;
    clear C;

    C = x(iC);  be = x(ibe); ce = x(ice); N = x(iN); K = x(iK);
    dividend = x(idiv); xe = x(ix); firmValue = x(ifirmValue);
    GDP = x(iGDP);

    if modelOptions.GHH
        laborResid = (1+Params.tauC) .* Params.psi1 .* ne.^Params.psi2  ./(Params.skille*wage.*(1-margtaxe))-1;  
    else
        laborResid = (1+Params.tauC) .* Params.psi1 .* ne.^Params.psi2  ./(ce.^(-Params.sigma)...
            .*Params.skille*wage.*(1-margtaxe))-1;  
    end

    Y = K^Params.alpha*N^(1-Params.alpha);
    B = Params.debt2GDP*GDP;

    
           
    
    seDist = zeros(Params.npp,1);
    for ip = 1:Params.npp
        seDist(ip) = expect_1(D,ip);
    end
    
    U = dot(seDist,Params.estatus == 2);
    NLF = dot(seDist,Params.estatus == 3);
    jobfind = expect_jobfind(D,par,0);
    
    seDist = seDist * Params.nu;
    assert( abs(sum(seDist)-Params.nu) < 1e-8);
    
    
    transferSpending = dot(seDist,Params.To+Params.Tu);
    

    fixedCost = FixedCost(0);

    G = Params.GonY * Y;
    
  
    corp_inc_tax_rev = Params.tauK*(Y *(1- M) - fixedCost) ...
        + Params.tauK*(1-Params.upsilon)/(1-Params.upsilon*Params.tauK)*rhat*K;
    
    revenue = Params.nu*taxpaidh + taxpaide + Params.tauC*C...
         + firmValue*Params.tauP + corp_inc_tax_rev;
    

    expenditure = G + B*ii + transferSpending;
    
   % disp(['expenditure/GDP = ' num2str(expenditure/GDP)])
   % disp(['revenue/GDP = ' num2str(revenue/GDP)])
    
    
    LumpSumTax = expenditure - revenue;
    taxes = revenue + LumpSumTax;
    taxes_income = Params.nu*taxpaidh + taxpaide;
    taxes_corp = corp_inc_tax_rev;
    taxes_prop = firmValue*Params.tauP;
    UI = dot(seDist, Params.Tu);

    if nargout < 3
        return
    end
    
   
        
    
    if modelOptions.FiscalAdj == 0 || modelOptions.FiscalAdj == 2 || modelOptions.FiscalAdj == 6
        Params.LumpSumTax = LumpSumTax;
    end
    if modelOptions.FiscalAdj == 6
        dtau = 0;
        Params.taxbase = xe + Params.nu*(ch*(1+Params.tauC) + taxpaidh) ...
            + taxes_corp/Params.tauK + taxes_prop/Params.tauP + C;
    end
    
       

    xaggstst = zeros(Params.nagg,1);
 

    pbarA = Y/(1-Params.betae*(1-Params.theta));
    pbarB = pbarA; %#ok

    
    Klag = K; %#ok
    div_cap = r*K;
    
    
    YLag = Y; %#ok
    iitrack1 = ii; %#ok
    
    Inv = Params.delta*K;
    
    Inv_track = Inv;
    Inv = Inv/(Y-G-FixedCost(0));
    ce_track = ce;
    ce = ce/(Y-G-FixedCost(0));
    
    margtaxe_track = margtaxe;    

    for i = 1:length(Params.aggnames)
        eval(['xaggstst(' num2str(i) ') = ' Params.aggnames{i} ';']);
    end
    
    
    disp(['LumpSumTax = ' num2str(LumpSumTax)])
    %assert(abs(Y-C-G-Params.delta*K-fixedCost) < 1e-6, 'Aggregate resource constraint does not hold');
end

